/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.provisio;

import ca.vanzyl.provisio.model.ProvisioningContext;

public final class ProvisioVariables {
    private static final String VARIABLE_PREFIX = "provisio.";
    public static final String ALLOW_TARGET_OVERWRITE = "provisio.allowTargetOverwrite";
    public static final String FALLBACK_TARGET_FILE_NAME_MODE = "provisio.fallbackTargetFileNameMode";
    public static final String GA_SEPARATOR = "provisio.gaSeparator";
    public static final String GA_MAX_FILE_NAME_LENGTH = "provisio.maxFileNameLength";

    private ProvisioVariables() {
    }

    public static boolean allowTargetOverwrite(ProvisioningContext context) {
        return Boolean.parseBoolean(context.getVariables().getOrDefault(ALLOW_TARGET_OVERWRITE, Boolean.FALSE.toString()));
    }

    public static FallBackTargetFileNameMode fallbackTargetFileNameMode(ProvisioningContext context) {
        return FallBackTargetFileNameMode.valueOf(context.getVariables().getOrDefault(FALLBACK_TARGET_FILE_NAME_MODE, FallBackTargetFileNameMode.ARTIFACT_FILE_NAME.name()));
    }

    public static String gaSeparator(ProvisioningContext context) {
        return context.getVariables().getOrDefault(GA_SEPARATOR, "_");
    }

    public static int gaMaxFileNameLength(ProvisioningContext context) {
        return Integer.parseInt(context.getVariables().getOrDefault(GA_MAX_FILE_NAME_LENGTH, "64"));
    }

    public static enum FallBackTargetFileNameMode {
        ARTIFACT_FILE_NAME,
        GA;

    }
}

