/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CQ;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.LA1;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XAD;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXO
extends AbstractSegment {
    public RXO(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Give Code");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Amount - Minimum");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Amount - Maximum");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Give Units");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Dosage Form");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider's Pharmacy/Treatment Instructions");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider's Administration Instructions");
            this.add(LA1.class, false, 1, 0, new Object[]{this.getMessage()}, "Deliver-To Location");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(161)}, "Allow Substitutions");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Dispense Code");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Dispense Amount");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Dispense Units");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Number Of Refills");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Ordering Provider's DEA Number");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Pharmacist/Treatment Supplier's Verifier ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Needs Human Review");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Per (Time Unit)");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Requested Give Strength");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Give Strength Units");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Indication");
            this.add(ST.class, false, 1, 6, new Object[]{this.getMessage()}, "Requested Give Rate Amount");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Give Rate Units");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage()}, "Total Daily Dose");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Supplementary Code");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Requested Drug Strength Volume");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Requested Drug Strength Volume Units");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(480)}, "Pharmacy Order Type");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Dispensing Interval");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Medication Instance Identifier");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Segment Instance Identifier");
            this.add(CNE.class, false, 1, 2, new Object[]{this.getMessage()}, "Mood Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Dispensing Pharmacy");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "Dispensing Pharmacy Address");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Deliver-to Patient Location");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "Deliver-to Address");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXO - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getRequestedGiveCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getRxo1_RequestedGiveCode() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRequestedGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxo2_RequestedGiveAmountMinimum() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRequestedGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getRxo3_RequestedGiveAmountMaximum() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRequestedGiveUnits() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRxo4_RequestedGiveUnits() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRequestedDosageForm() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getRxo5_RequestedDosageForm() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE[] getProviderSPharmacyTreatmentInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxo6_ProviderSPharmacyTreatmentInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(6, (Type[])new CWE[0]);
        return retVal;
    }

    public int getProviderSPharmacyTreatmentInstructionsReps() {
        return this.getReps(6);
    }

    public CWE getProviderSPharmacyTreatmentInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public CWE getRxo6_ProviderSPharmacyTreatmentInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getRxo6_ProviderSPharmacyTreatmentInstructionsReps() {
        return this.getReps(6);
    }

    public CWE insertProviderSPharmacyTreatmentInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE insertRxo6_ProviderSPharmacyTreatmentInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(6, rep);
    }

    public CWE removeProviderSPharmacyTreatmentInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE removeRxo6_ProviderSPharmacyTreatmentInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(6, rep);
    }

    public CWE[] getProviderSAdministrationInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxo7_ProviderSAdministrationInstructions() {
        CWE[] retVal = (CWE[])this.getTypedField(7, (Type[])new CWE[0]);
        return retVal;
    }

    public int getProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CWE getProviderSAdministrationInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public CWE getRxo7_ProviderSAdministrationInstructions(int rep) {
        CWE retVal = (CWE)this.getTypedField(7, rep);
        return retVal;
    }

    public int getRxo7_ProviderSAdministrationInstructionsReps() {
        return this.getReps(7);
    }

    public CWE insertProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE insertRxo7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(7, rep);
    }

    public CWE removeProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public CWE removeRxo7_ProviderSAdministrationInstructions(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(7, rep);
    }

    public LA1 getDeliverToLocation() {
        LA1 retVal = (LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public LA1 getRxo8_DeliverToLocation() {
        LA1 retVal = (LA1)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getAllowSubstitutions() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getRxo9_AllowSubstitutions() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getRequestedDispenseCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getRxo10_RequestedDispenseCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getRequestedDispenseAmount() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getRxo11_RequestedDispenseAmount() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getRequestedDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getRxo12_RequestedDispenseUnits() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public NM getNumberOfRefills() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getRxo13_NumberOfRefills() {
        NM retVal = (NM)this.getTypedField(13, 0);
        return retVal;
    }

    public XCN[] getOrderingProviderSDEANumber() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRxo14_OrderingProviderSDEANumber() {
        XCN[] retVal = (XCN[])this.getTypedField(14, (Type[])new XCN[0]);
        return retVal;
    }

    public int getOrderingProviderSDEANumberReps() {
        return this.getReps(14);
    }

    public XCN getOrderingProviderSDEANumber(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public XCN getRxo14_OrderingProviderSDEANumber(int rep) {
        XCN retVal = (XCN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getRxo14_OrderingProviderSDEANumberReps() {
        return this.getReps(14);
    }

    public XCN insertOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN insertRxo14_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(14, rep);
    }

    public XCN removeOrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN removeRxo14_OrderingProviderSDEANumber(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(14, rep);
    }

    public XCN[] getPharmacistTreatmentSupplierSVerifierID() {
        XCN[] retVal = (XCN[])this.getTypedField(15, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRxo15_PharmacistTreatmentSupplierSVerifierID() {
        XCN[] retVal = (XCN[])this.getTypedField(15, (Type[])new XCN[0]);
        return retVal;
    }

    public int getPharmacistTreatmentSupplierSVerifierIDReps() {
        return this.getReps(15);
    }

    public XCN getPharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN retVal = (XCN)this.getTypedField(15, rep);
        return retVal;
    }

    public XCN getRxo15_PharmacistTreatmentSupplierSVerifierID(int rep) {
        XCN retVal = (XCN)this.getTypedField(15, rep);
        return retVal;
    }

    public int getRxo15_PharmacistTreatmentSupplierSVerifierIDReps() {
        return this.getReps(15);
    }

    public XCN insertPharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(15, rep);
    }

    public XCN insertRxo15_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(15, rep);
    }

    public XCN removePharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(15, rep);
    }

    public XCN removeRxo15_PharmacistTreatmentSupplierSVerifierID(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(15, rep);
    }

    public ID getNeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getRxo16_NeedsHumanReview() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getRequestedGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getRxo17_RequestedGivePerTimeUnit() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getRequestedGiveStrength() {
        NM retVal = (NM)this.getTypedField(18, 0);
        return retVal;
    }

    public NM getRxo18_RequestedGiveStrength() {
        NM retVal = (NM)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getRequestedGiveStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getRxo19_RequestedGiveStrengthUnits() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE[] getIndication() {
        CWE[] retVal = (CWE[])this.getTypedField(20, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxo20_Indication() {
        CWE[] retVal = (CWE[])this.getTypedField(20, (Type[])new CWE[0]);
        return retVal;
    }

    public int getIndicationReps() {
        return this.getReps(20);
    }

    public CWE getIndication(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public CWE getRxo20_Indication(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getRxo20_IndicationReps() {
        return this.getReps(20);
    }

    public CWE insertIndication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE insertRxo20_Indication(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE removeIndication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public CWE removeRxo20_Indication(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public ST getRequestedGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getRxo21_RequestedGiveRateAmount() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getRequestedGiveRateUnits() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CWE getRxo22_RequestedGiveRateUnits() {
        CWE retVal = (CWE)this.getTypedField(22, 0);
        return retVal;
    }

    public CQ getTotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(23, 0);
        return retVal;
    }

    public CQ getRxo23_TotalDailyDose() {
        CQ retVal = (CQ)this.getTypedField(23, 0);
        return retVal;
    }

    public CWE[] getSupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRxo24_SupplementaryCode() {
        CWE[] retVal = (CWE[])this.getTypedField(24, (Type[])new CWE[0]);
        return retVal;
    }

    public int getSupplementaryCodeReps() {
        return this.getReps(24);
    }

    public CWE getSupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public CWE getRxo24_SupplementaryCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(24, rep);
        return retVal;
    }

    public int getRxo24_SupplementaryCodeReps() {
        return this.getReps(24);
    }

    public CWE insertSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE insertRxo24_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(24, rep);
    }

    public CWE removeSupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public CWE removeRxo24_SupplementaryCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(24, rep);
    }

    public NM getRequestedDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getRxo25_RequestedDrugStrengthVolume() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public CWE getRequestedDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public CWE getRxo26_RequestedDrugStrengthVolumeUnits() {
        CWE retVal = (CWE)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getPharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ID getRxo27_PharmacyOrderType() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public NM getDispensingInterval() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getRxo28_DispensingInterval() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public EI getMedicationInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(29, 0);
        return retVal;
    }

    public EI getRxo29_MedicationInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(29, 0);
        return retVal;
    }

    public EI getSegmentInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(30, 0);
        return retVal;
    }

    public EI getRxo30_SegmentInstanceIdentifier() {
        EI retVal = (EI)this.getTypedField(30, 0);
        return retVal;
    }

    public CNE getMoodCode() {
        CNE retVal = (CNE)this.getTypedField(31, 0);
        return retVal;
    }

    public CNE getRxo31_MoodCode() {
        CNE retVal = (CNE)this.getTypedField(31, 0);
        return retVal;
    }

    public CWE getDispensingPharmacy() {
        CWE retVal = (CWE)this.getTypedField(32, 0);
        return retVal;
    }

    public CWE getRxo32_DispensingPharmacy() {
        CWE retVal = (CWE)this.getTypedField(32, 0);
        return retVal;
    }

    public XAD getDispensingPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(33, 0);
        return retVal;
    }

    public XAD getRxo33_DispensingPharmacyAddress() {
        XAD retVal = (XAD)this.getTypedField(33, 0);
        return retVal;
    }

    public PL getDeliverToPatientLocation() {
        PL retVal = (PL)this.getTypedField(34, 0);
        return retVal;
    }

    public PL getRxo34_DeliverToPatientLocation() {
        PL retVal = (PL)this.getTypedField(34, 0);
        return retVal;
    }

    public XAD getDeliverToAddress() {
        XAD retVal = (XAD)this.getTypedField(35, 0);
        return retVal;
    }

    public XAD getRxo35_DeliverToAddress() {
        XAD retVal = (XAD)this.getTypedField(35, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new LA1(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(161));
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new NM(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new XCN(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new NM(this.getMessage());
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new CWE(this.getMessage());
            }
            case 22: {
                return new CQ(this.getMessage());
            }
            case 23: {
                return new CWE(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CWE(this.getMessage());
            }
            case 26: {
                return new ID(this.getMessage(), new Integer(480));
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new EI(this.getMessage());
            }
            case 29: {
                return new EI(this.getMessage());
            }
            case 30: {
                return new CNE(this.getMessage());
            }
            case 31: {
                return new CWE(this.getMessage());
            }
            case 32: {
                return new XAD(this.getMessage());
            }
            case 33: {
                return new PL(this.getMessage());
            }
            case 34: {
                return new XAD(this.getMessage());
            }
        }
        return null;
    }
}

