/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PSG
extends AbstractSegment {
    public PSG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 73, new Object[]{this.getMessage()}, "Provider Product/Service Group Number");
            this.add(EI.class, false, 1, 73, new Object[]{this.getMessage()}, "Payer Product/Service Group Number");
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Product/Service Group Sequence Number");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Adjudicate as Group");
            this.add(CP.class, true, 1, 254, new Object[]{this.getMessage()}, "Product/Service Group Billed Amount");
            this.add(ST.class, true, 1, 254, new Object[]{this.getMessage()}, "Product/Service Group Description");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PSG - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getProviderProductServiceGroupNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPsg1_ProviderProductServiceGroupNumber() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getPayerProductServiceGroupNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getPsg2_PayerProductServiceGroupNumber() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public SI getProductServiceGroupSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public SI getPsg3_ProductServiceGroupSequenceNumber() {
        SI retVal = (SI)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getAdjudicateAsGroup() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getPsg4_AdjudicateAsGroup() {
        ID retVal = (ID)this.getTypedField(4, 0);
        return retVal;
    }

    public CP getProductServiceGroupBilledAmount() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    public CP getPsg5_ProductServiceGroupBilledAmount() {
        CP retVal = (CP)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getProductServiceGroupDescription() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPsg6_ProductServiceGroupDescription() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new SI(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 4: {
                return new CP(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

