/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IVT
extends AbstractSegment {
    public IVT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set Id - IVT");
            this.add(EI.class, true, 1, 250, new Object[]{this.getMessage()}, "Inventory Location Identifier");
            this.add(ST.class, false, 1, 999, new Object[]{this.getMessage()}, "Inventory Location Name");
            this.add(EI.class, false, 1, 250, new Object[]{this.getMessage()}, "Source Location Identifier");
            this.add(ST.class, false, 1, 999, new Object[]{this.getMessage()}, "Source Location Name");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Item Status");
            this.add(EI.class, false, 0, 250, new Object[]{this.getMessage()}, "Bin Location Identifier");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Order Packaging");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Issue Packaging");
            this.add(EI.class, false, 1, 16, new Object[]{this.getMessage()}, "Default Inventory Asset Account");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Patient Chargeable Indicator");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Transaction Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction amount - unit");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Item Importance Code");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Stocked Item Indicator");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Consignment Item Indicator");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Reusable Item Indicator");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Reusable Cost");
            this.add(EI.class, false, 0, 250, new Object[]{this.getMessage()}, "Substitute Item Identifier");
            this.add(EI.class, false, 1, 250, new Object[]{this.getMessage()}, "Latex-Free Substitute Item Identifier");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Recommended Reorder Theory");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Recommended Safety Stock Days");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Recommended Maximum Days Inventory");
            this.add(NM.class, false, 1, 8, new Object[]{this.getMessage()}, "Recommended Order Point");
            this.add(NM.class, false, 1, 8, new Object[]{this.getMessage()}, "Recommended Order Amount");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Operating Room Par Level Indicator");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating IVT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIdIVT() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIvt1_SetIdIVT() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getInventoryLocationIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getIvt2_InventoryLocationIdentifier() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getInventoryLocationName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getIvt3_InventoryLocationName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getSourceLocationIdentifier() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getIvt4_SourceLocationIdentifier() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getSourceLocationName() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getIvt5_SourceLocationName() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getItemStatus() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getIvt6_ItemStatus() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public EI[] getBinLocationIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(7, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getIvt7_BinLocationIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(7, (Type[])new EI[0]);
        return retVal;
    }

    public int getBinLocationIdentifierReps() {
        return this.getReps(7);
    }

    public EI getBinLocationIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(7, rep);
        return retVal;
    }

    public EI getIvt7_BinLocationIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(7, rep);
        return retVal;
    }

    public int getIvt7_BinLocationIdentifierReps() {
        return this.getReps(7);
    }

    public EI insertBinLocationIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(7, rep);
    }

    public EI insertIvt7_BinLocationIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(7, rep);
    }

    public EI removeBinLocationIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(7, rep);
    }

    public EI removeIvt7_BinLocationIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(7, rep);
    }

    public CWE getOrderPackaging() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getIvt8_OrderPackaging() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getIssuePackaging() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getIvt9_IssuePackaging() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public EI getDefaultInventoryAssetAccount() {
        EI retVal = (EI)this.getTypedField(10, 0);
        return retVal;
    }

    public EI getIvt10_DefaultInventoryAssetAccount() {
        EI retVal = (EI)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getPatientChargeableIndicator() {
        CNE retVal = (CNE)this.getTypedField(11, 0);
        return retVal;
    }

    public CNE getIvt11_PatientChargeableIndicator() {
        CNE retVal = (CNE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getTransactionCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getIvt12_TransactionCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getTransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getIvt13_TransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CWE getItemImportanceCode() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getIvt14_ItemImportanceCode() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CNE getStockedItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(15, 0);
        return retVal;
    }

    public CNE getIvt15_StockedItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(15, 0);
        return retVal;
    }

    public CNE getConsignmentItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(16, 0);
        return retVal;
    }

    public CNE getIvt16_ConsignmentItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(16, 0);
        return retVal;
    }

    public CNE getReusableItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(17, 0);
        return retVal;
    }

    public CNE getIvt17_ReusableItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(17, 0);
        return retVal;
    }

    public CP getReusableCost() {
        CP retVal = (CP)this.getTypedField(18, 0);
        return retVal;
    }

    public CP getIvt18_ReusableCost() {
        CP retVal = (CP)this.getTypedField(18, 0);
        return retVal;
    }

    public EI[] getSubstituteItemIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(19, (Type[])new EI[0]);
        return retVal;
    }

    public EI[] getIvt19_SubstituteItemIdentifier() {
        EI[] retVal = (EI[])this.getTypedField(19, (Type[])new EI[0]);
        return retVal;
    }

    public int getSubstituteItemIdentifierReps() {
        return this.getReps(19);
    }

    public EI getSubstituteItemIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(19, rep);
        return retVal;
    }

    public EI getIvt19_SubstituteItemIdentifier(int rep) {
        EI retVal = (EI)this.getTypedField(19, rep);
        return retVal;
    }

    public int getIvt19_SubstituteItemIdentifierReps() {
        return this.getReps(19);
    }

    public EI insertSubstituteItemIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(19, rep);
    }

    public EI insertIvt19_SubstituteItemIdentifier(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(19, rep);
    }

    public EI removeSubstituteItemIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(19, rep);
    }

    public EI removeIvt19_SubstituteItemIdentifier(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(19, rep);
    }

    public EI getLatexFreeSubstituteItemIdentifier() {
        EI retVal = (EI)this.getTypedField(20, 0);
        return retVal;
    }

    public EI getIvt20_LatexFreeSubstituteItemIdentifier() {
        EI retVal = (EI)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getRecommendedReorderTheory() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getIvt21_RecommendedReorderTheory() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public NM getRecommendedSafetyStockDays() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getIvt22_RecommendedSafetyStockDays() {
        NM retVal = (NM)this.getTypedField(22, 0);
        return retVal;
    }

    public NM getRecommendedMaximumDaysInventory() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getIvt23_RecommendedMaximumDaysInventory() {
        NM retVal = (NM)this.getTypedField(23, 0);
        return retVal;
    }

    public NM getRecommendedOrderPoint() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getIvt24_RecommendedOrderPoint() {
        NM retVal = (NM)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getRecommendedOrderAmount() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getIvt25_RecommendedOrderAmount() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public CNE getOperatingRoomParLevelIndicator() {
        CNE retVal = (CNE)this.getTypedField(26, 0);
        return retVal;
    }

    public CNE getIvt26_OperatingRoomParLevelIndicator() {
        CNE retVal = (CNE)this.getTypedField(26, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new EI(this.getMessage());
            }
            case 10: {
                return new CNE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CNE(this.getMessage());
            }
            case 15: {
                return new CNE(this.getMessage());
            }
            case 16: {
                return new CNE(this.getMessage());
            }
            case 17: {
                return new CP(this.getMessage());
            }
            case 18: {
                return new EI(this.getMessage());
            }
            case 19: {
                return new EI(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new NM(this.getMessage());
            }
            case 22: {
                return new NM(this.getMessage());
            }
            case 23: {
                return new NM(this.getMessage());
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

