/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CCP;
import ca.uhn.hl7v2.model.v251.datatype.CSU;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.NR;
import ca.uhn.hl7v2.model.v251.datatype.WVI;
import ca.uhn.hl7v2.model.v251.datatype.WVS;

public class CD
extends AbstractComposite {
    private Type[] data;

    public CD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[6];
        this.data[0] = new WVI(this.getMessage());
        this.data[1] = new WVS(this.getMessage());
        this.data[2] = new CSU(this.getMessage());
        this.data[3] = new CCP(this.getMessage());
        this.data[4] = new NM(this.getMessage());
        this.data[5] = new NR(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public WVI getChannelIdentifier() {
        return (WVI)this.getTyped(0, WVI.class);
    }

    public WVI getCd1_ChannelIdentifier() {
        return (WVI)this.getTyped(0, WVI.class);
    }

    public WVS getWaveformSource() {
        return (WVS)this.getTyped(1, WVS.class);
    }

    public WVS getCd2_WaveformSource() {
        return (WVS)this.getTyped(1, WVS.class);
    }

    public CSU getChannelSensitivityUnits() {
        return (CSU)this.getTyped(2, CSU.class);
    }

    public CSU getCd3_ChannelSensitivityUnits() {
        return (CSU)this.getTyped(2, CSU.class);
    }

    public CCP getChannelCalibrationParameters() {
        return (CCP)this.getTyped(3, CCP.class);
    }

    public CCP getCd4_ChannelCalibrationParameters() {
        return (CCP)this.getTyped(3, CCP.class);
    }

    public NM getChannelSamplingFrequency() {
        return (NM)this.getTyped(4, NM.class);
    }

    public NM getCd5_ChannelSamplingFrequency() {
        return (NM)this.getTyped(4, NM.class);
    }

    public NR getMinimumMaximumDataValues() {
        return (NR)this.getTyped(5, NR.class);
    }

    public NR getCd6_MinimumMaximumDataValues() {
        return (NR)this.getTyped(5, NR.class);
    }
}

