/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.EVN;
import ca.uhn.hl7v2.model.v251.segment.IAM;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.model.v251.segment.PV1;
import ca.uhn.hl7v2.model.v251.segment.PV2;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A60
extends AbstractMessage {
    public ADT_A60() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A60(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PV1.class, false, false);
            this.add(PV2.class, false, false);
            this.add(IAM.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_A60 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return (PV2)this.getTyped("PV2", PV2.class);
    }

    public IAM getIAM() {
        return (IAM)this.getTyped("IAM", IAM.class);
    }

    public IAM getIAM(int rep) {
        return (IAM)this.getTyped("IAM", rep, IAM.class);
    }

    public int getIAMReps() {
        return this.getReps("IAM");
    }

    public List<IAM> getIAMAll() throws HL7Exception {
        return this.getAllAsList("IAM", IAM.class);
    }

    public void insertIAM(IAM structure, int rep) throws HL7Exception {
        super.insertRepetition("IAM", (Structure)structure, rep);
    }

    public IAM insertIAM(int rep) throws HL7Exception {
        return (IAM)super.insertRepetition("IAM", rep);
    }

    public IAM removeIAM(int rep) throws HL7Exception {
        return (IAM)super.removeRepetition("IAM", rep);
    }
}

