/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.OBX;
import ca.uhn.hl7v2.model.v251.segment.SAC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMG_O19_CONTAINER
extends AbstractGroup {
    public OMG_O19_CONTAINER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SAC.class, true, false, false);
            this.add(OBX.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OMG_O19_CONTAINER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public SAC getSAC() {
        SAC retVal = (SAC)this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }
}

