/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.SAC;
import ca.uhn.hl7v2.model.v25.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORL_O34_ORDER_SPECIMEN
extends AbstractGroup {
    public ORL_O34_ORDER_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(SAC.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O34_ORDER_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public SAC getSAC() {
        SAC retVal = (SAC)this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public SAC getSAC(int rep) {
        SAC retVal = (SAC)this.getTyped("SAC", rep, SAC.class);
        return retVal;
    }

    public int getSACReps() {
        return this.getReps("SAC");
    }

    public List<SAC> getSACAll() throws HL7Exception {
        return this.getAllAsList("SAC", SAC.class);
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", (Structure)structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }
}

