/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.DOC_T12_RESULT;
import ca.uhn.hl7v2.model.v25.segment.DSC;
import ca.uhn.hl7v2.model.v25.segment.ERR;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.QAK;
import ca.uhn.hl7v2.model.v25.segment.QRD;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOC_T12
extends AbstractMessage {
    public DOC_T12() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public DOC_T12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(DOC_T12_RESULT.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DOC_T12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public QAK getQAK() {
        return (QAK)this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public DOC_T12_RESULT getRESULT() {
        return (DOC_T12_RESULT)this.getTyped("RESULT", DOC_T12_RESULT.class);
    }

    public DOC_T12_RESULT getRESULT(int rep) {
        return (DOC_T12_RESULT)this.getTyped("RESULT", rep, DOC_T12_RESULT.class);
    }

    public int getRESULTReps() {
        return this.getReps("RESULT");
    }

    public List<DOC_T12_RESULT> getRESULTAll() throws HL7Exception {
        return this.getAllAsList("RESULT", DOC_T12_RESULT.class);
    }

    public void insertRESULT(DOC_T12_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULT", (Structure)structure, rep);
    }

    public DOC_T12_RESULT insertRESULT(int rep) throws HL7Exception {
        return (DOC_T12_RESULT)super.insertRepetition("RESULT", rep);
    }

    public DOC_T12_RESULT removeRESULT(int rep) throws HL7Exception {
        return (DOC_T12_RESULT)super.removeRepetition("RESULT", rep);
    }

    public DSC getDSC() {
        return (DSC)this.getTyped("DSC", DSC.class);
    }
}

