/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.RPA_I08_AUTHORIZATION_1;
import ca.uhn.hl7v2.model.v25.group.RPA_I08_INSURANCE;
import ca.uhn.hl7v2.model.v25.group.RPA_I08_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.RPA_I08_PROCEDURE;
import ca.uhn.hl7v2.model.v25.group.RPA_I08_PROVIDER;
import ca.uhn.hl7v2.model.v25.group.RPA_I08_VISIT;
import ca.uhn.hl7v2.model.v25.segment.ACC;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.model.v25.segment.DG1;
import ca.uhn.hl7v2.model.v25.segment.DRG;
import ca.uhn.hl7v2.model.v25.segment.GT1;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NK1;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.RF1;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RPA_I08
extends AbstractMessage {
    public RPA_I08() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public RPA_I08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MSA.class, true, false);
            this.add(RF1.class, false, false);
            this.add(RPA_I08_AUTHORIZATION_1.class, false, false);
            this.add(RPA_I08_PROVIDER.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(GT1.class, false, true);
            this.add(RPA_I08_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RPA_I08_PROCEDURE.class, true, true);
            this.add(RPA_I08_OBSERVATION.class, false, true);
            this.add(RPA_I08_VISIT.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating RPA_I08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MSA getMSA() {
        MSA ret = null;
        try {
            ret = (MSA)this.get("MSA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RF1 getRF1() {
        RF1 ret = null;
        try {
            ret = (RF1)this.get("RF1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RPA_I08_AUTHORIZATION_1 getAUTHORIZATION_1() {
        RPA_I08_AUTHORIZATION_1 ret = null;
        try {
            ret = (RPA_I08_AUTHORIZATION_1)this.get("AUTHORIZATION_1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RPA_I08_PROVIDER getPROVIDER() {
        RPA_I08_PROVIDER ret = null;
        try {
            ret = (RPA_I08_PROVIDER)this.get("PROVIDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RPA_I08_PROVIDER getPROVIDER(int rep) {
        RPA_I08_PROVIDER ret = null;
        try {
            ret = (RPA_I08_PROVIDER)this.get("PROVIDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROVIDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROVIDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROVIDER(RPA_I08_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", (Structure)structure, rep);
    }

    public RPA_I08_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RPA_I08_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RPA_I08_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RPA_I08_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1(int rep) {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNK1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("NK1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public GT1 getGT1() {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public GT1 getGT1(int rep) {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("GT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public RPA_I08_INSURANCE getINSURANCE() {
        RPA_I08_INSURANCE ret = null;
        try {
            ret = (RPA_I08_INSURANCE)this.get("INSURANCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RPA_I08_INSURANCE getINSURANCE(int rep) {
        RPA_I08_INSURANCE ret = null;
        try {
            ret = (RPA_I08_INSURANCE)this.get("INSURANCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getINSURANCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("INSURANCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertINSURANCE(RPA_I08_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public RPA_I08_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (RPA_I08_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public RPA_I08_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (RPA_I08_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        ACC ret = null;
        try {
            ret = (ACC)this.get("ACC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1() {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1(int rep) {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        DRG ret = null;
        try {
            ret = (DRG)this.get("DRG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DRG getDRG(int rep) {
        DRG ret = null;
        try {
            ret = (DRG)this.get("DRG", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDRGReps() {
        int reps = -1;
        try {
            reps = this.getAll("DRG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", (Structure)structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1(int rep) {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getAL1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("AL1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RPA_I08_PROCEDURE getPROCEDURE() {
        RPA_I08_PROCEDURE ret = null;
        try {
            ret = (RPA_I08_PROCEDURE)this.get("PROCEDURE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RPA_I08_PROCEDURE getPROCEDURE(int rep) {
        RPA_I08_PROCEDURE ret = null;
        try {
            ret = (RPA_I08_PROCEDURE)this.get("PROCEDURE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROCEDUREReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROCEDURE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROCEDURE(RPA_I08_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public RPA_I08_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (RPA_I08_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public RPA_I08_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (RPA_I08_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public RPA_I08_OBSERVATION getOBSERVATION() {
        RPA_I08_OBSERVATION ret = null;
        try {
            ret = (RPA_I08_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RPA_I08_OBSERVATION getOBSERVATION(int rep) {
        RPA_I08_OBSERVATION ret = null;
        try {
            ret = (RPA_I08_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(RPA_I08_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RPA_I08_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RPA_I08_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RPA_I08_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RPA_I08_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public RPA_I08_VISIT getVISIT() {
        RPA_I08_VISIT ret = null;
        try {
            ret = (RPA_I08_VISIT)this.get("VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

