/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.SRR_S01_PATIENT;
import ca.uhn.hl7v2.model.v25.group.SRR_S01_RESOURCES;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.SCH;
import ca.uhn.hl7v2.model.v25.segment.TQ1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SRR_S01_SCHEDULE
extends AbstractGroup {
    public SRR_S01_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCH.class, true, false);
            this.add(TQ1.class, false, true);
            this.add(NTE.class, false, true);
            this.add(SRR_S01_PATIENT.class, false, true);
            this.add(SRR_S01_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating SRR_S01_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public SCH getSCH() {
        SCH ret = null;
        try {
            ret = (SCH)this.get("SCH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TQ1 getTQ1() {
        TQ1 ret = null;
        try {
            ret = (TQ1)this.get("TQ1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TQ1 getTQ1(int rep) {
        TQ1 ret = null;
        try {
            ret = (TQ1)this.get("TQ1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTQ1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("TQ1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTQ1(TQ1 structure, int rep) throws HL7Exception {
        super.insertRepetition("TQ1", (Structure)structure, rep);
    }

    public TQ1 insertTQ1(int rep) throws HL7Exception {
        return (TQ1)super.insertRepetition("TQ1", rep);
    }

    public TQ1 removeTQ1(int rep) throws HL7Exception {
        return (TQ1)super.removeRepetition("TQ1", rep);
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SRR_S01_PATIENT getPATIENT() {
        SRR_S01_PATIENT ret = null;
        try {
            ret = (SRR_S01_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRR_S01_PATIENT getPATIENT(int rep) {
        SRR_S01_PATIENT ret = null;
        try {
            ret = (SRR_S01_PATIENT)this.get("PATIENT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPATIENTReps() {
        int reps = -1;
        try {
            reps = this.getAll("PATIENT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPATIENT(SRR_S01_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public SRR_S01_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (SRR_S01_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public SRR_S01_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (SRR_S01_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public SRR_S01_RESOURCES getRESOURCES() {
        SRR_S01_RESOURCES ret = null;
        try {
            ret = (SRR_S01_RESOURCES)this.get("RESOURCES");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SRR_S01_RESOURCES getRESOURCES(int rep) {
        SRR_S01_RESOURCES ret = null;
        try {
            ret = (SRR_S01_RESOURCES)this.get("RESOURCES", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRESOURCESReps() {
        int reps = -1;
        try {
            reps = this.getAll("RESOURCES").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRESOURCES(SRR_S01_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", (Structure)structure, rep);
    }

    public SRR_S01_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SRR_S01_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SRR_S01_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SRR_S01_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

