/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.OMP_O09_ORDER;
import ca.uhn.hl7v2.model.v24.group.OMP_O09_PATIENT;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMP_O09
extends AbstractMessage {
    public OMP_O09() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OMP_O09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMP_O09_PATIENT.class, false, false);
            this.add(OMP_O09_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMP_O09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMP_O09_PATIENT getPATIENT() {
        return (OMP_O09_PATIENT)this.getTyped("PATIENT", OMP_O09_PATIENT.class);
    }

    public OMP_O09_ORDER getORDER() {
        return (OMP_O09_ORDER)this.getTyped("ORDER", OMP_O09_ORDER.class);
    }

    public OMP_O09_ORDER getORDER(int rep) {
        return (OMP_O09_ORDER)this.getTyped("ORDER", rep, OMP_O09_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OMP_O09_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OMP_O09_ORDER.class);
    }

    public void insertORDER(OMP_O09_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public OMP_O09_ORDER insertORDER(int rep) throws HL7Exception {
        return (OMP_O09_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OMP_O09_ORDER removeORDER(int rep) throws HL7Exception {
        return (OMP_O09_ORDER)super.removeRepetition("ORDER", rep);
    }
}

