/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.OMD_O01_ORCODSNTEOBXNTE;
import ca.uhn.hl7v2.model.v231.group.OMD_O01_ORCODTNTE;
import ca.uhn.hl7v2.model.v231.group.OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMD_O01
extends AbstractMessage {
    public OMD_O01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OMD_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class, false, false);
            this.add(OMD_O01_ORCODSNTEOBXNTE.class, true, true);
            this.add(OMD_O01_ORCODTNTE.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OMD_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 getPIDPD1NTEPV1PV2IN1IN2IN3GT1AL1() {
        return (OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1)this.getTyped("PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1", OMD_O01_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1.class);
    }

    public OMD_O01_ORCODSNTEOBXNTE getORCODSNTEOBXNTE() {
        return (OMD_O01_ORCODSNTEOBXNTE)this.getTyped("ORCODSNTEOBXNTE", OMD_O01_ORCODSNTEOBXNTE.class);
    }

    public OMD_O01_ORCODSNTEOBXNTE getORCODSNTEOBXNTE(int rep) {
        return (OMD_O01_ORCODSNTEOBXNTE)this.getTyped("ORCODSNTEOBXNTE", rep, OMD_O01_ORCODSNTEOBXNTE.class);
    }

    public int getORCODSNTEOBXNTEReps() {
        return this.getReps("ORCODSNTEOBXNTE");
    }

    public List<OMD_O01_ORCODSNTEOBXNTE> getORCODSNTEOBXNTEAll() throws HL7Exception {
        return this.getAllAsList("ORCODSNTEOBXNTE", OMD_O01_ORCODSNTEOBXNTE.class);
    }

    public void insertORCODSNTEOBXNTE(OMD_O01_ORCODSNTEOBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCODSNTEOBXNTE", (Structure)structure, rep);
    }

    public OMD_O01_ORCODSNTEOBXNTE insertORCODSNTEOBXNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODSNTEOBXNTE)super.insertRepetition("ORCODSNTEOBXNTE", rep);
    }

    public OMD_O01_ORCODSNTEOBXNTE removeORCODSNTEOBXNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODSNTEOBXNTE)super.removeRepetition("ORCODSNTEOBXNTE", rep);
    }

    public OMD_O01_ORCODTNTE getORCODTNTE() {
        return (OMD_O01_ORCODTNTE)this.getTyped("ORCODTNTE", OMD_O01_ORCODTNTE.class);
    }

    public OMD_O01_ORCODTNTE getORCODTNTE(int rep) {
        return (OMD_O01_ORCODTNTE)this.getTyped("ORCODTNTE", rep, OMD_O01_ORCODTNTE.class);
    }

    public int getORCODTNTEReps() {
        return this.getReps("ORCODTNTE");
    }

    public List<OMD_O01_ORCODTNTE> getORCODTNTEAll() throws HL7Exception {
        return this.getAllAsList("ORCODTNTE", OMD_O01_ORCODTNTE.class);
    }

    public void insertORCODTNTE(OMD_O01_ORCODTNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCODTNTE", (Structure)structure, rep);
    }

    public OMD_O01_ORCODTNTE insertORCODTNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODTNTE)super.insertRepetition("ORCODTNTE", rep);
    }

    public OMD_O01_ORCODTNTE removeORCODTNTE(int rep) throws HL7Exception {
        return (OMD_O01_ORCODTNTE)super.removeRepetition("ORCODTNTE", rep);
    }
}

