/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.ORM_O01_ORDER;
import ca.uhn.hl7v2.model.v23.group.ORM_O01_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORM_O01
extends AbstractMessage {
    public ORM_O01() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ORM_O01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(ORM_O01_PATIENT.class, false, false);
            this.add(ORM_O01_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORM_O01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public NTE getNTE() {
        return (NTE)this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return (NTE)this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORM_O01_PATIENT getPATIENT() {
        return (ORM_O01_PATIENT)this.getTyped("PATIENT", ORM_O01_PATIENT.class);
    }

    public ORM_O01_ORDER getORDER() {
        return (ORM_O01_ORDER)this.getTyped("ORDER", ORM_O01_ORDER.class);
    }

    public ORM_O01_ORDER getORDER(int rep) {
        return (ORM_O01_ORDER)this.getTyped("ORDER", rep, ORM_O01_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<ORM_O01_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ORM_O01_ORDER.class);
    }

    public void insertORDER(ORM_O01_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ORM_O01_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORM_O01_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORM_O01_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORM_O01_ORDER)super.removeRepetition("ORDER", rep);
    }
}

