/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CK;
import ca.uhn.hl7v2.model.v22.datatype.CM_LICENSE_NO;
import ca.uhn.hl7v2.model.v22.datatype.CM_PAT_ID;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PID
extends AbstractSegment {
    public PID(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - Patient ID");
            this.add(CK.class, false, 1, 16, new Object[]{this.getMessage()}, "Patient ID (External ID)");
            this.add(CM_PAT_ID.class, true, 0, 20, new Object[]{this.getMessage()}, "Patient ID (Internal ID)");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Alternate Patient ID");
            this.add(PN.class, true, 1, 48, new Object[]{this.getMessage()}, "Patient Name");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "Mother's Maiden Name");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date of Birth");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Sex");
            this.add(PN.class, false, 0, 48, new Object[]{this.getMessage()}, "Patient Alias");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(5)}, "Race");
            this.add(AD.class, false, 3, 106, new Object[]{this.getMessage()}, "Patient Address");
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "County code");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Phone Number - Home");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Phone Number - Business");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Language - Patient");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(2)}, "Marital Status");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(6)}, "Religion");
            this.add(CK.class, false, 1, 20, new Object[]{this.getMessage()}, "Patient Account Number");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Social security number - patient");
            this.add(CM_LICENSE_NO.class, false, 1, 25, new Object[]{this.getMessage()}, "Driver's license number - patient");
            this.add(CK.class, false, 1, 20, new Object[]{this.getMessage()}, "Mother's Identifier");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(189)}, "Ethnic Group");
            this.add(ST.class, false, 1, 25, new Object[]{this.getMessage()}, "Birth Place");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Multiple Birth Indicator");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Birth Order");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(171)}, "Citizenship");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Veterans Military Status");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PID - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPatientID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPid1_SetIDPatientID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CK getPatientIDExternalID() {
        CK retVal = (CK)this.getTypedField(2, 0);
        return retVal;
    }

    public CK getPid2_PatientIDExternalID() {
        CK retVal = (CK)this.getTypedField(2, 0);
        return retVal;
    }

    public CM_PAT_ID[] getPatientIDInternalID() {
        CM_PAT_ID[] retVal = (CM_PAT_ID[])this.getTypedField(3, (Type[])new CM_PAT_ID[0]);
        return retVal;
    }

    public CM_PAT_ID[] getPid3_PatientIDInternalID() {
        CM_PAT_ID[] retVal = (CM_PAT_ID[])this.getTypedField(3, (Type[])new CM_PAT_ID[0]);
        return retVal;
    }

    public int getPatientIDInternalIDReps() {
        return this.getReps(3);
    }

    public CM_PAT_ID getPatientIDInternalID(int rep) {
        CM_PAT_ID retVal = (CM_PAT_ID)this.getTypedField(3, rep);
        return retVal;
    }

    public CM_PAT_ID getPid3_PatientIDInternalID(int rep) {
        CM_PAT_ID retVal = (CM_PAT_ID)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPid3_PatientIDInternalIDReps() {
        return this.getReps(3);
    }

    public CM_PAT_ID insertPatientIDInternalID(int rep) throws HL7Exception {
        return (CM_PAT_ID)super.insertRepetition(3, rep);
    }

    public CM_PAT_ID insertPid3_PatientIDInternalID(int rep) throws HL7Exception {
        return (CM_PAT_ID)super.insertRepetition(3, rep);
    }

    public CM_PAT_ID removePatientIDInternalID(int rep) throws HL7Exception {
        return (CM_PAT_ID)super.removeRepetition(3, rep);
    }

    public CM_PAT_ID removePid3_PatientIDInternalID(int rep) throws HL7Exception {
        return (CM_PAT_ID)super.removeRepetition(3, rep);
    }

    public ST getAlternatePatientID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPid4_AlternatePatientID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public PN getPatientName() {
        PN retVal = (PN)this.getTypedField(5, 0);
        return retVal;
    }

    public PN getPid5_PatientName() {
        PN retVal = (PN)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getMotherSMaidenName() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public ST getPid6_MotherSMaidenName() {
        ST retVal = (ST)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getDateOfBirth() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getPid7_DateOfBirth() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getSex() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getPid8_Sex() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public PN[] getPatientAlias() {
        PN[] retVal = (PN[])this.getTypedField(9, (Type[])new PN[0]);
        return retVal;
    }

    public PN[] getPid9_PatientAlias() {
        PN[] retVal = (PN[])this.getTypedField(9, (Type[])new PN[0]);
        return retVal;
    }

    public int getPatientAliasReps() {
        return this.getReps(9);
    }

    public PN getPatientAlias(int rep) {
        PN retVal = (PN)this.getTypedField(9, rep);
        return retVal;
    }

    public PN getPid9_PatientAlias(int rep) {
        PN retVal = (PN)this.getTypedField(9, rep);
        return retVal;
    }

    public int getPid9_PatientAliasReps() {
        return this.getReps(9);
    }

    public PN insertPatientAlias(int rep) throws HL7Exception {
        return (PN)super.insertRepetition(9, rep);
    }

    public PN insertPid9_PatientAlias(int rep) throws HL7Exception {
        return (PN)super.insertRepetition(9, rep);
    }

    public PN removePatientAlias(int rep) throws HL7Exception {
        return (PN)super.removeRepetition(9, rep);
    }

    public PN removePid9_PatientAlias(int rep) throws HL7Exception {
        return (PN)super.removeRepetition(9, rep);
    }

    public ID getRace() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPid10_Race() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public AD[] getPatientAddress() {
        AD[] retVal = (AD[])this.getTypedField(11, (Type[])new AD[0]);
        return retVal;
    }

    public AD[] getPid11_PatientAddress() {
        AD[] retVal = (AD[])this.getTypedField(11, (Type[])new AD[0]);
        return retVal;
    }

    public int getPatientAddressReps() {
        return this.getReps(11);
    }

    public AD getPatientAddress(int rep) {
        AD retVal = (AD)this.getTypedField(11, rep);
        return retVal;
    }

    public AD getPid11_PatientAddress(int rep) {
        AD retVal = (AD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPid11_PatientAddressReps() {
        return this.getReps(11);
    }

    public AD insertPatientAddress(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(11, rep);
    }

    public AD insertPid11_PatientAddress(int rep) throws HL7Exception {
        return (AD)super.insertRepetition(11, rep);
    }

    public AD removePatientAddress(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(11, rep);
    }

    public AD removePid11_PatientAddress(int rep) throws HL7Exception {
        return (AD)super.removeRepetition(11, rep);
    }

    public ID getCountyCode() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPid12_CountyCode() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public TN[] getPhoneNumberHome() {
        TN[] retVal = (TN[])this.getTypedField(13, (Type[])new TN[0]);
        return retVal;
    }

    public TN[] getPid13_PhoneNumberHome() {
        TN[] retVal = (TN[])this.getTypedField(13, (Type[])new TN[0]);
        return retVal;
    }

    public int getPhoneNumberHomeReps() {
        return this.getReps(13);
    }

    public TN getPhoneNumberHome(int rep) {
        TN retVal = (TN)this.getTypedField(13, rep);
        return retVal;
    }

    public TN getPid13_PhoneNumberHome(int rep) {
        TN retVal = (TN)this.getTypedField(13, rep);
        return retVal;
    }

    public int getPid13_PhoneNumberHomeReps() {
        return this.getReps(13);
    }

    public TN insertPhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(13, rep);
    }

    public TN insertPid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(13, rep);
    }

    public TN removePhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(13, rep);
    }

    public TN removePid13_PhoneNumberHome(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(13, rep);
    }

    public TN[] getPhoneNumberBusiness() {
        TN[] retVal = (TN[])this.getTypedField(14, (Type[])new TN[0]);
        return retVal;
    }

    public TN[] getPid14_PhoneNumberBusiness() {
        TN[] retVal = (TN[])this.getTypedField(14, (Type[])new TN[0]);
        return retVal;
    }

    public int getPhoneNumberBusinessReps() {
        return this.getReps(14);
    }

    public TN getPhoneNumberBusiness(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public TN getPid14_PhoneNumberBusiness(int rep) {
        TN retVal = (TN)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPid14_PhoneNumberBusinessReps() {
        return this.getReps(14);
    }

    public TN insertPhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN insertPid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(14, rep);
    }

    public TN removePhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public TN removePid14_PhoneNumberBusiness(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(14, rep);
    }

    public ST getLanguagePatient() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getPid15_LanguagePatient() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getMaritalStatus() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getPid16_MaritalStatus() {
        ID retVal = (ID)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getReligion() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getPid17_Religion() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public CK getPatientAccountNumber() {
        CK retVal = (CK)this.getTypedField(18, 0);
        return retVal;
    }

    public CK getPid18_PatientAccountNumber() {
        CK retVal = (CK)this.getTypedField(18, 0);
        return retVal;
    }

    public ST getSocialSecurityNumberPatient() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getPid19_SocialSecurityNumberPatient() {
        ST retVal = (ST)this.getTypedField(19, 0);
        return retVal;
    }

    public CM_LICENSE_NO getDriverSLicenseNumberPatient() {
        CM_LICENSE_NO retVal = (CM_LICENSE_NO)this.getTypedField(20, 0);
        return retVal;
    }

    public CM_LICENSE_NO getPid20_DriverSLicenseNumberPatient() {
        CM_LICENSE_NO retVal = (CM_LICENSE_NO)this.getTypedField(20, 0);
        return retVal;
    }

    public CK getMotherSIdentifier() {
        CK retVal = (CK)this.getTypedField(21, 0);
        return retVal;
    }

    public CK getPid21_MotherSIdentifier() {
        CK retVal = (CK)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getEthnicGroup() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getPid22_EthnicGroup() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getBirthPlace() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getPid23_BirthPlace() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getMultipleBirthIndicator() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getPid24_MultipleBirthIndicator() {
        ID retVal = (ID)this.getTypedField(24, 0);
        return retVal;
    }

    public NM getBirthOrder() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public NM getPid25_BirthOrder() {
        NM retVal = (NM)this.getTypedField(25, 0);
        return retVal;
    }

    public ID[] getCitizenship() {
        ID[] retVal = (ID[])this.getTypedField(26, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPid26_Citizenship() {
        ID[] retVal = (ID[])this.getTypedField(26, (Type[])new ID[0]);
        return retVal;
    }

    public int getCitizenshipReps() {
        return this.getReps(26);
    }

    public ID getCitizenship(int rep) {
        ID retVal = (ID)this.getTypedField(26, rep);
        return retVal;
    }

    public ID getPid26_Citizenship(int rep) {
        ID retVal = (ID)this.getTypedField(26, rep);
        return retVal;
    }

    public int getPid26_CitizenshipReps() {
        return this.getReps(26);
    }

    public ID insertCitizenship(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(26, rep);
    }

    public ID insertPid26_Citizenship(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(26, rep);
    }

    public ID removeCitizenship(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(26, rep);
    }

    public ID removePid26_Citizenship(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(26, rep);
    }

    public ST getVeteransMilitaryStatus() {
        ST retVal = (ST)this.getTypedField(27, 0);
        return retVal;
    }

    public ST getPid27_VeteransMilitaryStatus() {
        ST retVal = (ST)this.getTypedField(27, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CK(this.getMessage());
            }
            case 2: {
                return new CM_PAT_ID(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new PN(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(1));
            }
            case 8: {
                return new PN(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(5));
            }
            case 10: {
                return new AD(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 12: {
                return new TN(this.getMessage());
            }
            case 13: {
                return new TN(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new ID(this.getMessage(), new Integer(2));
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(6));
            }
            case 17: {
                return new CK(this.getMessage());
            }
            case 18: {
                return new ST(this.getMessage());
            }
            case 19: {
                return new CM_LICENSE_NO(this.getMessage());
            }
            case 20: {
                return new CK(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(189));
            }
            case 22: {
                return new ST(this.getMessage());
            }
            case 23: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 24: {
                return new NM(this.getMessage());
            }
            case 25: {
                return new ID(this.getMessage(), new Integer(171));
            }
            case 26: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

