/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.client;

import ca.uhn.hl7v2.hoh.api.IClientMultithreaded;
import ca.uhn.hl7v2.hoh.raw.client.AbstractRawClient;
import ca.uhn.hl7v2.hoh.util.Validate;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HohRawClientMultithreaded
extends AbstractRawClient
implements IClientMultithreaded {
    public static final long DEFAULT_SOCKET_TIMEOUT = 10000L;
    private static final Logger ourLog = LoggerFactory.getLogger(HohRawClientMultithreaded.class);
    private final ScheduledExecutorService myExecutorService;
    private final Map<Socket, Long> myIdleSocketsToTimeBecameIdle = new IdentityHashMap<Socket, Long>();
    private final SimpleDateFormat myLogTimeFormat = new SimpleDateFormat("HH:mm:ss,SSS");
    private boolean myReapingScheduled;
    private long mySocketTimeout = 10000L;

    public HohRawClientMultithreaded() {
        this.myExecutorService = Executors.newScheduledThreadPool(1);
    }

    public HohRawClientMultithreaded(String theHost, int thePort, String thePath) {
        this();
        this.setHost(theHost);
        this.setPort(thePort);
        this.setUriPath(thePath);
    }

    public HohRawClientMultithreaded(String theHost, int thePort, String theUriPath, ScheduledExecutorService theExecutorService) {
        super(theHost, thePort, theUriPath);
        Validate.notNull(theExecutorService, "executorService");
        this.myExecutorService = theExecutorService;
    }

    public HohRawClientMultithreaded(URL theUrl) {
        this();
        this.setUrl(theUrl);
    }

    public HohRawClientMultithreaded(URL theUrl, ScheduledExecutorService theExecutorService) {
        super(theUrl);
        Validate.notNull(theExecutorService, "executorService");
        this.myExecutorService = theExecutorService;
    }

    @Override
    protected synchronized Socket provideSocket() throws IOException {
        Socket retVal;
        if (this.myIdleSocketsToTimeBecameIdle.size() == 0) {
            ourLog.info("Creating new remote connection to {}:{}", (Object)this.getHost(), (Object)this.getPort());
            retVal = this.connect();
        } else {
            retVal = this.myIdleSocketsToTimeBecameIdle.keySet().iterator().next();
            this.myIdleSocketsToTimeBecameIdle.remove(retVal);
            if (retVal.isClosed()) {
                ourLog.trace("Found existing remote connection to {}:{} but it was closed, to going to open a new one", (Object)this.getHost(), (Object)this.getPort());
                retVal = this.connect();
            } else {
                ourLog.trace("Returning existing remote connection to {}:{}", (Object)this.getHost(), (Object)this.getPort());
            }
        }
        return retVal;
    }

    @Override
    protected synchronized void returnSocket(Socket theSocket) {
        if (theSocket.isClosed()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (ourLog.isDebugEnabled()) {
            if (this.mySocketTimeout == -1L) {
                ourLog.debug("Returning socket, will not attempt to reap");
            } else {
                ourLog.debug("Returning socket, will be eligible for reaping at " + this.myLogTimeFormat.format(new Date(now + this.mySocketTimeout)));
            }
        }
        this.myIdleSocketsToTimeBecameIdle.put(theSocket, now);
        this.scheduleReaping();
    }

    private void scheduleReaping() {
        long now = System.currentTimeMillis();
        if (this.myReapingScheduled) {
            ourLog.debug("Reaping already scheduled");
            return;
        }
        if (this.myIdleSocketsToTimeBecameIdle.size() < 1) {
            return;
        }
        if (this.mySocketTimeout == -1L) {
            return;
        }
        long earliestReapingTime = Long.MAX_VALUE;
        for (Long next : this.myIdleSocketsToTimeBecameIdle.values()) {
            long nextReapingTime = next + this.mySocketTimeout;
            if (nextReapingTime >= earliestReapingTime) continue;
            earliestReapingTime = nextReapingTime;
        }
        long delay = earliestReapingTime - now;
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Scheduling socket reaping in {} ms at {}", (Object)delay, (Object)this.myLogTimeFormat.format(new Date(earliestReapingTime)));
        }
        this.myExecutorService.schedule(new TimeoutTask(), delay, TimeUnit.MILLISECONDS);
        this.myReapingScheduled = true;
    }

    @Override
    public long getSocketTimeout() {
        return this.mySocketTimeout;
    }

    @Override
    public synchronized void setSocketTimeout(long theSocketTimeout) {
        if (this.mySocketTimeout < -1L) {
            throw new IllegalArgumentException("Socket timeout must be -1, 0, or a positive integer");
        }
        this.mySocketTimeout = theSocketTimeout;
        this.myReapingScheduled = false;
        this.scheduleReaping();
    }

    private class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (HohRawClientMultithreaded.this.mySocketTimeout == -1L) {
                return;
            }
            ourLog.debug("Beginning socket reaping pass");
            try {
                ArrayList<Socket> socketsToClose = new ArrayList<Socket>();
                long closeIfActiveBefore = System.currentTimeMillis() - HohRawClientMultithreaded.this.mySocketTimeout;
                HohRawClientMultithreaded hohRawClientMultithreaded = HohRawClientMultithreaded.this;
                synchronized (hohRawClientMultithreaded) {
                    Iterator<Map.Entry<Socket, Long>> iter = HohRawClientMultithreaded.this.myIdleSocketsToTimeBecameIdle.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<Socket, Long> nextEntry = iter.next();
                        if (nextEntry.getValue() <= closeIfActiveBefore) {
                            Socket key = nextEntry.getKey();
                            socketsToClose.add(key);
                            ourLog.info("Closing idle socket with local port {} because it has been idle since {}", (Object)key.getLocalPort(), (Object)new Date(nextEntry.getValue()));
                            iter.remove();
                            continue;
                        }
                        if (!ourLog.isDebugEnabled()) continue;
                        ourLog.debug("Next socket has " + (nextEntry.getValue() - closeIfActiveBefore) + "ms remaining");
                    }
                    HohRawClientMultithreaded.this.myReapingScheduled = false;
                    HohRawClientMultithreaded.this.scheduleReaping();
                }
                for (Socket next : socketsToClose) {
                    HohRawClientMultithreaded.this.closeSocket(next);
                }
            }
            catch (Throwable e) {
                ourLog.error("Failure during reaper pass", e);
            }
        }
    }
}

