/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.relay.sender;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.auth.SingleCredentialServerCallback;
import ca.uhn.hl7v2.hoh.llp.ServerSocketThreadForTesting;
import ca.uhn.hl7v2.hoh.relay.Launcher;
import ca.uhn.hl7v2.hoh.relay.sender.RelayHttpSender;
import ca.uhn.hl7v2.hoh.sockets.CustomCertificateTlsSocketFactory;
import ca.uhn.hl7v2.hoh.sockets.CustomCertificateTlsSocketFactoryTest;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ADT_A01;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSenderTest {
    private static final Logger ourLog = LoggerFactory.getLogger(HttpSenderTest.class);
    private int myOutPort;
    private ServerSocketThreadForTesting myServerSocketThread;
    private SingleCredentialServerCallback ourServerCallback;
    private int myInPort;

    @After
    public void after() throws InterruptedException {
        ourLog.info("Marking done as true");
        this.myServerSocketThread.done();
    }

    @Before
    public void before() throws InterruptedException {
        this.myOutPort = RandomServerPortProvider.findFreePort();
        this.myInPort = RandomServerPortProvider.findFreePort();
        System.setProperty("relay.port.out", Integer.toString(this.myOutPort));
        System.setProperty("relay.port.in", Integer.toString(this.myInPort));
        this.ourServerCallback = new SingleCredentialServerCallback("hello", "hapiworld");
        this.myServerSocketThread = new ServerSocketThreadForTesting(this.myOutPort, this.ourServerCallback);
    }

    @Test
    public void testSenderWithTls() throws HL7Exception, IOException, LLPException, InterruptedException, DecodeException, EncodeException {
        CustomCertificateTlsSocketFactory serverSocketFactory = CustomCertificateTlsSocketFactoryTest.createTrustedServerSocketFactory();
        this.myServerSocketThread.setServerSockewtFactory(serverSocketFactory);
        this.myServerSocketThread.start();
        this.myServerSocketThread.getLatch().await();
        ADT_A01 adt = new ADT_A01();
        adt.initQuickstart("ADT", "A01", "T");
        Launcher l = new Launcher("src/test/resources/relay/MllpToHttpTlsMutualAuth.xml");
        ConnectionHub hub = new DefaultHapiContext().getConnectionHub();
        try {
            Connection c = hub.attach("localhost", this.myInPort, false);
            c.getInitiator().setTimeoutMillis(10000000);
            Message response = c.getInitiator().sendAndReceive((Message)adt);
            ourLog.info("Response was:\n{}", (Object)response.encode().replace('\r', '\n'));
        }
        finally {
            l.shutdown();
        }
    }

    @Test
    public void testSetUrl() throws Exception {
        RelayHttpSender s = new RelayHttpSender();
        s.setUrlString("http://localhost:8888/path");
        Assert.assertEquals((Object)"localhost", (Object)s.getHost());
        Assert.assertEquals((long)8888L, (long)s.getPort());
        Assert.assertEquals((Object)"/path", (Object)s.getUriPath());
        s.afterPropertiesSet();
    }
}

