/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.hapi.server;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.hoh.hapi.server.HohServlet;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ACK;
import ca.uhn.hl7v2.model.v25.message.ADT_A05;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.protocol.ReceivingApplicationException;
import ca.uhn.hl7v2.validation.impl.ValidationContextFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.Servlet;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HohServletTest {
    private static DefaultHapiContext ourHapiContext;
    private static final Logger ourLog;
    private static ConnectionHub ourConnectionHub;
    private String myMessage;
    private Message myResponse;
    private int myPort;
    private Server myServer;

    static {
        ourLog = LoggerFactory.getLogger(HohServletTest.class);
    }

    @After
    public void after() throws Exception {
        this.myServer.stop();
    }

    @Before
    public void before() {
        this.myMessage = null;
        this.myResponse = null;
    }

    private void startServer(HohServlet theServlet) throws Exception {
        this.myPort = RandomServerPortProvider.findFreePort();
        this.myServer = new Server(this.myPort);
        Context context = new Context((HandlerContainer)this.myServer, "/", 1);
        context.addServlet(new ServletHolder((Servlet)theServlet), "/*");
        this.myServer.start();
        while (this.myServer.isStarting()) {
            ourLog.info("Waiting for server to start...");
            Thread.sleep(100L);
        }
    }

    @Test
    public void testServlet() throws Exception {
        MyReceivingApp app = new MyReceivingApp();
        HohServlet servlet = new HohServlet();
        servlet.setApplication(app);
        this.startServer(servlet);
        ADT_A05 msg = new ADT_A05();
        msg.initQuickstart("ADT", "A05", "T");
        msg.getPID().getPid5_PatientName(0).getXpn1_FamilyName().getFn1_Surname().setValue("I\u2665HAPI");
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        llp.setPreferredCharset(Charset.forName("UTF-8"));
        Connection conn = ourConnectionHub.attach("localhost", this.myPort, (Parser)PipeParser.getInstanceWithNoValidation(), (LowerLayerProtocol)llp, false);
        Message response = conn.getInitiator().sendAndReceive((Message)msg);
        String responseStr = response.encode();
        ourLog.info("Got response: {}", (Object)responseStr);
        Assert.assertEquals((String)this.myResponse.encode(), (String)responseStr);
        String expected = msg.encode();
        Assert.assertEquals((String)expected, (String)this.myMessage);
    }

    @Test
    public void testServletAE() throws Exception {
        MyReceivingApp app = new MyReceivingApp();
        HohServlet servlet = new HohServlet();
        servlet.setApplication(app);
        this.startServer(servlet);
        ADT_A05 msg = new ADT_A05();
        msg.initQuickstart("ADT", "A05", "T");
        msg.getPID().getPid5_PatientName(0).getXpn1_FamilyName().getFn1_Surname().setValue("I\u2665HAPI");
        this.myResponse = msg.generateACK(AcknowledgmentCode.AE, new HL7Exception("dsfasfs"));
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        llp.setPreferredCharset(Charset.forName("UTF-8"));
        Connection conn = ourConnectionHub.attach("localhost", this.myPort, (Parser)PipeParser.getInstanceWithNoValidation(), (LowerLayerProtocol)llp, false);
        Message response = conn.getInitiator().sendAndReceive((Message)msg);
        String responseStr = response.encode();
        ourLog.info("Got response: {}", (Object)responseStr);
        Assert.assertEquals((String)this.myResponse.encode(), (String)responseStr);
        Assert.assertEquals((String)msg.encode(), (String)this.myMessage);
    }

    @Test
    public void testServletAR() throws Exception {
        MyReceivingApp app = new MyReceivingApp();
        HohServlet servlet = new HohServlet();
        servlet.setApplication(app);
        this.startServer(servlet);
        ADT_A05 msg = new ADT_A05();
        msg.initQuickstart("ADT", "A05", "T");
        msg.getPID().getPid5_PatientName(0).getXpn1_FamilyName().getFn1_Surname().setValue("I\u2665HAPI");
        this.myResponse = msg.generateACK(AcknowledgmentCode.AR, new HL7Exception("dsfasfs"));
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        llp.setPreferredCharset(Charset.forName("UTF-8"));
        Connection conn = ourConnectionHub.attach("localhost", this.myPort, (Parser)PipeParser.getInstanceWithNoValidation(), (LowerLayerProtocol)llp, false);
        Message response = conn.getInitiator().sendAndReceive((Message)msg);
        String responseStr = response.encode();
        ourLog.info("Got response: {}", (Object)responseStr);
        Assert.assertEquals((String)this.myResponse.encode(), (String)responseStr);
        Assert.assertEquals((String)msg.encode(), (String)this.myMessage);
    }

    @Test
    public void testServletXml() throws Exception {
        MyReceivingApp app = new MyReceivingApp();
        HohServlet servlet = new HohServlet();
        servlet.setApplication(app);
        this.startServer(servlet);
        ADT_A05 msg = new ADT_A05();
        msg.initQuickstart("ADT", "A05", "T");
        msg.getPID().getPid5_PatientName(0).getXpn1_FamilyName().getFn1_Surname().setValue("I\u2665HAPI");
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        llp.setPreferredCharset(Charset.forName("UTF-8"));
        Connection conn = ourConnectionHub.attach("localhost", this.myPort, (Parser)DefaultXMLParser.getInstanceWithNoValidation(), (LowerLayerProtocol)llp, false);
        Message response = conn.getInitiator().sendAndReceive((Message)msg);
        String responseStr = response.encode();
        ourLog.info("Got response: {}", (Object)responseStr);
        Assert.assertEquals((String)new DefaultXMLParser().encode(this.myResponse), (String)responseStr);
        Assert.assertEquals((String)new DefaultXMLParser().encode((Message)msg), (String)this.myMessage);
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        ourHapiContext.getExecutorService().shutdown();
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("DEBUG", "true");
        ourHapiContext = new DefaultHapiContext();
        ourHapiContext.setValidationContext(ValidationContextFactory.noValidation());
        ourConnectionHub = ourHapiContext.getConnectionHub();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MyReceivingApp
    implements ReceivingApplication {
        public boolean canProcess(Message theMessage) {
            return true;
        }

        public Message processMessage(Message theMessage, Map<String, Object> theMetadata) throws ReceivingApplicationException, HL7Exception {
            ACK response;
            HohServletTest.this.myMessage = theMessage.encode();
            try {
                response = (ACK)theMessage.generateACK();
            }
            catch (IOException e) {
                throw new ReceivingApplicationException((Throwable)e);
            }
            response.getMSA().getMsa3_TextMessage().setValue("I\u2665HAPI");
            if (HohServletTest.this.myResponse == null) {
                HohServletTest.this.myResponse = (Message)response;
            }
            HohServletTest.this.myResponse.setParser((Parser)PipeParser.getInstanceWithNoValidation());
            return HohServletTest.this.myResponse;
        }
    }
}

