/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttpDecoder;
import ca.uhn.hl7v2.hoh.encoder.AuthorizationFailureException;
import ca.uhn.hl7v2.hoh.encoder.NoMessageReceivedException;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7OverHttpResponseDecoder
extends AbstractHl7OverHttpDecoder {
    private static final Logger ourLog = LoggerFactory.getLogger(Hl7OverHttpResponseDecoder.class);
    private String myActionLine;

    protected String readActionLineAndDecode(InputStream theInputStream) throws IOException, NoMessageReceivedException, DecodeException {
        ourLog.trace("Entering readActionLineAndDecode(InputStream)");
        if (this.myActionLine == null) {
            String firstLine = this.readFirstLine(theInputStream);
            if (firstLine == null || StringUtils.isBlank(firstLine)) {
                throw new NoMessageReceivedException();
            }
            if (!firstLine.startsWith("HTTP/1.1 ")) {
                throw new DecodeException("HTTP response begins with unknown HTTP version. Line is: " + firstLine);
            }
            String statusPart = firstLine.substring(9);
            int spaceIdx = statusPart.indexOf(32);
            if (spaceIdx == -1) {
                throw new DecodeException("Invalid response line, no space after status code. Line is: " + firstLine);
            }
            String statusCode = statusPart.substring(0, spaceIdx);
            try {
                this.setResponseStatus(Integer.parseInt(statusCode));
            }
            catch (NumberFormatException e) {
                throw new DecodeException("Invalid response line. Bad status code: " + statusCode);
            }
            this.setResponseName(statusPart.substring(spaceIdx).trim());
            this.myActionLine = firstLine;
            ourLog.trace("Action line is {}", (Object)this.myActionLine);
        } else {
            ourLog.trace("Already have an action line");
        }
        return this.myActionLine;
    }

    protected void authorize() throws AuthorizationFailureException {
    }

    public boolean isConnectionCloseHeaderPresent() {
        return super.isConnectionCloseHeaderPresent();
    }
}

