/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AbstractTransport;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.protocol.impl.URLTransport;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMSTransport
extends AbstractTransport
implements TransportLayer {
    private static final Logger log = LoggerFactory.getLogger(URLTransport.class);
    public static final String CLIENT_ID_KEY = "CLIENT_ID";
    public static final String CONNECTION_METADATA_KEY = "CONNECTION_METADATA";
    public static final String DESTINATION_NAME_KEY = "DESTINATION_NAME";
    private final Map<String, Object> myMetadata = this.makeMetadata();

    private Map<String, Object> makeMetadata() {
        HashMap<String, Object> md = new HashMap<String, Object>();
        try {
            md.put(CLIENT_ID_KEY, this.getConnection().getClientID());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", (Throwable)e);
        }
        try {
            md.put(CONNECTION_METADATA_KEY, this.getConnection().getMetaData());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", (Throwable)e);
        }
        try {
            md.put(DESTINATION_NAME_KEY, this.getDestinationName());
        }
        catch (JMSException e) {
            log.error("Error setting JMSTransport metadata", (Throwable)e);
        }
        return md;
    }

    protected abstract String getDestinationName() throws JMSException;

    public abstract Connection getConnection();

    protected abstract Message getMessage() throws JMSException;

    protected abstract void sendJMS(Message var1) throws JMSException;

    protected abstract Message receiveJMS() throws JMSException;

    @Override
    public void doSend(Transportable theMessage) throws TransportException {
        try {
            Message message = this.toMessage(theMessage);
            this.sendJMS(message);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
    }

    protected Message toMessage(Transportable theSource) throws TransportException {
        Message message;
        try {
            message = this.getMessage();
            if (!(message instanceof TextMessage)) {
                throw new TransportException("This implementation expects getMessage() to return  a TextMessage.  Override this method if another message type is to be used");
            }
            ((TextMessage)message).setText(theSource.getMessage());
            for (String key : theSource.getMetadata().keySet()) {
                Object val = theSource.getMetadata().get(key);
                message.setObjectProperty(key, val);
            }
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return message;
    }

    protected Transportable toTransportable(Message theMessage) throws TransportException {
        TransportableImpl result;
        if (!(theMessage instanceof TextMessage)) {
            throw new TransportException("This implementation expects getMessage() to return  a TextMessage.  Override this method if another message type is to be used");
        }
        try {
            String text = ((TextMessage)theMessage).getText();
            result = new TransportableImpl(text);
            result.getMetadata().putAll(this.getCommonMetadata());
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return result;
    }

    @Override
    public Transportable doReceive() throws TransportException {
        Transportable result;
        try {
            Message message = this.receiveJMS();
            result = this.toTransportable(message);
        }
        catch (JMSException e) {
            throw new TransportException(e);
        }
        return result;
    }

    @Override
    public Map<String, Object> getCommonMetadata() {
        return this.myMetadata;
    }
}

