/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.parser;

import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.spec.MetaData;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.conf.spec.message.AbstractComponent;
import ca.uhn.hl7v2.conf.spec.message.AbstractSegmentContainer;
import ca.uhn.hl7v2.conf.spec.message.Component;
import ca.uhn.hl7v2.conf.spec.message.DataValue;
import ca.uhn.hl7v2.conf.spec.message.Field;
import ca.uhn.hl7v2.conf.spec.message.ProfileStructure;
import ca.uhn.hl7v2.conf.spec.message.Seg;
import ca.uhn.hl7v2.conf.spec.message.SegGroup;
import ca.uhn.hl7v2.conf.spec.message.StaticDef;
import ca.uhn.hl7v2.conf.spec.message.SubComponent;
import ca.uhn.hl7v2.util.XMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProfileParser {
    private static final String PROFILE_XSD = "ca/uhn/hl7v2/conf/parser/message_profile.xsd";
    private static final Logger log = LoggerFactory.getLogger(ProfileParser.class);
    private final boolean alwaysValidate;
    private final DOMErrorHandler errorHandler;

    public ProfileParser(boolean alwaysValidate) {
        this.alwaysValidate = alwaysValidate;
        this.errorHandler = error -> {
            if (error.getSeverity() != 1) {
                throw new RuntimeException((Exception)error.getRelatedException());
            }
            log.warn("Warning: {}", (Object)error.getMessage());
            return true;
        };
    }

    public RuntimeProfile parseClasspath(String classPath) throws ProfileException, IOException {
        int bytesRead;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classPath);
        if (stream == null) {
            throw new FileNotFoundException(classPath);
        }
        StringBuilder profileString = new StringBuilder();
        byte[] buffer = new byte[1000];
        while ((bytesRead = stream.read(buffer)) > 0) {
            profileString.append(new String(buffer, 0, bytesRead));
        }
        RuntimeProfile profile = new RuntimeProfile();
        Document doc = this.parseIntoDOM(profileString.toString());
        Element root = doc.getDocumentElement();
        profile.setHL7Version(root.getAttribute("HL7Version"));
        NodeList nl = root.getElementsByTagName("HL7v2xStaticDef");
        Element staticDef = (Element)nl.item(0);
        StaticDef sd = this.parseStaticProfile(staticDef);
        profile.setMessage(sd);
        return profile;
    }

    public RuntimeProfile parse(String profileString) throws ProfileException {
        RuntimeProfile profile = new RuntimeProfile();
        Document doc = this.parseIntoDOM(profileString);
        Element root = doc.getDocumentElement();
        profile.setHL7Version(root.getAttribute("HL7Version"));
        NodeList metadataList = root.getElementsByTagName("MetaData");
        if (metadataList.getLength() > 0) {
            Element metadata = (Element)metadataList.item(0);
            String name = metadata.getAttribute("Name");
            profile.setName(name);
        }
        NodeList nl = root.getElementsByTagName("HL7v2xStaticDef");
        Element staticDef = (Element)nl.item(0);
        StaticDef sd = this.parseStaticProfile(staticDef);
        profile.setMessage(sd);
        return profile;
    }

    private StaticDef parseStaticProfile(Element elem) throws ProfileException {
        StaticDef message = new StaticDef();
        message.setMsgType(elem.getAttribute("MsgType"));
        message.setEventType(elem.getAttribute("EventType"));
        message.setMsgStructID(elem.getAttribute("MsgStructID"));
        message.setOrderControl(elem.getAttribute("OrderControl"));
        message.setEventDesc(elem.getAttribute("EventDesc"));
        message.setIdentifier(elem.getAttribute("Identifier"));
        message.setRole(elem.getAttribute("Role"));
        Element md = this.getFirstElementByTagName("MetaData", elem);
        if (md != null) {
            message.setMetaData(this.parseMetaData(md));
        }
        message.setImpNote(this.getValueOfFirstElement("ImpNote", elem));
        message.setDescription(this.getValueOfFirstElement("Description", elem));
        message.setReference(this.getValueOfFirstElement("Reference", elem));
        this.parseChildren(message, elem);
        return message;
    }

    private MetaData parseMetaData(Element elem) {
        log.debug("ProfileParser.parseMetaData() has been called ... note that this method does nothing.");
        return null;
    }

    private void parseChildren(AbstractSegmentContainer parent, Element elem) throws ProfileException {
        int childIndex = 1;
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            Element child = (Element)n;
            if (child.getNodeName().equalsIgnoreCase("SegGroup")) {
                SegGroup group = this.parseSegmentGroupProfile(child);
                parent.setChild(childIndex++, group);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("Segment")) continue;
            Seg segment = this.parseSegmentProfile(child);
            parent.setChild(childIndex++, segment);
        }
    }

    private SegGroup parseSegmentGroupProfile(Element elem) throws ProfileException {
        SegGroup group = new SegGroup();
        log.debug("Parsing segment group profile: " + elem.getAttribute("Name"));
        this.parseProfileStuctureData(group, elem);
        this.parseChildren(group, elem);
        return group;
    }

    private Seg parseSegmentProfile(Element elem) throws ProfileException {
        Seg segment = new Seg();
        log.debug("Parsing segment profile: " + elem.getAttribute("Name"));
        this.parseProfileStuctureData(segment, elem);
        int childIndex = 1;
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !(child = (Element)n).getNodeName().equalsIgnoreCase("Field")) continue;
            Field field = this.parseFieldProfile(child);
            segment.setField(childIndex++, field);
        }
        return segment;
    }

    private void parseProfileStuctureData(ProfileStructure struct, Element elem) throws ProfileException {
        struct.setName(elem.getAttribute("Name"));
        struct.setLongName(elem.getAttribute("LongName"));
        struct.setUsage(elem.getAttribute("Usage"));
        String min = elem.getAttribute("Min");
        String max = elem.getAttribute("Max");
        try {
            struct.setMin(Short.parseShort(min));
            if (max.indexOf(42) >= 0) {
                struct.setMax((short)-1);
            } else {
                struct.setMax(Short.parseShort(max));
            }
        }
        catch (NumberFormatException e) {
            throw new ProfileException("Min and max must be short integers: " + min + ", " + max, e);
        }
        struct.setImpNote(this.getValueOfFirstElement("ImpNote", elem));
        struct.setDescription(this.getValueOfFirstElement("Description", elem));
        struct.setReference(this.getValueOfFirstElement("Reference", elem));
        struct.setPredicate(this.getValueOfFirstElement("Predicate", elem));
    }

    private Field parseFieldProfile(Element elem) throws ProfileException {
        Field field = new Field();
        log.debug("  Parsing field profile: " + elem.getAttribute("Name"));
        field.setUsage(elem.getAttribute("Usage"));
        String itemNo = elem.getAttribute("ItemNo");
        String min = elem.getAttribute("Min");
        String max = elem.getAttribute("Max");
        try {
            if (itemNo.length() > 0) {
                field.setItemNo(Short.parseShort(itemNo));
            }
        }
        catch (NumberFormatException e) {
            throw new ProfileException("Invalid ItemNo: " + itemNo + "( for name " + elem.getAttribute("Name") + ")", e);
        }
        try {
            field.setMin(Short.parseShort(min));
            if (max.indexOf(42) >= 0) {
                field.setMax((short)-1);
            } else {
                field.setMax(Short.parseShort(max));
            }
        }
        catch (NumberFormatException e) {
            throw new ProfileException("Min and max must be short integers: " + min + ", " + max, e);
        }
        this.parseAbstractComponentData(field, elem);
        int childIndex = 1;
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !(child = (Element)n).getNodeName().equalsIgnoreCase("Component")) continue;
            Component comp = (Component)this.parseComponentProfile(child, false);
            field.setComponent(childIndex++, comp);
        }
        return field;
    }

    private AbstractComponent<?> parseComponentProfile(Element elem, boolean isSubComponent) throws ProfileException {
        AbstractComponent comp;
        if (isSubComponent) {
            log.debug("      Parsing subcomp profile: " + elem.getAttribute("Name"));
            comp = new SubComponent();
        } else {
            log.debug("    Parsing comp profile: " + elem.getAttribute("Name"));
            comp = new Component();
            int childIndex = 1;
            NodeList children = elem.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                Node n = children.item(i);
                if (n.getNodeType() != 1 || !(child = (Element)n).getNodeName().equalsIgnoreCase("SubComponent")) continue;
                SubComponent subcomp = (SubComponent)this.parseComponentProfile(child, true);
                ((Component)comp).setSubComponent(childIndex++, subcomp);
            }
        }
        this.parseAbstractComponentData(comp, elem);
        return comp;
    }

    private void parseAbstractComponentData(AbstractComponent<?> comp, Element elem) throws ProfileException {
        comp.setName(elem.getAttribute("Name"));
        comp.setUsage(elem.getAttribute("Usage"));
        comp.setDatatype(elem.getAttribute("Datatype"));
        String length = elem.getAttribute("Length");
        if (length != null && length.length() > 0) {
            try {
                comp.setLength(Long.parseLong(length));
            }
            catch (NumberFormatException e) {
                throw new ProfileException("Length must be a long integer: " + length, e);
            }
        }
        comp.setConstantValue(elem.getAttribute("ConstantValue"));
        String table = elem.getAttribute("Table");
        if (table != null && table.length() > 0) {
            try {
                comp.setTable(table);
            }
            catch (NumberFormatException e) {
                throw new ProfileException("Table must be a short integer: " + table, e);
            }
        }
        comp.setImpNote(this.getValueOfFirstElement("ImpNote", elem));
        comp.setDescription(this.getValueOfFirstElement("Description", elem));
        comp.setReference(this.getValueOfFirstElement("Reference", elem));
        comp.setPredicate(this.getValueOfFirstElement("Predicate", elem));
        int dataValIndex = 0;
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child;
            Node n = children.item(i);
            if (n.getNodeType() != 1 || !(child = (Element)n).getNodeName().equalsIgnoreCase("DataValues")) continue;
            DataValue val = new DataValue();
            val.setExValue(child.getAttribute("ExValue"));
            comp.setDataValues(dataValIndex++, val);
        }
    }

    private Document parseIntoDOM(String profileString) throws ProfileException {
        try {
            Document doc = XMLUtils.parse(profileString, true);
            if (this.alwaysValidate) {
                XMLUtils.validate(doc, PROFILE_XSD, this.errorHandler);
            }
            return doc;
        }
        catch (Exception e) {
            throw new ProfileException("Exception parsing message profile: " + e.getMessage(), e);
        }
    }

    private Element getFirstElementByTagName(String name, Element parent) {
        NodeList nl = parent.getElementsByTagName(name);
        Element ret = null;
        if (nl.getLength() > 0) {
            ret = (Element)nl.item(0);
        }
        return ret;
    }

    private String getValueOfFirstElement(String name, Element parent) throws ProfileException {
        Element el = this.getFirstElementByTagName(name, parent);
        String val = null;
        if (el != null) {
            try {
                Node n = el.getFirstChild();
                if (n.getNodeType() == 3) {
                    val = n.getNodeValue();
                }
            }
            catch (Exception e) {
                throw new ProfileException("Unable to get value of node " + name, e);
            }
        }
        return val;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: ProfileParser profile_file");
            System.exit(1);
        }
        try {
            File f = new File(args[0]);
            BufferedReader in = new BufferedReader(new FileReader(f));
            char[] cbuf = new char[(int)f.length()];
            in.read(cbuf, 0, (int)f.length());
            String xml = String.valueOf(cbuf);
            ProfileParser pp = new ProfileParser(true);
            pp.parse(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

