/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.store.CodeStore;
import ca.uhn.hl7v2.conf.store.CodeStoreRegistry;
import ca.uhn.hl7v2.conf.store.DefaultCodeStoreRegistry;
import ca.uhn.hl7v2.conf.store.FileProfileStore;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.util.Home;

public class ProfileStoreFactory {
    public static final String DEFAULT_PROFILE_STORE_DIRECTORY = Home.getHomeDirectory().getAbsolutePath() + "/profiles";
    private static ProfileStore instance;
    private static CodeStoreRegistry codeRegistry;

    private ProfileStoreFactory() {
    }

    public static synchronized ProfileStore getProfileStore() {
        if (instance == null) {
            instance = new FileProfileStore(DEFAULT_PROFILE_STORE_DIRECTORY);
        }
        return instance;
    }

    public static synchronized void setStore(ProfileStore store) {
        instance = store;
    }

    public static void addCodeStore(CodeStore store) {
        codeRegistry.addCodeStore(store);
    }

    public static void addCodeStore(CodeStore store, String profileID) {
        codeRegistry.addCodeStore(store, profileID);
    }

    public static CodeStore getCodeStore(String profileID, String codeSystem) {
        return codeRegistry.getCodeStore(profileID, codeSystem);
    }

    static {
        codeRegistry = new DefaultCodeStoreRegistry();
    }
}

