/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorCode {
    MESSAGE_ACCEPTED(0, "Message accepted"),
    SEGMENT_SEQUENCE_ERROR(100, "Segment sequence error"),
    REQUIRED_FIELD_MISSING(101, "Required field missing"),
    DATA_TYPE_ERROR(102, "Data type error"),
    TABLE_VALUE_NOT_FOUND(103, "Table value not found"),
    UNSUPPORTED_MESSAGE_TYPE(200, "Unsupported message type"),
    UNSUPPORTED_EVENT_CODE(201, "Unsupported event code"),
    UNSUPPORTED_PROCESSING_ID(202, "Unsupported processing id"),
    UNSUPPORTED_VERSION_ID(203, "Unsupported version id"),
    UNKNOWN_KEY_IDENTIFIER(204, "Unknown key identifier"),
    DUPLICATE_KEY_IDENTIFIER(205, "Duplicate key identifier"),
    APPLICATION_RECORD_LOCKED(206, "Application record locked"),
    APPLICATION_INTERNAL_ERROR(207, "Application internal error");

    private static final String HL70357 = "HL70357";
    private final int code;
    private final String message;

    private ErrorCode(int errCode, String message) {
        this.code = errCode;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static ErrorCode errorCodeFor(int errCode) {
        for (ErrorCode err : ErrorCode.values()) {
            if (err.code != errCode) continue;
            return err;
        }
        return null;
    }

    public static String codeTable() {
        return HL70357;
    }
}

