/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.builder.ValidationRuleBuilder;
import ca.uhn.hl7v2.validation.builder.support.DefaultValidationBuilder;
import ca.uhn.hl7v2.validation.builder.support.NoValidationBuilder;
import ca.uhn.hl7v2.validation.impl.ValidationContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationContextFactory {
    private static ValidationContext ourContext;
    public static final String CONTEXT_PROPERTY = "ca.uhn.hl7v2.validation.context_class";

    public static synchronized ValidationContext getContext() throws HL7Exception {
        if (ourContext == null) {
            String contextClassName = System.getProperty(CONTEXT_PROPERTY);
            ourContext = contextClassName == null ? ValidationContextFactory.defaultValidation() : ValidationContextFactory.customValidation(contextClassName);
        }
        return ourContext;
    }

    public static <T extends ValidationContext> T noValidation() {
        return (T)new ValidationContextImpl(new NoValidationBuilder());
    }

    public static <T extends ValidationContext> T defaultValidation() {
        return (T)new ValidationContextImpl(new DefaultValidationBuilder());
    }

    public static ValidationRuleBuilder customBuilder(String ruleBuilderClassName) throws HL7Exception {
        Class<?> c;
        try {
            c = Class.forName(ruleBuilderClassName);
        }
        catch (ClassNotFoundException e) {
            throw new HL7Exception(e);
        }
        return (ValidationRuleBuilder)ReflectionUtil.instantiate(c);
    }

    public static ValidationContext fromBuilder(String ruleBuilderClassName) throws HL7Exception {
        return new ValidationContextImpl(ValidationContextFactory.customBuilder(ruleBuilderClassName));
    }

    public static ValidationContext fromBuilder(ValidationRuleBuilder builder) {
        return new ValidationContextImpl(builder);
    }

    public static ValidationContext customValidation(String contextClassName) throws HL7Exception {
        Class<?> c;
        try {
            c = Class.forName(contextClassName);
        }
        catch (Exception e) {
            throw new HL7Exception(e);
        }
        return (ValidationContext)ReflectionUtil.instantiate(c);
    }
}

