/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder.support;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceElementsRespectedRule
extends AbstractMessageRule {
    public static final MessageRule CHOICE_ELEMENTS_RESPECTED = new ChoiceElementsRespectedRule();

    @Override
    public ValidationException[] apply(Message theValue) {
        ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
        this.apply(theValue, exceptions);
        return exceptions.toArray(new ValidationException[exceptions.size()]);
    }

    private void apply(Group theStructure, List<ValidationException> theExceptions) {
        HashSet<String> choicesWithContent = null;
        for (String nextName : theStructure.getNames()) {
            try {
                boolean nextIsChoiceElement = theStructure.isChoiceElement(nextName);
                for (Structure nextStruct : theStructure.getAll(nextName)) {
                    if (nextIsChoiceElement && !nextStruct.isEmpty()) {
                        if (choicesWithContent == null) {
                            choicesWithContent = new HashSet<String>();
                        }
                        choicesWithContent.add(nextName);
                    }
                    if (!(nextStruct instanceof Group)) continue;
                    this.apply((Group)nextStruct, theExceptions);
                }
            }
            catch (HL7Exception e) {
                throw new Error("Failed to find " + nextName + " in structure. This is probably a HAPI bug.");
            }
        }
        if (choicesWithContent != null && choicesWithContent.size() > 1) {
            theExceptions.add(new ValidationException("Structure '" + theStructure.getName() + "' must have content only in one of the following choices: " + ((Object)choicesWithContent).toString()));
        }
    }
}

