/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.concurrent.Service;
import ca.uhn.hl7v2.llp.HL7Reader;
import java.io.IOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Receiver
extends Service {
    private static final Logger log = LoggerFactory.getLogger(Receiver.class);
    private Connection conn;
    private HL7Reader in;

    public Receiver(Connection c, HL7Reader in) {
        super("Receiver", c.getExecutorService());
        this.conn = c;
        this.in = in;
    }

    protected void handle() {
        try {
            String message = this.in.getMessage();
            if (message == null) {
                log.debug("Failed to read a message");
            } else {
                this.processMessage(message);
            }
        }
        catch (SocketException e) {
            this.conn.close();
            log.info("SocketException: closing Connection, will no longer read messages with this Receiver: " + e.getMessage());
        }
        catch (IOException e) {
            this.conn.close();
            log.warn("IOException: closing Connection, will no longer read messages with this Receiver. ", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Error while closing connection: ", (Throwable)e);
        }
    }

    protected void processMessage(String message) {
        String ackID = this.conn.getParser().getAckID(message);
        if (ackID == null) {
            log.debug("Unsolicited Message Received: {}", (Object)message);
            this.getExecutorService().submit(new Grunt(this.conn, message));
        } else if (!this.conn.isRecipientWaiting(ackID, message)) {
            log.info("Unexpected Message Received. This message appears to be an acknowledgement (MSA-2 has a value) so it will be ignored: {}", (Object)message);
        } else {
            log.debug("Response Message Received: {}", (Object)message);
        }
    }

    private class Grunt
    implements Runnable {
        private Connection conn;
        private String m;

        public Grunt(Connection conn, String message) {
            this.conn = conn;
            this.m = message;
        }

        public void run() {
            try {
                String response = this.conn.getResponder().processMessage(this.m);
                this.conn.getAckWriter().writeMessage(response);
            }
            catch (Exception e) {
                log.error("Error while processing message: ", (Throwable)e);
            }
        }
    }
}

