/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.EncodingRule;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;

public class MessageValidator {
    private static final MessageRule[] EMPTY_MESSAGE_RULES_ARRAY = new MessageRule[0];
    private static final EncodingRule[] EMPTY_ENCODING_RULES_ARRAY = new EncodingRule[0];
    private static final HapiLog ourLog = HapiLogFactory.getHapiLog(MessageValidator.class);
    private ValidationContext myContext;
    private boolean failOnError;

    public MessageValidator(ValidationContext theContext, boolean theFailOnErrorFlag) {
        this.myContext = theContext;
        this.failOnError = theFailOnErrorFlag;
    }

    public boolean validate(Message message) throws HL7Exception {
        Terser t = new Terser(message);
        MessageRule[] rules = EMPTY_MESSAGE_RULES_ARRAY;
        if (this.myContext != null) {
            rules = this.myContext.getMessageRules(message.getVersion(), t.get("MSH-9-1"), t.get("MSH-9-2"));
        }
        ValidationException toThrow = null;
        boolean result = true;
        for (int i = 0; i < rules.length; ++i) {
            ValidationException[] ex = rules[i].test(message);
            for (int j = 0; j < ex.length; ++j) {
                result = false;
                ourLog.error("Invalid message", ex[j]);
                if (!this.failOnError || toThrow != null) continue;
                toThrow = ex[j];
            }
        }
        if (toThrow != null) {
            throw new HL7Exception("Invalid message", toThrow);
        }
        return result;
    }

    public boolean validate(String message, boolean isXML, String version) throws HL7Exception {
        EncodingRule[] rules = EMPTY_ENCODING_RULES_ARRAY;
        if (this.myContext != null) {
            rules = this.myContext.getEncodingRules(version, isXML ? "XML" : "ER7");
        }
        ValidationException toThrow = null;
        boolean result = true;
        for (int i = 0; i < rules.length; ++i) {
            ValidationException[] ex = rules[i].test(message);
            for (int j = 0; j < ex.length; ++j) {
                result = false;
                ourLog.error("Invalid message", ex[j]);
                if (!this.failOnError || toThrow != null) continue;
                toThrow = ex[j];
            }
        }
        if (toThrow != null) {
            throw new HL7Exception("Invalid message", toThrow);
        }
        return result;
    }
}

