/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.preparser.PreParser;
import ca.uhn.hl7v2.protocol.Processor;
import ca.uhn.hl7v2.protocol.ProcessorContext;
import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.AcceptAcknowledger;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ProcessorImpl
implements Processor {
    private static final HapiLog log = HapiLogFactory.getHapiLog(ProcessorImpl.class);
    private ProcessorContext myContext;
    private final Map myAcceptAcks;
    private final Map myReservations;
    private final Map myAvailableMessages;
    private boolean myThreaded;
    private Cycler ackCycler;
    private Cycler nonAckCycler;
    private ExecutorService myResponseExecutorService;

    public ProcessorImpl(ProcessorContext theContext, boolean isThreaded) {
        this.myContext = theContext;
        this.myThreaded = isThreaded;
        this.myAcceptAcks = new HashMap();
        this.myReservations = new HashMap();
        this.myAvailableMessages = new HashMap();
        if (isThreaded) {
            this.myResponseExecutorService = Executors.newSingleThreadExecutor();
            this.ackCycler = new Cycler(this, true);
            Thread ackThd = new Thread(this.ackCycler);
            ackThd.start();
            this.nonAckCycler = new Cycler(this, false);
            Thread nonAckThd = new Thread(this.nonAckCycler);
            nonAckThd.start();
        }
    }

    public void stop() {
        if (this.myThreaded) {
            this.ackCycler.stop();
            this.nonAckCycler.stop();
            this.myResponseExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Transportable theMessage, int maxRetries, long retryIntervalMillis) throws HL7Exception {
        boolean originalMode;
        String[] fieldPaths = new String[]{"MSH-10", "MSH-15", "MSH-16"};
        String[] fields = PreParser.getFields(theMessage.getMessage(), fieldPaths);
        String controlId = fields[0];
        String needAcceptAck = fields[1];
        String needAppAck = fields[2];
        this.checkValidAckNeededCode(needAcceptAck);
        this.trySend(this.myContext.getLocallyDrivenTransportLayer(), theMessage);
        boolean bl = originalMode = needAcceptAck == null && needAppAck == null;
        if (originalMode || !needAcceptAck.equals("NE")) {
            Transportable response = null;
            int retries = 0;
            do {
                long until = System.currentTimeMillis() + retryIntervalMillis;
                while (response == null && System.currentTimeMillis() < until) {
                    ProcessorImpl processorImpl = this;
                    synchronized (processorImpl) {
                        ExpiringTransportable et = (ExpiringTransportable)this.myAcceptAcks.remove(controlId);
                        if (et == null) {
                            this.cycleIfNeeded(true);
                        } else {
                            response = et.transportable;
                        }
                    }
                    this.sleepIfNeeded();
                }
                if (response == null && needAcceptAck != null && needAcceptAck.equals("AL") || response != null && ProcessorImpl.isReject(response)) {
                    log.info("Resending message " + controlId);
                    this.trySend(this.myContext.getLocallyDrivenTransportLayer(), theMessage);
                    response = null;
                }
                if (response == null || !ProcessorImpl.isError(response)) continue;
                String[] errMsgPath = new String[]{"MSA-3"};
                String[] errMsg = PreParser.getFields(response.getMessage(), errMsgPath);
                throw new HL7Exception("Error message received: " + errMsg[0]);
            } while (response == null && ++retries <= maxRetries);
        }
    }

    private void checkValidAckNeededCode(String theCode) throws HL7Exception {
        if (!(theCode == null || theCode.equals("") || theCode.equals("AL") || theCode.equals("ER") || theCode.equals("NE") || theCode.equals("SU"))) {
            throw new HL7Exception("MSH-15 must be AL, ER, NE, or SU in the outgoing message");
        }
    }

    private void cycleIfNeeded(boolean expectingAck) throws HL7Exception {
        if (!this.myThreaded) {
            this.cycle(expectingAck);
        }
    }

    private void sleepIfNeeded() {
        if (this.myThreaded) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static boolean isReject(Transportable theMessage) throws HL7Exception {
        boolean reject = false;
        String[] fieldPaths = new String[]{"MSA-1"};
        String[] fields = PreParser.getFields(theMessage.getMessage(), fieldPaths);
        if (fields[0] != null && (fields[0].equals("CR") || fields[0].equals("AR"))) {
            reject = true;
        }
        return reject;
    }

    private static boolean isError(Transportable theMessage) throws HL7Exception {
        boolean error = false;
        String[] fieldPaths = new String[]{"MSA-1"};
        String[] fields = PreParser.getFields(theMessage.getMessage(), fieldPaths);
        if (fields[0] != null && (fields[0].equals("CE") || fields[0].equals("AE"))) {
            error = true;
        }
        return error;
    }

    public synchronized void reserve(String theAckId, long thePeriodMillis) {
        Long expiry = new Long(System.currentTimeMillis() + thePeriodMillis);
        this.myReservations.put(theAckId, expiry);
    }

    private void trySend(TransportLayer theTransport, Transportable theTransportable) throws TransportException {
        try {
            theTransport.send(theTransportable);
        }
        catch (TransportException e) {
            theTransport.disconnect();
            theTransport.connect();
            theTransport.send(theTransportable);
        }
    }

    private Transportable tryReceive(TransportLayer theTransport) throws TransportException {
        Transportable message = null;
        try {
            message = theTransport.receive();
        }
        catch (TransportException e) {
            theTransport.disconnect();
            theTransport.connect();
            message = theTransport.receive();
        }
        return message;
    }

    public void cycle(boolean expectingAck) throws HL7Exception {
        log.debug("In cycle()");
        this.cleanReservations();
        this.cleanAcceptAcks();
        this.cleanReservedMessages();
        Transportable in = null;
        try {
            in = expectingAck ? this.tryReceive(this.myContext.getLocallyDrivenTransportLayer()) : this.tryReceive(this.myContext.getRemotelyDrivenTransportLayer());
        }
        catch (TransportException e) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            throw e;
        }
        if (log.isDebugEnabled()) {
            if (in != null) {
                log.debug("Received message: " + in.getMessage());
            } else {
                log.debug("Received no message");
            }
        }
        if (in != null) {
            String[] fieldPaths = new String[]{"MSH-15", "MSH-16", "MSA-1", "MSA-2"};
            String[] fields = PreParser.getFields(in.getMessage(), fieldPaths);
            String acceptAckNeeded = fields[0];
            String appAckNeeded = fields[1];
            String ackCode = fields[2];
            String ackId = fields[3];
            if (ackId != null && ackCode != null && ackCode.startsWith("C")) {
                long expiryTime = System.currentTimeMillis() + 60000L;
                this.myAcceptAcks.put(ackId, new ExpiringTransportable(in, expiryTime));
            } else {
                AcceptAcknowledger.AcceptACK ack = AcceptAcknowledger.validate(this.getContext(), in);
                if (acceptAckNeeded != null && acceptAckNeeded.equals("AL") || acceptAckNeeded != null && acceptAckNeeded.equals("ER") && !ack.isAcceptable() || acceptAckNeeded != null && acceptAckNeeded.equals("SU") && ack.isAcceptable()) {
                    this.trySend(this.myContext.getRemotelyDrivenTransportLayer(), ack.getMessage());
                }
                if (ack.isAcceptable()) {
                    if (this.isReserved(ackId)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Received expected ACK message with ACK ID: " + ackId);
                        }
                        this.removeReservation(ackId);
                        long expiryTime = System.currentTimeMillis() + 300000L;
                        this.myAvailableMessages.put(ackId, new ExpiringTransportable(in, expiryTime));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Sending message to router");
                        }
                        Transportable out = this.myContext.getRouter().processMessage(in);
                        this.sendAppResponse(out);
                    }
                } else {
                    log.warn("Incoming message was not acceptable");
                }
            }
        } else {
            String transport = expectingAck ? " Locally driven " : "Remotely driven";
            log.debug(transport + " TransportLayer.receive() returned null.");
        }
        this.sleepIfNeeded();
        log.debug("Exiting cycle()");
    }

    private void sendAppResponse(final Transportable theResponse) {
        final ProcessorImpl processor = this;
        Runnable sender = new Runnable(){

            public void run() {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Sending response: " + theResponse);
                    }
                    processor.send(theResponse, 2, 3000L);
                }
                catch (HL7Exception e) {
                    log.error("Error trying to send response from Application", e);
                }
            }
        };
        if (this.myThreaded) {
            this.myResponseExecutorService.execute(sender);
        } else {
            sender.run();
        }
    }

    private synchronized void cleanReservations() {
        Iterator it = this.myReservations.keySet().iterator();
        while (it.hasNext()) {
            String ackId = (String)it.next();
            Long expiry = (Long)this.myReservations.get(ackId);
            if (System.currentTimeMillis() <= expiry) continue;
            it.remove();
        }
    }

    private synchronized void cleanAcceptAcks() {
        Iterator it = this.myAcceptAcks.keySet().iterator();
        while (it.hasNext()) {
            String ackId = (String)it.next();
            ExpiringTransportable et = (ExpiringTransportable)this.myAcceptAcks.get(ackId);
            if (System.currentTimeMillis() <= et.expiryTime) continue;
            it.remove();
        }
    }

    private synchronized void cleanReservedMessages() throws HL7Exception {
        Iterator it = this.myAvailableMessages.keySet().iterator();
        while (it.hasNext()) {
            String ackId = (String)it.next();
            ExpiringTransportable et = (ExpiringTransportable)this.myAvailableMessages.get(ackId);
            if (System.currentTimeMillis() <= et.expiryTime) continue;
            it.remove();
            Transportable out = this.myContext.getRouter().processMessage(et.transportable);
            this.sendAppResponse(out);
        }
    }

    private synchronized boolean isReserved(String ackId) {
        boolean reserved = false;
        if (this.myReservations.containsKey(ackId)) {
            reserved = true;
        }
        return reserved;
    }

    private synchronized void removeReservation(String ackId) {
        this.myReservations.remove(ackId);
    }

    public boolean isAvailable(String theAckId) {
        boolean available = false;
        if (this.myAvailableMessages.containsKey(theAckId)) {
            available = true;
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transportable receive(String theAckId, long theTimeoutMillis) throws HL7Exception {
        if (!this.isReserved(theAckId)) {
            this.reserve(theAckId, theTimeoutMillis);
        }
        Transportable in = null;
        long until = System.currentTimeMillis() + theTimeoutMillis;
        do {
            ProcessorImpl processorImpl = this;
            synchronized (processorImpl) {
                ExpiringTransportable et = (ExpiringTransportable)this.myAvailableMessages.get(theAckId);
                if (et == null) {
                    this.cycleIfNeeded(false);
                } else {
                    in = et.transportable;
                }
            }
            this.sleepIfNeeded();
        } while (in == null && System.currentTimeMillis() < until);
        return in;
    }

    public ProcessorContext getContext() {
        return this.myContext;
    }

    private static class Cycler
    implements Runnable {
        private Processor myProcessor;
        private boolean myExpectingAck;
        private boolean isRunning;

        public Cycler(Processor theProcessor, boolean isExpectingAck) {
            this.myProcessor = theProcessor;
            this.myExpectingAck = isExpectingAck;
            this.isRunning = true;
        }

        public void stop() {
            this.isRunning = false;
        }

        public void run() {
            while (this.isRunning) {
                try {
                    this.myProcessor.cycle(this.myExpectingAck);
                }
                catch (HL7Exception e) {
                    log.error("Error processing message", e);
                }
            }
        }
    }

    class ExpiringTransportable {
        public Transportable transportable;
        public long expiryTime;

        public ExpiringTransportable(Transportable theTransportable, long theExpiryTime) {
            this.transportable = theTransportable;
            this.expiryTime = theExpiryTime;
        }
    }
}

