/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.TransportException;
import ca.uhn.hl7v2.protocol.TransportLayer;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTransport
implements TransportLayer {
    private static HapiLog log = HapiLogFactory.getHapiLog(AbstractTransport.class);
    private Map myCommonMetadata = new HashMap();
    private boolean myIsConnected = false;

    public Map getCommonMetadata() {
        return this.myCommonMetadata;
    }

    public Transportable receive() throws TransportException {
        if (!this.isConnected()) {
            throw new TransportException("Can't receive because TransportLayer is not connected");
        }
        Transportable message = this.doReceive();
        if (message != null) {
            message.getMetadata().putAll(this.myCommonMetadata);
        }
        log.info("Received: " + (message == null ? null : message.getMessage()));
        return message;
    }

    public abstract Transportable doReceive() throws TransportException;

    public void send(Transportable theMessage) throws TransportException {
        if (!this.isConnected()) {
            throw new TransportException("Can't send because TransportLayer is not connected");
        }
        this.doSend(theMessage);
        log.info("Sent: " + (theMessage == null ? null : theMessage.getMessage()));
    }

    public abstract void doSend(Transportable var1) throws TransportException;

    public void connect() throws TransportException {
        this.myIsConnected = false;
        this.doConnect();
        this.myIsConnected = true;
    }

    public abstract void doConnect() throws TransportException;

    public boolean isConnected() {
        return this.myIsConnected;
    }

    public void disconnect() throws TransportException {
        this.myIsConnected = false;
        this.doDisconnect();
    }

    public abstract void doDisconnect() throws TransportException;
}

