/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Escape;
import ca.uhn.hl7v2.parser.IStructureDefinition;
import ca.uhn.hl7v2.parser.MessageIterator;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.OldPipeParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.StructureDefinition;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeParser
extends Parser {
    private static final HapiLog log = HapiLogFactory.getHapiLog(PipeParser.class);
    private static final String segDelim = "\r";
    private final HashMap<Class<? extends Message>, StructureDefinition> myStructureDefinitions = new HashMap();
    public static final String DEFAULT_LEGACY_MODE_PROPERTY = "ca.uhn.hl7v2.parser.PipeParser.default_legacy_mode";
    private Boolean myLegacyMode = null;

    public PipeParser() {
    }

    public PipeParser(ModelClassFactory theFactory) {
        super(theFactory);
    }

    @Override
    public String getEncoding(String message) {
        String encoding = null;
        if (message.length() < 4) {
            return null;
        }
        boolean ok = true;
        if (!message.startsWith("MSH")) {
            return null;
        }
        char fourthChar = message.charAt(3);
        StringTokenizer st = new StringTokenizer(message, String.valueOf(segDelim), false);
        while (st.hasMoreTokens()) {
            String x = st.nextToken();
            if (x.length() <= 0) continue;
            if (Character.isWhitespace(x.charAt(0))) {
                x = PipeParser.stripLeadingWhitespace(x);
            }
            if (x.length() < 4 || x.charAt(3) == fourthChar) continue;
            return null;
        }
        int nextFieldDelimLoc = 0;
        for (int i = 0; i < 11; ++i) {
            if ((nextFieldDelimLoc = message.indexOf(fourthChar, nextFieldDelimLoc + 1)) >= 0) continue;
            return null;
        }
        if (ok) {
            encoding = "VB";
        }
        return encoding;
    }

    @Override
    public String getDefaultEncoding() {
        return "VB";
    }

    @Override
    public boolean supportsEncoding(String encoding) {
        boolean supports = false;
        if (encoding != null && encoding.equals("VB")) {
            supports = true;
        }
        return supports;
    }

    public String getMessageStructure(String message) throws HL7Exception, EncodingNotSupportedException {
        return this.getStructure((String)message).messageStructure;
    }

    private MessageStructure getStructure(String message) throws HL7Exception, EncodingNotSupportedException {
        boolean explicityDefined;
        String messageStructure;
        block6: {
            EncodingCharacters ec = PipeParser.getEncodingChars(message);
            messageStructure = null;
            explicityDefined = true;
            try {
                String[] fields = PipeParser.split(message.substring(0, Math.max(message.indexOf(segDelim), message.length())), String.valueOf(ec.getFieldSeparator()));
                String wholeFieldNine = fields[8];
                String[] comps = PipeParser.split(wholeFieldNine, String.valueOf(ec.getComponentSeparator()));
                if (comps.length >= 3) {
                    messageStructure = comps[2];
                    break block6;
                }
                if (comps.length > 0 && comps[0] != null && comps[0].equals("ACK")) {
                    messageStructure = "ACK";
                    break block6;
                }
                if (comps.length == 2) {
                    explicityDefined = false;
                    messageStructure = comps[0] + "_" + comps[1];
                    break block6;
                }
                StringBuilder buf = new StringBuilder("Can't determine message structure from MSH-9: ");
                buf.append(wholeFieldNine);
                if (comps.length < 3) {
                    buf.append(" HINT: there are only ");
                    buf.append(comps.length);
                    buf.append(" of 3 components present");
                }
                throw new HL7Exception(buf.toString(), 200);
            }
            catch (IndexOutOfBoundsException e) {
                throw new HL7Exception("Can't find message structure (MSH-9-3): " + e.getMessage(), 200);
            }
        }
        return new MessageStructure(messageStructure, explicityDefined);
    }

    private static EncodingCharacters getEncodingChars(String message) {
        return new EncodingCharacters(message.charAt(3), message.substring(4, 8));
    }

    @Override
    protected Message doParse(String message, String version) throws HL7Exception, EncodingNotSupportedException {
        MessageStructure structure = this.getStructure(message);
        Message m = this.instantiateMessage(structure.messageStructure, version, structure.explicitlyDefined);
        this.parse(m, message);
        return m;
    }

    private IStructureDefinition getStructureDefinition(Class<? extends Message> theClazz) throws HL7Exception {
        StructureDefinition retVal = this.myStructureDefinitions.get(theClazz);
        if (retVal != null) {
            return retVal;
        }
        Message message = ReflectionUtil.instantiateMessage(theClazz, this.getFactory());
        Holder<StructureDefinition> previousLeaf = new Holder<StructureDefinition>();
        retVal = this.createStructureDefinition(message, previousLeaf);
        this.myStructureDefinitions.put(theClazz, retVal);
        return retVal;
    }

    private StructureDefinition createStructureDefinition(Structure theStructure, Holder<StructureDefinition> thePreviousLeaf) throws HL7Exception {
        StructureDefinition retVal = new StructureDefinition();
        retVal.setName(theStructure.getName());
        if (theStructure instanceof Group) {
            retVal.setSegment(false);
            Group group = (Group)theStructure;
            int index = 0;
            for (String nextName : group.getNames()) {
                Structure nextChild = group.get(nextName);
                StructureDefinition structureDefinition = this.createStructureDefinition(nextChild, thePreviousLeaf);
                structureDefinition.setNameAsItAppearsInParent(nextName);
                structureDefinition.setRepeating(group.isRepeating(nextName));
                structureDefinition.setRequired(group.isRequired(nextName));
                structureDefinition.setPosition(index++);
                structureDefinition.setParent(retVal);
                retVal.addChild(structureDefinition);
            }
        } else {
            if (thePreviousLeaf.getObject() != null) {
                thePreviousLeaf.getObject().setNextLeaf(retVal);
            }
            thePreviousLeaf.setObject(retVal);
            retVal.setSegment(true);
        }
        return retVal;
    }

    @Override
    public void parse(Segment destination, String segment, EncodingCharacters encodingChars) throws HL7Exception {
        this.parse(destination, segment, encodingChars, null);
    }

    public void parse(Segment destination, String segment, EncodingCharacters encodingChars, Integer theRepetition) throws HL7Exception {
        int fieldOffset = 0;
        if (PipeParser.isDelimDefSegment(destination.getName())) {
            fieldOffset = 1;
            Terser.set(destination, 1, 0, 1, 1, String.valueOf(encodingChars.getFieldSeparator()));
        }
        String[] fields = PipeParser.split(segment, String.valueOf(encodingChars.getFieldSeparator()));
        for (int i = 1; i < fields.length; ++i) {
            boolean isMSH2;
            String[] reps = PipeParser.split(fields[i], String.valueOf(encodingChars.getRepetitionSeparator()));
            boolean bl = isMSH2 = PipeParser.isDelimDefSegment(destination.getName()) && i + fieldOffset == 2;
            if (isMSH2) {
                reps = new String[]{fields[i]};
            }
            for (int j = 0; j < reps.length; ++j) {
                try {
                    if (log.isDebugEnabled()) {
                        StringBuilder statusMessage = new StringBuilder("Parsing field ");
                        statusMessage.append(i + fieldOffset);
                        statusMessage.append(" repetition ");
                        statusMessage.append(j);
                        log.debug(statusMessage.toString());
                    }
                    Type field = destination.getField(i + fieldOffset, j);
                    if (isMSH2) {
                        Terser.getPrimitive(field, 1, 1).setValue(reps[j]);
                        continue;
                    }
                    this.parse(field, reps[j], encodingChars);
                    continue;
                }
                catch (HL7Exception e) {
                    e.setFieldPosition(i);
                    if (theRepetition != null) {
                        e.setSegmentRepetition(theRepetition);
                    }
                    e.setSegmentName(destination.getName());
                    throw e;
                }
            }
        }
        if (destination.getClass().getName().indexOf("OBX") >= 0) {
            Varies.fixOBX5(destination, this.getFactory());
        }
    }

    private static boolean isDelimDefSegment(String theSegmentName) {
        boolean is = false;
        if (theSegmentName.equals("MSH") || theSegmentName.equals("FHS") || theSegmentName.equals("BHS")) {
            is = true;
        }
        return is;
    }

    @Override
    public void parse(Type destinationField, String data, EncodingCharacters encodingCharacters) throws HL7Exception {
        String[] components = PipeParser.split(data, String.valueOf(encodingCharacters.getComponentSeparator()));
        for (int i = 0; i < components.length; ++i) {
            String[] subcomponents = PipeParser.split(components[i], String.valueOf(encodingCharacters.getSubcomponentSeparator()));
            for (int j = 0; j < subcomponents.length; ++j) {
                String val = subcomponents[j];
                if (val != null) {
                    val = Escape.unescape(val, encodingCharacters);
                }
                Terser.getPrimitive(destinationField, i + 1, j + 1).setValue(val);
            }
        }
    }

    public static String[] split(String composite, String delim) {
        ArrayList<String> components = new ArrayList<String>();
        if (composite == null) {
            composite = "";
        }
        if (delim == null) {
            delim = "";
        }
        StringTokenizer tok = new StringTokenizer(composite, delim, true);
        boolean previousTokenWasDelim = true;
        while (tok.hasMoreTokens()) {
            String thisTok = tok.nextToken();
            if (thisTok.equals(delim)) {
                if (previousTokenWasDelim) {
                    components.add(null);
                }
                previousTokenWasDelim = true;
                continue;
            }
            components.add(thisTok);
            previousTokenWasDelim = false;
        }
        String[] ret = new String[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            ret[i] = (String)components.get(i);
        }
        return ret;
    }

    @Override
    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        return PipeParser.encode(structure, encodingCharacters);
    }

    @Override
    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        return PipeParser.encode(type, encodingCharacters);
    }

    public static String encode(Type source, EncodingCharacters encodingChars) {
        Varies varies;
        if (source instanceof Varies && (varies = (Varies)source).getData() != null) {
            source = varies.getData();
        }
        StringBuilder field = new StringBuilder();
        for (int i = 1; i <= Terser.numComponents(source); ++i) {
            StringBuilder comp = new StringBuilder();
            for (int j = 1; j <= Terser.numSubComponents(source, i); ++j) {
                Primitive p = Terser.getPrimitive(source, i, j);
                comp.append(PipeParser.encodePrimitive(p, encodingChars));
                comp.append(encodingChars.getSubcomponentSeparator());
            }
            field.append(PipeParser.stripExtraDelimiters(comp.toString(), encodingChars.getSubcomponentSeparator()));
            field.append(encodingChars.getComponentSeparator());
        }
        return PipeParser.stripExtraDelimiters(field.toString(), encodingChars.getComponentSeparator());
    }

    private static String encodePrimitive(Primitive p, EncodingCharacters encodingChars) {
        String val = p.getValue();
        val = val == null ? "" : Escape.escape(val, encodingChars);
        return val;
    }

    private static String stripExtraDelimiters(String in, char delim) {
        char[] chars = in.toCharArray();
        int c = chars.length - 1;
        boolean found = false;
        while (c >= 0 && !found) {
            if (chars[c--] == delim) continue;
            found = true;
        }
        String ret = "";
        if (found) {
            ret = String.valueOf(chars, 0, c + 2);
        }
        return ret;
    }

    @Override
    protected String doEncode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        if (!this.supportsEncoding(encoding)) {
            throw new EncodingNotSupportedException("This parser does not support the " + encoding + " encoding");
        }
        return this.encode(source);
    }

    @Override
    protected String doEncode(Message source) throws HL7Exception {
        String encCharString;
        Segment msh = (Segment)source.get("MSH");
        String fieldSepString = Terser.get(msh, 1, 0, 1, 1);
        if (fieldSepString == null) {
            throw new HL7Exception("Can't encode message: MSH-1 (field separator) is missing");
        }
        char fieldSep = '|';
        if (fieldSepString != null && fieldSepString.length() > 0) {
            fieldSep = fieldSepString.charAt(0);
        }
        if ((encCharString = Terser.get(msh, 2, 0, 1, 1)) == null) {
            throw new HL7Exception("Can't encode message: MSH-2 (encoding characters) is missing");
        }
        if (encCharString.length() != 4) {
            throw new HL7Exception("Encoding characters '" + encCharString + "' invalid -- must be 4 characters", 102);
        }
        EncodingCharacters en = new EncodingCharacters(fieldSep, encCharString);
        return PipeParser.encode(source, en);
    }

    public static String encode(Group source, EncodingCharacters encodingChars) throws HL7Exception {
        StringBuilder result = new StringBuilder();
        String[] names = source.getNames();
        String firstMandatorySegmentName = null;
        boolean haveEncounteredMandatorySegment = false;
        boolean haveEncounteredContent = false;
        boolean haveHadMandatorySegment = false;
        boolean haveHadSegmentBeforeMandatorySegment = false;
        for (int i = 0; i < names.length; ++i) {
            Structure[] reps = source.getAll(names[i]);
            boolean nextNameIsRequired = source.isRequired(names[i]);
            boolean havePreviouslyEncounteredMandatorySegment = haveEncounteredMandatorySegment;
            haveEncounteredMandatorySegment |= nextNameIsRequired;
            if (nextNameIsRequired && !haveHadMandatorySegment && !source.isGroup(names[i])) {
                firstMandatorySegmentName = names[i];
            }
            for (int rep = 0; rep < reps.length; ++rep) {
                if (reps[rep] instanceof Group) {
                    String encodedGroup = PipeParser.encode((Group)reps[rep], encodingChars);
                    result.append(encodedGroup);
                    if (encodedGroup.length() <= 0) continue;
                    if (!haveHadMandatorySegment && !haveEncounteredMandatorySegment) {
                        haveHadSegmentBeforeMandatorySegment = true;
                    }
                    if (nextNameIsRequired && !haveHadMandatorySegment && !havePreviouslyEncounteredMandatorySegment) {
                        haveHadMandatorySegment = true;
                    }
                    haveEncounteredContent = true;
                    continue;
                }
                String segString = PipeParser.encode((Segment)reps[rep], encodingChars);
                if (segString.length() < 4) continue;
                result.append(segString);
                result.append(segDelim);
                haveEncounteredContent = true;
                if (nextNameIsRequired) {
                    haveHadMandatorySegment = true;
                }
                if (haveHadMandatorySegment || haveEncounteredMandatorySegment) continue;
                haveHadSegmentBeforeMandatorySegment = true;
            }
        }
        if (firstMandatorySegmentName != null && !haveHadMandatorySegment && !haveHadSegmentBeforeMandatorySegment && haveEncounteredContent) {
            return firstMandatorySegmentName.substring(0, 3) + encodingChars.getFieldSeparator() + segDelim + result;
        }
        return result.toString();
    }

    public static PipeParser getInstanceWithNoValidation() {
        PipeParser retVal = new PipeParser();
        retVal.setValidationContext(new NoValidation());
        return retVal;
    }

    public static String encode(Segment source, EncodingCharacters encodingChars) {
        StringBuilder result = new StringBuilder();
        result.append(source.getName());
        result.append(encodingChars.getFieldSeparator());
        int startAt = 1;
        if (PipeParser.isDelimDefSegment(source.getName())) {
            startAt = 2;
        }
        int numFields = source.numFields();
        for (int i = startAt; i <= numFields; ++i) {
            try {
                Type[] reps = source.getField(i);
                for (int j = 0; j < reps.length; ++j) {
                    String fieldText = PipeParser.encode(reps[j], encodingChars);
                    if (PipeParser.isDelimDefSegment(source.getName()) && i == 2) {
                        fieldText = Escape.unescape(fieldText, encodingChars);
                    }
                    result.append(fieldText);
                    if (j >= reps.length - 1) continue;
                    result.append(encodingChars.getRepetitionSeparator());
                }
            }
            catch (HL7Exception e) {
                log.error("Error while encoding segment: ", e);
            }
            result.append(encodingChars.getFieldSeparator());
        }
        return PipeParser.stripExtraDelimiters(result.toString(), encodingChars.getFieldSeparator());
    }

    public static String stripLeadingWhitespace(String in) {
        StringBuilder out = new StringBuilder();
        char[] chars = in.toCharArray();
        for (int c = 0; c < chars.length && Character.isWhitespace(chars[c]); ++c) {
        }
        for (int i = c; i < chars.length; ++i) {
            out.append(chars[i]);
        }
        return out.toString();
    }

    @Override
    public Segment getCriticalResponseData(String message) throws HL7Exception {
        int locStartMSH = message.indexOf("MSH");
        if (locStartMSH < 0) {
            throw new HL7Exception("Couldn't find MSH segment in message: " + message, 100);
        }
        int locEndMSH = message.indexOf(13, locStartMSH + 1);
        if (locEndMSH < 0) {
            locEndMSH = message.length();
        }
        String mshString = message.substring(locStartMSH, locEndMSH);
        char fieldSep = mshString.charAt(3);
        String[] fields = PipeParser.split(mshString, String.valueOf(fieldSep));
        Segment msh = null;
        try {
            String encChars = fields[1];
            char compSep = encChars.charAt(0);
            String messControlID = fields[9];
            String[] procIDComps = PipeParser.split(fields[10], String.valueOf(compSep));
            String version = "2.4";
            try {
                version = this.getVersion(message);
            }
            catch (Exception e) {
                // empty catch block
            }
            msh = Parser.makeControlMSH(version, this.getFactory());
            Terser.set(msh, 1, 0, 1, 1, String.valueOf(fieldSep));
            Terser.set(msh, 2, 0, 1, 1, encChars);
            Terser.set(msh, 10, 0, 1, 1, messControlID);
            Terser.set(msh, 11, 0, 1, 1, procIDComps[0]);
            Terser.set(msh, 12, 0, 1, 1, version);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't parse critical fields from MSH segment (" + e.getClass().getName() + ": " + e.getMessage() + "): " + mshString, 101, e);
        }
        return msh;
    }

    @Override
    public String getAckID(String message) {
        String ackID = null;
        int startMSA = message.indexOf("\rMSA");
        if (startMSA >= 0) {
            int startFieldOne = startMSA + 5;
            char fieldDelim = message.charAt(startFieldOne - 1);
            int start = message.indexOf(fieldDelim, startFieldOne) + 1;
            int end = message.indexOf(fieldDelim, start);
            int segEnd = message.indexOf(String.valueOf(segDelim), start);
            if (segEnd > start && segEnd < end) {
                end = segEnd;
            }
            if (end < 0) {
                end = message.charAt(message.length() - 1) == '\r' ? message.length() - 1 : message.length();
            }
            if (start > 0 && end > start) {
                ackID = message.substring(start, end);
            }
        }
        log.debug("ACK ID: " + ackID);
        return ackID;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.myLegacyMode = legacyMode;
    }

    @Override
    public String encode(Message source) throws HL7Exception {
        if (this.myLegacyMode != null && this.myLegacyMode.booleanValue()) {
            OldPipeParser oldPipeParser = new OldPipeParser(this.getFactory());
            return oldPipeParser.encode(source);
        }
        return super.encode(source);
    }

    @Override
    public Message parse(String message) throws HL7Exception, EncodingNotSupportedException {
        if (this.myLegacyMode != null && this.myLegacyMode.booleanValue()) {
            OldPipeParser oldPipeParser = new OldPipeParser(this.getFactory());
            return oldPipeParser.parse(message);
        }
        return super.parse(message);
    }

    public boolean isLegacyMode() {
        if (this.myLegacyMode == null) {
            return Boolean.parseBoolean(System.getProperty(DEFAULT_LEGACY_MODE_PROPERTY));
        }
        return this.myLegacyMode;
    }

    @Override
    public String getVersion(String message) throws HL7Exception {
        String[] comp;
        int startMSH = message.indexOf("MSH");
        int endMSH = message.indexOf(segDelim, startMSH);
        if (endMSH < 0) {
            endMSH = message.length();
        }
        String msh = message.substring(startMSH, endMSH);
        String fieldSep = null;
        if (msh.length() <= 3) {
            throw new HL7Exception("Can't find field separator in MSH: " + msh, 203);
        }
        fieldSep = String.valueOf(msh.charAt(3));
        String[] fields = PipeParser.split(msh, fieldSep);
        String compSep = null;
        if (fields.length < 2 || fields[1] == null || fields[1].length() != 4) {
            throw new HL7Exception("Invalid or incomplete encoding characters - MSH-2 is " + fields[1], 101);
        }
        compSep = String.valueOf(fields[1].charAt(0));
        String version = null;
        if (fields.length >= 12) {
            comp = PipeParser.split(fields[11], compSep);
            if (comp.length < 1) {
                throw new HL7Exception("Can't find version ID - MSH.12 is " + fields[11], 101);
            }
        } else {
            throw new HL7Exception("Can't find version ID - MSH has only " + fields.length + " fields.", 101);
        }
        version = comp[0];
        return version;
    }

    @Override
    public void parse(Message message, String string) throws HL7Exception {
        IStructureDefinition structureDef = this.getStructureDefinition(message.getClass());
        MessageIterator messageIter = new MessageIterator(message, structureDef, "MSH", true);
        String[] segments = PipeParser.split(string, segDelim);
        int delim = 124;
        for (int i = 0; i < segments.length; ++i) {
            String name;
            if (segments[i] != null && segments[i].length() > 0 && Character.isWhitespace(segments[i].charAt(0))) {
                segments[i] = PipeParser.stripLeadingWhitespace(segments[i]);
            }
            if (segments[i] == null || segments[i].length() < 3) continue;
            if (i == 0) {
                name = segments[i].substring(0, 3);
                delim = segments[i].charAt(3);
            } else {
                name = segments[i].indexOf(delim) >= 0 ? segments[i].substring(0, segments[i].indexOf(delim)) : segments[i];
            }
            log.debug("Parsing segment " + name);
            messageIter.setDirection(name);
            if (!messageIter.hasNext()) continue;
            Segment next = (Segment)messageIter.next();
            int nextIndexWithinParent = messageIter.getNextIndexWithinParent();
            this.parse(next, segments[i], PipeParser.getEncodingChars(string), nextIndexWithinParent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Holder<T> {
        private T myObject;

        private Holder() {
        }

        public T getObject() {
            return this.myObject;
        }

        public void setObject(T theObject) {
            this.myObject = theObject;
        }
    }

    private static class MessageStructure {
        public String messageStructure;
        public boolean explicitlyDefined;

        public MessageStructure(String theMessageStructure, boolean isExplicitlyDefined) {
            this.messageStructure = theMessageStructure;
            this.explicitlyDefined = isExplicitlyDefined;
        }
    }
}

