/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractPrimitive;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.ExtraComponents;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;

public abstract class AbstractType
implements Type {
    private final ExtraComponents extra;
    private final Message message;

    public AbstractType(Message message) {
        this.extra = new ExtraComponents(message);
        this.message = message;
    }

    public String getName() {
        String longClassName = this.getClass().getName();
        return longClassName.substring(longClassName.lastIndexOf(46) + 1);
    }

    public ExtraComponents getExtraComponents() {
        return this.extra;
    }

    public Message getMessage() {
        return this.message;
    }

    public void parse(String string) throws HL7Exception {
        this.clear();
        this.getMessage().getParser().parse(this, string, EncodingCharacters.getInstance(this.getMessage()));
    }

    public String encode() throws HL7Exception {
        return this.getMessage().getParser().doEncode(this, EncodingCharacters.getInstance(this.getMessage()));
    }

    public void clear() {
        if (this instanceof Composite) {
            Composite composite = (Composite)((Object)this);
            for (Type nextComponent : composite.getComponents()) {
                nextComponent.clear();
            }
        } else if (!(this instanceof AbstractPrimitive) && this instanceof Primitive) {
            Primitive primitive = (Primitive)((Object)this);
            try {
                primitive.setValue("");
            }
            catch (DataTypeException ex) {
                throw new Error("Unable to clear the value of a primitive which does not extend AbstractPrimitive. This is likely a software bug.");
            }
        }
        this.extra.clear();
    }
}

