/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public class TwoPortService
extends HL7Service {
    private static final HapiLog log = HapiLogFactory.getHapiLog(TwoPortService.class);
    private Vector inSockets = new Vector(20);
    private Vector outSockets = new Vector(20);
    private int inboundPort;
    private int outboundPort;

    public TwoPortService(Parser parser, LowerLayerProtocol llp, int inboundPort, int outboundPort) {
        super(parser, llp);
        this.inboundPort = inboundPort;
        this.outboundPort = outboundPort;
    }

    public void run() {
        try {
            AcceptThread inAccept = new AcceptThread(this.inboundPort, this.inSockets);
            AcceptThread outAccept = new AcceptThread(this.outboundPort, this.outSockets);
            Thread inThread = new Thread(inAccept);
            Thread outThread = new Thread(outAccept);
            inThread.start();
            outThread.start();
            log.info("TwoPortService running on ports " + this.inboundPort + " and " + this.outboundPort);
            while (this.keepRunning()) {
                Connection conn = this.accept(3000L);
                if (conn == null) continue;
                this.newConnection(conn);
                log.info("Accepted connection from " + conn.getRemoteAddress().getHostAddress());
            }
            inAccept.stop();
            outAccept.stop();
        }
        catch (Exception e) {
            log.error("Error while accepting connections: ", e);
        }
    }

    private Connection accept(long timeoutMillis) throws LLPException, IOException {
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        while (conn == null && System.currentTimeMillis() < startTime + timeoutMillis) {
            for (int i = 0; conn == null && i < this.inSockets.size(); ++i) {
                Socket in = (Socket)this.inSockets.get(i);
                for (int j = 0; conn == null && j < this.outSockets.size(); ++j) {
                    Socket out = (Socket)this.outSockets.get(j);
                    if (!out.getInetAddress().getHostAddress().equals(in.getInetAddress().getHostAddress())) continue;
                    conn = new Connection(this.parser, this.llp, in, out);
                    this.inSockets.remove(i);
                    this.outSockets.remove(j);
                }
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        return conn;
    }

    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.out.println("Usage: ca.uhn.hl7v2.app.TwoPortService inbound_port outbound_port [application_spec_file_name]");
            System.exit(1);
        }
        int inPort = 0;
        int outPort = 0;
        try {
            inPort = Integer.parseInt(args[0]);
            outPort = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.err.println("One of the given ports (" + args[0] + " or " + args[1] + ") is not an integer.");
            System.exit(1);
        }
        File appFile = null;
        if (args.length == 3) {
            appFile = new File(args[2]);
        }
        try {
            TwoPortService server = new TwoPortService(new PipeParser(), LowerLayerProtocol.makeLLP(), inPort, outPort);
            if (appFile != null) {
                server.loadApplicationsFromFile(appFile);
            }
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AcceptThread
    implements Runnable {
        private ServerSocket ss;
        private Vector sockets;
        private boolean keepRunning = true;

        public AcceptThread(int port, Vector sockets) throws IOException, SocketException {
            this.ss = new ServerSocket(port);
            this.ss.setSoTimeout(3000);
            this.sockets = sockets;
        }

        public void run() {
            try {
                while (this.keepRunning) {
                    try {
                        Socket s = this.ss.accept();
                        this.sockets.add(s);
                    }
                    catch (InterruptedIOException e) {}
                }
                this.ss.close();
            }
            catch (Exception e) {
                log.error("Problem running connection accept thread", e);
            }
        }

        public void stop() {
            this.keepRunning = false;
        }
    }
}

