/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.app.MessageReceipt;
import ca.uhn.hl7v2.app.Receiver;
import ca.uhn.hl7v2.app.Responder;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;

public class Connection {
    private static final HapiLog log = HapiLogFactory.getHapiLog(Connection.class);
    private Initiator initiator;
    private Responder responder;
    private ArrayList sockets;
    private HL7Writer ackWriter;
    private HL7Writer sendWriter;
    private Parser parser;
    private HashMap receipts;
    private ArrayList receivers;
    private boolean open = true;

    public Connection(Parser parser, LowerLayerProtocol llp, Socket bidirectional) throws LLPException, IOException {
        this.init(parser);
        this.sendWriter = this.ackWriter = llp.getWriter(bidirectional.getOutputStream());
        this.sockets.add(bidirectional);
        Receiver r = new Receiver(this, llp.getReader(bidirectional.getInputStream()));
        r.start();
        this.receivers.add(r);
        this.initiator = new Initiator(this);
    }

    public Connection(Parser parser, LowerLayerProtocol llp, Socket inbound, Socket outbound) throws LLPException, IOException {
        this.init(parser);
        this.ackWriter = llp.getWriter(inbound.getOutputStream());
        this.sendWriter = llp.getWriter(outbound.getOutputStream());
        this.sockets.add(outbound);
        this.sockets.add(inbound);
        Receiver inRec = new Receiver(this, llp.getReader(inbound.getInputStream()));
        Receiver outRec = new Receiver(this, llp.getReader(outbound.getInputStream()));
        inRec.start();
        outRec.start();
        this.receivers.add(inRec);
        this.receivers.add(outRec);
        this.initiator = new Initiator(this);
    }

    private void init(Parser parser) throws LLPException {
        this.parser = parser;
        this.sockets = new ArrayList();
        this.receipts = new HashMap();
        this.receivers = new ArrayList();
        this.responder = new Responder(parser);
    }

    public InetAddress getRemoteAddress() {
        Socket s = (Socket)this.sockets.get(0);
        return s.getInetAddress();
    }

    public Initiator getInitiator() {
        return this.initiator;
    }

    public Responder getResponder() {
        return this.responder;
    }

    protected HL7Writer getSendWriter() {
        return this.sendWriter;
    }

    protected HL7Writer getAckWriter() {
        return this.ackWriter;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getRemoteAddress().getHostName());
        buf.append(":");
        for (int i = 0; i < this.sockets.size(); ++i) {
            buf.append(((Socket)this.sockets.get(i)).getPort());
            if (i + 1 >= this.sockets.size()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    protected MessageReceipt reserveResponse(String messageID) {
        MessageReceipt mr = new MessageReceipt();
        this.receipts.put(messageID, mr);
        return mr;
    }

    protected MessageReceipt findRecipient(String ackID) {
        MessageReceipt mr = null;
        if (ackID != null) {
            mr = (MessageReceipt)this.receipts.remove(ackID);
        }
        return mr;
    }

    public void close() {
        int i;
        for (i = 0; i < this.receivers.size(); ++i) {
            ((Receiver)this.receivers.get(i)).stop();
        }
        for (i = 0; i < this.sockets.size(); ++i) {
            try {
                ((Socket)this.sockets.get(i)).close();
                continue;
            }
            catch (IOException e) {
                log.error("Error while stopping threads and closing sockets", e);
            }
        }
        this.open = false;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode;
    }

    public boolean isOpen() {
        return this.open;
    }
}

