/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.service.utils.ValidationLevel;

public class ValidatorSettings
extends ValidationOptions {
    private ValidationMessage.Source source;
    private ValidationLevel level = ValidationLevel.HINTS;
    private Coding jurisdiction;
    private boolean allowExamples;
    private boolean forPublication;
    private boolean debug;
    private boolean warnOnDraftOrExperimental;
    private BestPracticeWarningLevel bpWarnings = BestPracticeWarningLevel.Warning;
    private List<UsageContext> usageContexts = new ArrayList<UsageContext>();
    private boolean assumeValidRestReferences;
    private Map<String, byte[]> certificates = new HashMap<String, byte[]>();
    private List<String> certificateFolders = new ArrayList<String>();
    private String minVersion;
    private String maxVersion;
    private boolean useNewXVersionPackages;
    private Set<String> jwtHeaderList = ValidatorSettings.buildJadesHeaders();

    public ValidationMessage.Source getSource() {
        return this.source;
    }

    public void setSource(ValidationMessage.Source source) {
        this.source = source;
    }

    public ValidationLevel getLevel() {
        return this.level;
    }

    public void setLevel(ValidationLevel level) {
        this.level = level;
    }

    public Coding getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(Coding jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public boolean isAllowExamples() {
        return this.allowExamples;
    }

    public void setAllowExamples(boolean allowExamples) {
        this.allowExamples = allowExamples;
    }

    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    public void setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public void setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
        if (forPublication) {
            this.warnOnDraftOrExperimental = true;
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isWarnOnDraftOrExperimental() {
        return this.warnOnDraftOrExperimental;
    }

    public void setWarnOnDraftOrExperimental(boolean warnOnDraftOrExperimental) {
        this.warnOnDraftOrExperimental = warnOnDraftOrExperimental;
    }

    public BestPracticeWarningLevel getBpWarnings() {
        return this.bpWarnings;
    }

    public void setBpWarnings(BestPracticeWarningLevel value) {
        this.bpWarnings = value == null ? BestPracticeWarningLevel.Warning : value;
    }

    public List<UsageContext> getUsageContexts() {
        return this.usageContexts;
    }

    public Map<String, byte[]> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Map<String, byte[]> certificates) {
        this.certificates = certificates;
    }

    public List<String> getCertificateFolders() {
        return this.certificateFolders;
    }

    public void setCertificateFolders(List<String> certificateFolders) {
        this.certificateFolders = certificateFolders;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public boolean isUseNewXVersionPackages() {
        return this.useNewXVersionPackages;
    }

    public void setUseNewXVersionPackages(boolean useNewXVersionPackages) {
        this.useNewXVersionPackages = useNewXVersionPackages;
    }

    private static Set<String> buildJadesHeaders() {
        HashSet<String> stringSet = new HashSet<String>();
        stringSet.add("srCms");
        stringSet.add("iat");
        stringSet.add("alg");
        stringSet.add("typ");
        stringSet.add("x5c");
        stringSet.add("sigD");
        stringSet.add("version");
        return stringSet;
    }

    @Generated
    public Set<String> getJwtHeaderList() {
        return this.jwtHeaderList;
    }
}

