/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.hl7.fhir.r5.context.ExpansionOptions;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.TerminologyUtilities;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.codesystem.BCP47Checker;
import org.hl7.fhir.validation.codesystem.CPTChecker;
import org.hl7.fhir.validation.codesystem.CodeSystemBasedChecker;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.codesystem.GeneralCodeSystemChecker;
import org.hl7.fhir.validation.codesystem.LoincChecker;
import org.hl7.fhir.validation.codesystem.RxNormChecker;
import org.hl7.fhir.validation.codesystem.SnomedCTChecker;
import org.hl7.fhir.validation.codesystem.UcumChecker;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueSetValidator
extends BaseValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValueSetValidator.class);
    private static final int TOO_MANY_CODES_TO_VALIDATE = 1000;
    private static final int VALIDATION_BATCH_SIZE = 300;
    private FHIRPathEngine fpe;

    private CodeSystemChecker getSystemValidator(String system, List<ValidationMessage> errors) {
        if (system == null) {
            return new GeneralCodeSystemChecker(this.context, this.settings, this.xverManager, errors, this.session);
        }
        switch (system) {
            case "http://snomed.info/sct": {
                return new SnomedCTChecker(this.context, this.settings, this.xverManager, errors, this.session);
            }
            case "http://loinc.org": {
                return new LoincChecker(this.context, this.settings, this.xverManager, errors, this.session);
            }
            case "http://www.nlm.nih.gov/research/umls/rxnorm": {
                return new RxNormChecker(this.context, this.settings, this.xverManager, errors, this.session);
            }
            case "http://unitsofmeasure.org": {
                return new UcumChecker(this.context, this.settings, this.xverManager, errors, this.session);
            }
            case "http://www.ama-assn.org/go/cpt": {
                return new CPTChecker(this.context, this.settings, this.xverManager, errors, this.session);
            }
            case "urn:ietf:bcp:47": {
                return new BCP47Checker(this.context, this.settings, this.xverManager, errors, this.session);
            }
        }
        CodeSystem cs = this.context.fetchCodeSystem(system);
        if (cs != null) {
            return new CodeSystemBasedChecker(this.context, this.settings, this.xverManager, errors, cs, this.session);
        }
        return new GeneralCodeSystemChecker(this.context, this.settings, this.xverManager, errors, this.session);
    }

    public ValueSetValidator(InstanceValidator parent) {
        super(parent);
        this.fpe = parent.getFHIRPathEngine();
    }

    public boolean validateValueSet(ValidationContext valContext, List<ValidationMessage> errors, Element vs, NodeStack stack) {
        boolean ok = true;
        if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            ArrayList<ParameterDeclaration> parameters = new ArrayList<ParameterDeclaration>();
            int i = 0;
            for (Element ext : vs.getExtensions("http://hl7.org/fhir/tools/StructureDefinition/valueset-parameter")) {
                Element n = ext.getExtension("name");
                if (n != null) {
                    Element d = ext.getExtension("documentation");
                    NodeStack estack = stack.push(ext, i, null, null);
                    String name = n.getNamedChildValue(new String[]{"value"});
                    if (d == null) {
                        this.warning(errors, "2025-03-22", ValidationMessage.IssueType.BUSINESSRULE, estack, name.startsWith("p-"), "VALUESET_PARAMETER_NO_DOCO", name);
                        parameters.add(new ParameterDeclaration(ext, n.primitiveValue(), null));
                    } else {
                        parameters.add(new ParameterDeclaration(ext, name, d == null ? null : d.getNamedChildValue(new String[]{"value"})));
                    }
                    this.hint(errors, "2025-03-22", ValidationMessage.IssueType.BUSINESSRULE, estack, name.startsWith("p-"), "VALUESET_PARAMETER_NAME_WARNING", name);
                }
                ++i;
            }
            List composes = vs.getChildrenByName("compose");
            int cc = 0;
            for (Element compose : composes) {
                ok = this.validateValueSetCompose(valContext, errors, compose, stack.push(compose, composes.size() > 1 ? cc : -1, null, null), vs.getNamedChildValue("url", false), "retired".equals(vs.getNamedChildValue("url", false)), vs, parameters) & ok;
                ++cc;
            }
            for (ParameterDeclaration p : parameters) {
                this.warning(errors, "2025-03-21", ValidationMessage.IssueType.BUSINESSRULE, stack.push(p.ext, i, null, null), p.used, "VALUESET_PARAMETER_NOT_USED", p.name);
            }
        }
        if (!stack.isContained()) {
            ok = this.checkShareableValueSet(valContext, errors, vs, stack) && ok;
        }
        return ok;
    }

    private boolean checkShareableValueSet(ValidationContext valContext, List<ValidationMessage> errors, Element vs, NodeStack stack) {
        if (this.policyAdvisor.policyForSpecialValidation((IResourceValidator)this.parent, valContext.getAppContext(), IValidationPolicyAdvisor.SpecialValidationRule.VALUESET_METADATA_CHECKS, stack.getLiteralPath(), vs, null) == IValidationPolicyAdvisor.SpecialValidationAction.CHECK_RULE && this.settings.isForPublication()) {
            if (this.isHL7(vs)) {
                boolean ok = true;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("url", false), "VALUESET_SHAREABLE_MISSING_HL7", "url") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("version", false), "VALUESET_SHAREABLE_MISSING_HL7", "version") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("title", false), "VALUESET_SHAREABLE_MISSING_HL7", "title") && ok;
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("name", false), "VALUESET_SHAREABLE_EXTRA_MISSING_HL7", "name");
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("status", false), "VALUESET_SHAREABLE_MISSING_HL7", "status") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("experimental", false), "VALUESET_SHAREABLE_MISSING_HL7", "experimental") && ok;
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("description", false), "VALUESET_SHAREABLE_MISSING_HL7", "description") && ok;
                return ok;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("url", false), "VALUESET_SHAREABLE_MISSING", "url");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("version", false), "VALUESET_SHAREABLE_MISSING", "version");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("title", false), "VALUESET_SHAREABLE_MISSING", "title");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("name", false), "VALUESET_SHAREABLE_EXTRA_MISSING", "name");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("status", false), "VALUESET_SHAREABLE_MISSING", "status");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("experimental", false), "VALUESET_SHAREABLE_MISSING", "experimental");
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack, vs.hasChild("description", false), "VALUESET_SHAREABLE_MISSING", "description");
        }
        return true;
    }

    private boolean validateValueSetCompose(ValidationContext valContext, List<ValidationMessage> errors, Element compose, NodeStack stack, String vsid, boolean retired, Element vsSrc, List<ParameterDeclaration> parameters) {
        boolean ok = true;
        List includes = compose.getChildrenByName("include");
        int ci = 0;
        for (Element include : includes) {
            ok = this.validateValueSetInclude(valContext, errors, include, stack.push(include, ci, null, null), vsid, retired, vsSrc, parameters) && ok;
            ++ci;
        }
        List excludes = compose.getChildrenByName("exclude");
        int ce = 0;
        for (Element exclude : excludes) {
            ok = this.validateValueSetInclude(valContext, errors, exclude, stack.push(exclude, ce, null, null), vsid, retired, vsSrc, parameters) && ok;
            ++ce;
        }
        return ok;
    }

    private boolean validateValueSetInclude(ValidationContext valContext, List<ValidationMessage> errors, Element include, NodeStack stack, String vsid, boolean retired, Element vsSrc, List<ParameterDeclaration> parameters) {
        boolean ok;
        block60: {
            List filters;
            List concepts;
            block56: {
                boolean validateConcepts;
                CodeSystem cs;
                CodeSystemChecker csChecker;
                String version;
                String system;
                block59: {
                    List csl;
                    ValueSet vs;
                    block57: {
                        block58: {
                            ok = true;
                            system = include.getChildValue("system");
                            version = include.getChildValue("version");
                            if (system != null && system.contains("|")) {
                                String uver = system.substring(system.indexOf("|") + 1);
                                system = system.substring(0, system.indexOf("|"));
                                if (Utilities.noString((String)uver)) {
                                    this.warning(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_REFERENCE_INVALID_TYPE_NO_VERSION_0", system);
                                } else if (version == null) {
                                    ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_REFERENCE_INVALID_TYPE_NO_VERSION_1", uver) && ok;
                                } else if (!uver.equals(version)) {
                                    ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_REFERENCE_INVALID_TYPE_NO_VERSION_2", uver, version) && ok;
                                } else {
                                    boolean bl = ok = this.rule(errors, "2024-06-13", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_REFERENCE_INVALID_TYPE_NO_VERSION_3", uver) && ok;
                                }
                            }
                            if (this.policyAdvisor.policyForSpecialValidation((IResourceValidator)this.parent, valContext.getAppContext(), IValidationPolicyAdvisor.SpecialValidationRule.VALUESET_IMPORT_CHECKS, stack.getLiteralPath(), vsSrc, include) == IValidationPolicyAdvisor.SpecialValidationAction.CHECK_RULE) {
                                List valuesets = include.getChildrenByName("valueSet");
                                int i = 0;
                                for (Element ve : valuesets) {
                                    ValueSetExpansionOutcome vse;
                                    String v = ve.getValue();
                                    vs = (ValueSet)this.context.findTxResource(ValueSet.class, v);
                                    if (vs == null && !(vse = this.context.expandVS(new ExpansionOptions().withCacheOk(true).withHierarchical(false).withMaxCount(0), v)).isOk()) {
                                        NodeStack ns = stack.push(ve, i, ve.getProperty().getDefinition(), ve.getProperty().getDefinition());
                                        Resource rs = this.context.fetchResource(Resource.class, v);
                                        if (rs != null) {
                                            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_INVALID_TYPE", v, rs.fhirType());
                                        } else {
                                            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "VALUESET_REFERENCE_UNKNOWN", v);
                                        }
                                    }
                                    ++i;
                                }
                                if (valuesets.size() > 1) {
                                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, stack, false, "VALUESET_IMPORT_UNION_INTERSECTION", new Object[0]);
                                }
                            }
                            if (system != null) {
                                CodeSystem cs2;
                                this.rule(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, Utilities.isAbsoluteUrl((String)system), system.startsWith("#") ? "VALUESET_INCLUDE_SYSTEM_ABSOLUTE_FRAG" : "VALUESET_INCLUDE_SYSTEM_ABSOLUTE", system);
                                if (system.startsWith("#")) {
                                    cs2 = new ArrayList();
                                    for (Element contained : vsSrc.getChildrenByName("contained")) {
                                        if (!("#" + contained.getIdBase()).equals(system)) continue;
                                        ok = false;
                                        if (!this.rule(errors, "2024-02-10", ValidationMessage.IssueType.INVALID, stack, "CodeSystem".equals(contained.fhirType()), "VALUESET_INCLUDE_CS_NOT_CS", system, contained.fhirType()) || version != null && !version.equals(contained.getChildValue("version"))) continue;
                                        cs2.add(contained);
                                    }
                                    if (cs2.isEmpty()) {
                                        ok = this.rule(errors, "2024-02-10", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_NOT_FOUND" : "VALUESET_INCLUDE_CSVER_NOT_FOUND", system, version) && ok;
                                    } else {
                                        boolean bl = ok = this.rule(errors, "2024-02-10", ValidationMessage.IssueType.INVALID, stack, cs2.size() == 1, version == null ? "VALUESET_INCLUDE_CS_MULTI_FOUND" : "VALUESET_INCLUDE_CSVER_MULTI_FOUND", system, version) && ok;
                                    }
                                }
                                if (version == null && (cs2 = this.context.fetchCodeSystem(system)) != null && !CodeSystemUtilities.isExemptFromMultipleVersionChecking((String)system) && this.fetcher != null) {
                                    Set possibleVersions = this.fetcher.fetchCanonicalResourceVersions(null, valContext.getAppContext(), system);
                                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, stack, possibleVersions.size() <= 1, "TYPE_SPECIFIC_CHECKS_DT_CANONICAL_MULTIPLE_POSSIBLE_VERSIONS", system, cs2.getVersion(), CommaSeparatedStringBuilder.join((String)", ", (Collection)Utilities.sorted((Collection)possibleVersions)));
                                }
                            }
                            concepts = include.getChildrenByName("concept");
                            filters = include.getChildrenByName("filter");
                            csChecker = this.getSystemValidator(system, errors);
                            cs = null;
                            if (Utilities.noString((String)system)) break block56;
                            cs = this.context.fetchCodeSystem(system, version, null);
                            if (cs == null) {
                                cs = (CodeSystem)this.context.findTxResource(CodeSystem.class, system, version, null);
                            }
                            validateConcepts = true;
                            if (cs == null) break block57;
                            boolean bl = ok = this.rule(errors, "2025-07-15", ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !cs.hasUserData("RESOURCE_INTERNAL_USE_ONLY"), "RESOURCE_INTERNAL_USE_ONLY", "CodeSystem", cs.getSourcePackage() != null ? cs.getSourcePackage().getVID() : "??") && ok;
                            if (cs.getContent() != null) break block58;
                            this.warning(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_CONTENT" : "VALUESET_INCLUDE_CSVER_CONTENT", system, "null", version);
                            break block59;
                        }
                        switch (cs.getContent()) {
                            case EXAMPLE: {
                                this.warning(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_CONTENT" : "VALUESET_INCLUDE_CSVER_CONTENT", system, cs.getContent().toCode(), version);
                                break;
                            }
                            case FRAGMENT: {
                                this.hint(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_CONTENT" : "VALUESET_INCLUDE_CSVER_CONTENT", system, cs.getContent().toCode(), version);
                                break;
                            }
                            case SUPPLEMENT: {
                                validateConcepts = false;
                                ok = this.rule(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_SUPPLEMENT" : "VALUESET_INCLUDE_CSVER_SUPPLEMENT", system, cs.getSupplements(), version) && ok;
                                break;
                            }
                            case NOTPRESENT: {
                                if (!this.context.getTxSupportInfo(cs.getUrl(), cs.getVersion()).isServerSide()) {
                                    validateConcepts = false;
                                    this.warning(errors, "2024-03-06", ValidationMessage.IssueType.INVALID, stack, false, version == null ? "VALUESET_INCLUDE_CS_CONTENT" : "VALUESET_INCLUDE_CSVER_CONTENT", system, cs.getContent().toCode(), version);
                                    break;
                                }
                                break block59;
                            }
                        }
                        break block59;
                    }
                    if (system.startsWith("urn:oid:") && !(csl = this.cu.fetchByIdentifier(CodeSystem.class, system)).isEmpty()) {
                        if (csl.size() == 1) {
                            ok = this.rule(errors, "2025-01-09", ValidationMessage.IssueType.INVALID, stack, csl.isEmpty(), "VALUESET_INCLUDE_WRONG_CS_OID", system, ((CodeSystem)csl.get(0)).getUrl()) && ok;
                        } else {
                            ArrayList<String> ids = new ArrayList<String>();
                            for (CodeSystem c : csl) {
                                ids.add(c.getVersionedUrl());
                            }
                            boolean bl = ok = this.rule(errors, "2025-01-09", ValidationMessage.IssueType.INVALID, stack, csl.isEmpty(), "VALUESET_INCLUDE_WRONG_CS_OID_PLURAL", system, CommaSeparatedStringBuilder.join((String)",", ids)) && ok;
                        }
                    }
                    if ((vs = (ValueSet)this.context.findTxResource(ValueSet.class, system, version, null)) != null) {
                        validateConcepts = false;
                        List systems = TerminologyUtilities.listSystems((ValueSet)vs);
                        if (systems.size() == 0) {
                            ok = this.rule(errors, "2025-01-09", ValidationMessage.IssueType.INVALID, stack, false, "VALUESET_INCLUDE_WRONG_VS", system) && ok;
                        } else if (systems.size() == 1) {
                            ok = this.rule(errors, "2025-01-09", ValidationMessage.IssueType.INVALID, stack, false, "VALUESET_INCLUDE_WRONG_VS_HINT", system, systems.get(0)) && ok;
                        } else {
                            boolean bl = ok = this.rule(errors, "2025-01-09", ValidationMessage.IssueType.INVALID, stack, false, "VALUESET_INCLUDE_WRONG_VS_MANY", system, CommaSeparatedStringBuilder.join((String)", ", (Collection)systems)) && ok;
                        }
                    }
                }
                if (this.policyAdvisor.policyForSpecialValidation((IResourceValidator)this.parent, valContext.getAppContext(), IValidationPolicyAdvisor.SpecialValidationRule.VALUESET_SYSTEM_CHECKS, stack.getLiteralPath(), vsSrc, include) == IValidationPolicyAdvisor.SpecialValidationAction.CHECK_RULE) {
                    if (!this.noTerminologyChecks && validateConcepts) {
                        boolean systemOk = true;
                        int cc = 0;
                        ArrayList<VSCodingValidationRequest> batch = new ArrayList<VSCodingValidationRequest>();
                        boolean first = true;
                        if (concepts.size() > 1000) {
                            this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_INC_TOO_MANY_CODES", concepts.size());
                        } else if (!((InstanceValidator)this.parent).isValidateValueSetCodesOnTxServer()) {
                            this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_INC_NOT_VALIDATING", concepts.size());
                        } else if (this.context.isNoTerminologyServer()) {
                            this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_INC_NO_SERVER", concepts.size());
                        } else {
                            IWorkerContext.SystemSupportInformation si = this.context.getTxSupportInfo(system, version);
                            if (concepts.size() > 1 && !si.isSupported()) {
                                this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_INC_CS_NO_SUPPORT", si.getServer());
                            } else if (!(concepts.size() <= 1 || si.getTestVersion() != null && VersionUtilities.isThisOrLater((String)"1.7.8", (String)si.getTestVersion(), (VersionUtilities.VersionPrecision)VersionUtilities.VersionPrecision.PATCH))) {
                                this.hint(errors, "2023-09-06", ValidationMessage.IssueType.BUSINESSRULE, stack, false, "VALUESET_INC_NO_BATCH_ON_SERVER", si.getServer());
                            } else {
                                try {
                                    for (Element concept : concepts) {
                                        if (first) {
                                            systemOk = this.validateValueSetIncludeConcept(errors, concept, stack, stack.push(concept, cc, null, null), system, version, csChecker, cs != null);
                                            first = false;
                                        } else if (systemOk) {
                                            batch.add(this.prepareValidateValueSetIncludeConcept(errors, concept, stack.push(concept, cc, null, null), system, version, csChecker));
                                            if (batch.size() > 300) {
                                                this.executeValidationBatch(errors, vsid, retired, system, version, batch, stack);
                                                batch.clear();
                                            }
                                        }
                                        ++cc;
                                    }
                                    this.executeValidationBatch(errors, vsid, retired, system, version, batch, stack);
                                }
                                catch (Exception e) {
                                    ok = false;
                                    VSCodingValidationRequest cv = (VSCodingValidationRequest)((Object)batch.get(0));
                                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, cv.getStack().getLiteralPath(), false, e.getMessage(), new Object[0]);
                                }
                            }
                        }
                    }
                    int cf = 0;
                    for (Element filter : filters) {
                        ok = this.validateValueSetIncludeFilter(errors, filter, stack.push(filter, cf, null, null), system, version, cs, csChecker, parameters) & ok;
                        ++cf;
                    }
                }
                csChecker.finish(include, stack);
                break block60;
            }
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, filters.size() == 0 && concepts.size() == 0, "VALUESET_NO_SYSTEM_WARNING", new Object[0]);
        }
        return ok;
    }

    private void executeValidationBatch(List<ValidationMessage> errors, String vsid, boolean retired, String system, String version, List<VSCodingValidationRequest> batch, NodeStack baseStack) {
        IWorkerContext.SystemSupportInformation txInfo;
        if (batch.size() > 0 && this.warning(errors, "2025-07-07", ValidationMessage.IssueType.NOTSUPPORTED, baseStack, (txInfo = this.context.getTxSupportInfo(system, version)).getTestVersion() != null && VersionUtilities.isThisOrLater((String)"1.7.8", (String)txInfo.getTestVersion(), (VersionUtilities.VersionPrecision)VersionUtilities.VersionPrecision.MINOR), "VALUESET_TXVER_BATCH_NOT_SUPPORTED", txInfo.getTestVersion() == null ? "Not Known" : txInfo.getTestVersion(), system + (String)(version == null ? "" : "|" + version), txInfo.getServer())) {
            long t = System.currentTimeMillis();
            log.debug("  : Validate " + batch.size() + " codes from " + system + " for " + vsid);
            this.context.validateCodeBatch(ValidationOptions.defaults().withExampleOK().setDisplayWarningMode(true), batch, null, false);
            log.debug("  :   .. " + (System.currentTimeMillis() - t) + "ms");
            for (VSCodingValidationRequest cv : batch) {
                if (version == null) {
                    this.warningOrError(!retired, errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack(), cv.getResult().isOk(), "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, cv.getCoding().getCode(), cv.getResult().getMessage());
                } else {
                    this.warningOrError(!retired, errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, cv.getStack(), cv.getResult().isOk(), "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, cv.getCoding().getCode(), cv.getResult().getMessage());
                }
                this.processConceptIssues(errors, cv.getStack().getElement(), cv.getStack(), system, version, cv.getResult(), cv.getCoding().getDisplay());
            }
        }
    }

    private boolean validateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stackInc, NodeStack stack, String system, String version, CodeSystemChecker slv, boolean locallyKnownCodeSystem) {
        String code = concept.getChildValue("code");
        String display = concept.getChildValue("display");
        slv.checkConcept(code, display);
        if (!this.noTerminologyChecks) {
            if (version == null) {
                ValidationResult vv = this.context.validateCode(ValidationOptions.defaults().withExampleOK().setDisplayWarningMode(true), new Coding(system, code, display), null);
                if (vv.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                    if (this.isExampleUrl(system)) {
                        if (this.settings.isAllowExamples()) {
                            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_EXAMPLE_SYSTEM_HINT", system);
                        } else {
                            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_EXAMPLE_SYSTEM_ERROR", system);
                        }
                    } else {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_UNC_SYSTEM_WARNING", system, vv.getMessage());
                    }
                    return false;
                }
                boolean ok = vv.isOk();
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE", system, code, vv.getMessage());
                if (vv.hasIssues()) {
                    this.processConceptIssues(errors, concept, stack, system, version, vv, display);
                } else if (vv.getMessage() != null) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, false, vv.getMessage(), new Object[0]);
                }
            } else {
                ValidationResult vv = this.context.validateCode(ValidationOptions.defaults().withExampleOK().setDisplayWarningMode(true), new Coding(system, code, display).setVersion(version), null);
                if (vv.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stackInc.getLiteralPath(), false, "VALUESET_UNC_SYSTEM_WARNING_VER", system + "#" + version, vv.getMessage());
                    return false;
                }
                boolean ok = vv.isOk();
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, ok, "VALUESET_INCLUDE_INVALID_CONCEPT_CODE_VER", system, version, code, vv.getMessage());
                if (vv.hasIssues()) {
                    this.processConceptIssues(errors, concept, stack, system, version, vv, display);
                } else if (vv.getMessage() != null) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack, false, vv.getMessage(), new Object[0]);
                }
            }
        }
        return true;
    }

    private void processConceptIssues(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version, ValidationResult vv, String display) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : vv.getIssues()) {
            if (iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "invalid-code")) continue;
            if (iss.getDetails().hasCoding("http://hl7.org/fhir/tools/CodeSystem/tx-issue-type", "invalid-display")) {
                this.hint(errors, "2025-10-30", ValidationMessage.IssueType.INFORMATIONAL, stack, false, version == null ? "VALUESET_CODE_CONCEPT_HINT" : "VALUESET_CODE_CONCEPT_HINT_VER", display, system, version);
                continue;
            }
            ValidationMessage validationMessage = this.buildValidationMessage(vv.getTxLink(), vv.getDiagnostics(), concept.line(), concept.col(), stack.getLiteralPath(), iss);
            errors.add(validationMessage);
        }
    }

    private VSCodingValidationRequest prepareValidateValueSetIncludeConcept(List<ValidationMessage> errors, Element concept, NodeStack stack, String system, String version, CodeSystemChecker slv) {
        String code = concept.getChildValue("code");
        String display = concept.getChildValue("display");
        slv.checkConcept(code, display);
        Coding c = new Coding(system, code, display);
        if (version != null) {
            c.setVersion(version);
        }
        return new VSCodingValidationRequest(stack, c);
    }

    private boolean validateValueSetIncludeFilter(List<ValidationMessage> errors, Element filter, NodeStack stack, String system, String version, CodeSystem cs, CodeSystemChecker csChecker, List<ParameterDeclaration> params) {
        Element expr;
        boolean ok = true;
        String property = filter.getChildValue("property");
        String op = filter.getChildValue("op");
        Element ve = filter.getNamedChild("value");
        String value = ve == null ? null : ve.primitiveValue();
        Element element = expr = ve == null ? null : ve.getExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression");
        if (property != null) {
            PropertyValidationRules rules;
            ArrayList<String> knownNames = new ArrayList<String>();
            csChecker.listPropertyNames(knownNames);
            boolean pok = false;
            pok = cs == null ? this.hint(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, knownNames.contains(property), "VALUESET_UNKNOWN_FILTER_PROPERTY_NO_CS", property, system, CommaSeparatedStringBuilder.join((String)",", knownNames)) : this.warning(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, knownNames.contains(property), "VALUESET_UNKNOWN_FILTER_PROPERTY", property, system, CommaSeparatedStringBuilder.join((String)",", knownNames));
            if (pok && (rules = csChecker.rulesForFilter(property, EnumSet.noneOf(PropertyOperation.class))) != null) {
                if (!rules.getOps().isEmpty()) {
                    boolean bl = ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, this.opInSet(op, rules.getOps()), "VALUESET_BAD_FILTER_OP", op, property, CommaSeparatedStringBuilder.join((String)",", rules.getOps()), system) && ok;
                }
                if (value == null) {
                    if (this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, expr != null && expr.hasChild("value"), "VALUESET_BAD_FILTER_EXPR_OR_VALUE", new Object[0])) {
                        String lang;
                        NodeStack estack = stack.push(expr, -1, null, null);
                        if (this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, estack = estack.push(expr = expr.getNamedChild("value"), -1, null, null), "text/fhirpath".equals(lang = expr.getNamedChildValue(new String[]{"language"})), "VALUESET_BAD_FILTER_EXPR_LANG", lang)) {
                            String expression = expr.getNamedChildValue(new String[]{"expression"});
                            ExpressionNode node = null;
                            try {
                                node = this.fpe.parse(expression);
                            }
                            catch (Exception e) {
                                this.rule(errors, "2024-03-09", ValidationMessage.IssueType.EXCEPTION, estack, false, "VALUESET_BAD_FILTER_EXPR_VALUE", expression, e.getMessage());
                                ok = false;
                            }
                            if (node != null) {
                                HashSet<String> constants = new HashSet<String>();
                                this.scanForConstants(constants, node);
                                for (String s : constants) {
                                    String pn = s.substring(1);
                                    ParameterDeclaration p = null;
                                    for (ParameterDeclaration pd : params) {
                                        if (!pd.getName().equals(pn)) continue;
                                        p = pd;
                                    }
                                    if (p == null) {
                                        this.rule(errors, "2024-03-09", ValidationMessage.IssueType.EXCEPTION, estack, false, "VALUESET_BAD_FILTER_EXPR_PARAM_NAME", expression, pn);
                                        ok = false;
                                        continue;
                                    }
                                    p.used = true;
                                }
                            }
                        } else {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                } else {
                    boolean bl = ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, expr == null, "VALUESET_BAD_FILTER_EXPR_AND_VALUE", new Object[0]) && ok;
                    if (rules.isActive()) {
                        CodeSystemChecker.StringWithFlag msg = csChecker.checkFilterValue(system, version, property, op, value, rules, ValidationOptions.defaults());
                        if (msg != null) {
                            if (msg.isFail()) {
                                this.warning(errors, "2025-06-16", ValidationMessage.IssueType.INVALID, stack, msg == null, "VALUESET_BAD_FILTER_VALUE_CANT_CHECK", property, value, msg.getMsg());
                            } else {
                                ok = this.rule(errors, "2025-06-16", ValidationMessage.IssueType.INVALID, stack, msg == null, "VALUESET_BAD_FILTER_VALUE_INVALID", property, value, msg.getMsg()) && ok;
                            }
                        }
                    } else if ("exists".equals(op)) {
                        ok = this.checkFilterValue(errors, stack, system, version, ok, property, op, value, new PropertyValidationRules(PropertyFilterType.Boolean, null, new PropertyOperation[0])) && ok;
                    } else if ("regex".equals(op)) {
                        String err = null;
                        try {
                            Pattern.compile(value);
                        }
                        catch (PatternSyntaxException e) {
                            err = e.getMessage();
                        }
                        ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, err == null, "VALUESET_BAD_FILTER_VALUE_VALID_REGEX", property, value, err) && ok;
                        ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, !"concept".equals(property), "VALUESET_BAD_PROPERTY_NO_REGEX", property) && ok;
                    } else if (Utilities.existsInList((String)op, (String[])new String[]{"in", "not-in"})) {
                        for (String v : value.split("\\,")) {
                            ok = this.checkFilterValue(errors, stack, system, version, ok, property, op, v, rules) && ok;
                        }
                    } else {
                        ok = this.checkFilterValue(errors, stack, system, version, ok, property, op, value, rules) && ok;
                    }
                }
            }
        }
        return ok;
    }

    private void scanForConstants(Set<String> constants, ExpressionNode node) {
        if (node.getKind() == ExpressionNode.Kind.Constant) {
            constants.add(node.getConstant().primitiveValue());
        }
        if (node.getOpNext() != null) {
            this.scanForConstants(constants, node.getOpNext());
        }
        if (node.getInner() != null) {
            this.scanForConstants(constants, node.getInner());
        }
        if (node.getGroup() != null) {
            this.scanForConstants(constants, node.getGroup());
        }
        if (node.getParameters() != null) {
            for (ExpressionNode p : node.getParameters()) {
                this.scanForConstants(constants, p);
            }
        }
    }

    private boolean opInSet(String op, EnumSet<PropertyOperation> ops) {
        switch (op) {
            case "=": {
                return ops.contains((Object)PropertyOperation.Equals);
            }
            case "is-a": {
                return ops.contains((Object)PropertyOperation.IsA);
            }
            case "descendent-of": {
                return ops.contains((Object)PropertyOperation.DescendentOf);
            }
            case "is-not-a": {
                return ops.contains((Object)PropertyOperation.IsNotA);
            }
            case "regex": {
                return ops.contains((Object)PropertyOperation.RegEx);
            }
            case "in": {
                return ops.contains((Object)PropertyOperation.In);
            }
            case "not-in": {
                return ops.contains((Object)PropertyOperation.NotIn);
            }
            case "generalizes": {
                return ops.contains((Object)PropertyOperation.Generalizes);
            }
            case "child-of": {
                return ops.contains((Object)PropertyOperation.ChildOf);
            }
            case "descendent-leaf": {
                return ops.contains((Object)PropertyOperation.DescendentLeaf);
            }
            case "exists": {
                return ops.contains((Object)PropertyOperation.Exists);
            }
        }
        return false;
    }

    private boolean checkFilterValue(List<ValidationMessage> errors, NodeStack stack, String system, String version, boolean ok, String property, String op, String value, PropertyValidationRules rules) {
        if (rules.getType() != null) {
            if (!Utilities.existsInList((String)op, (String[])new String[]{"in", "not-in"})) {
                this.hint(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !value.contains(","), "VALUESET_BAD_FILTER_VALUE_HAS_COMMA", rules.getType().toString());
            }
            switch (rules.getType()) {
                case Boolean: {
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, Utilities.existsInList((String)value, (String[])new String[]{"true", "false"}), "VALUESET_BAD_FILTER_VALUE_BOOLEAN", property, value) && ok;
                    break;
                }
                case String: {
                    break;
                }
                case Code: {
                    boolean bl = ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, value.trim().equals(value), "VALUESET_BAD_FILTER_VALUE_CODE", property, value) && ok;
                    if (this.noTerminologyChecks || rules.getCodeValidation() != CodeValidationRule.Error && rules.getCodeValidation() != CodeValidationRule.Warning) break;
                    ValidationResult vr = this.context.validateCode((ValidationOptions)this.settings, system, version, value, null);
                    if (vr.isOk()) {
                        this.warning(errors, "2025-06-04", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !vr.isInactive(), "VALUESET_BAD_FILTER_VALUE_VALID_CODE_INACTIVE", property, value, system);
                        break;
                    }
                    if (rules.getCodeValidation() == CodeValidationRule.Error) {
                        ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, rules.isChange() ? "VALUESET_BAD_FILTER_VALUE_VALID_CODE_CHANGE" : "VALUESET_BAD_FILTER_VALUE_VALID_CODE", property, value, system, vr.getMessage()) && ok;
                        break;
                    }
                    this.warning(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, rules.isChange() ? "VALUESET_BAD_FILTER_VALUE_VALID_CODE_CHANGE" : "VALUESET_BAD_FILTER_VALUE_VALID_CODE", property, value, system, vr.getMessage());
                    break;
                }
                case CodeList: {
                    ok = this.rule(errors, "2024-05-12", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), rules.getCodeList().contains(value), "VALUESET_BAD_FILTER_VALUE_DATETIME", property, value) && ok;
                    break;
                }
                case DateTime: {
                    if (value != null && Utilities.startsWithInList((String)value, (String[])new String[]{"eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"})) {
                        value = value.substring(2);
                    }
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), value.matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "VALUESET_BAD_FILTER_VALUE_DATETIME", property, value) && ok;
                    break;
                }
                case Decimal: {
                    if (value != null && Utilities.startsWithInList((String)value, (String[])new String[]{"eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"})) {
                        value = value.substring(2);
                    }
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), Utilities.isDecimal((String)value, (boolean)true), "VALUESET_BAD_FILTER_VALUE_DECIMAL", property, value) && ok;
                    break;
                }
                case Integer: {
                    if (value != null && Utilities.startsWithInList((String)value, (String[])new String[]{"eq", "ne", "gt", "lt", "ge", "le", "sa", "eb", "ap"})) {
                        value = value.substring(2);
                    }
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), Utilities.isInteger((String)value), "VALUESET_BAD_FILTER_VALUE_INTEGER", property, value) && ok;
                    break;
                }
                case Coding: {
                    Coding code;
                    if (value.matches("[a-zA-Z][a-zA-Z0-9+.-]*:[^\\s|]+\\|\\S+")) {
                        this.warning(errors, "2025-07-10", ValidationMessage.IssueType.INVALID, stack, false, "VALUESET_BAD_FILTER_VALUE_CODED_LEGACY", property, value);
                        code = new Coding().setSystem(value.substring(0, value.lastIndexOf("|"))).setCode(value.substring(value.lastIndexOf("|") + 1));
                    } else {
                        code = Coding.fromLiteral((String)value);
                    }
                    if (code == null) {
                        ok = this.rule(errors, "2025-07-10", ValidationMessage.IssueType.INVALID, stack, false, "VALUESET_BAD_FILTER_VALUE_CODED", property, value) && ok;
                        break;
                    }
                    if (this.noTerminologyChecks) break;
                    ValidationResult vr = this.context.validateCode((ValidationOptions)this.settings, code, null);
                    ok = this.rule(errors, "2024-03-09", ValidationMessage.IssueType.INVALID, stack, vr.isOk(), "VALUESET_BAD_FILTER_VALUE_CODED_INVALID", property, value, vr.getMessage()) && ok;
                    break;
                }
            }
        }
        return ok;
    }

    public class ParameterDeclaration {
        private Element ext;
        private String name;
        private String doco;
        private boolean used;

        public ParameterDeclaration(Element ext, String name, String doco) {
            this.ext = ext;
            this.name = name;
            this.doco = doco;
        }

        public String getName() {
            return this.name;
        }

        public String getDoco() {
            return this.doco;
        }

        public boolean isUsed() {
            return this.used;
        }
    }

    public class VSCodingValidationRequest
    extends CodingValidationRequest {
        private NodeStack stack;

        public VSCodingValidationRequest(NodeStack stack, Coding code) {
            super(code);
            this.stack = stack;
        }

        public NodeStack getStack() {
            return this.stack;
        }
    }

    public static enum PropertyOperation {
        Equals,
        IsA,
        DescendentOf,
        IsNotA,
        RegEx,
        In,
        NotIn,
        Generalizes,
        ChildOf,
        DescendentLeaf,
        Exists;


        public String toString() {
            switch (this) {
                case ChildOf: {
                    return "child-of";
                }
                case DescendentLeaf: {
                    return "descendent-leaf";
                }
                case DescendentOf: {
                    return "descendent-of";
                }
                case Equals: {
                    return "=";
                }
                case Exists: {
                    return "exists";
                }
                case Generalizes: {
                    return "generalizes";
                }
                case In: {
                    return "in";
                }
                case IsA: {
                    return "is-a";
                }
                case IsNotA: {
                    return "is-not-a";
                }
                case NotIn: {
                    return "not-in";
                }
                case RegEx: {
                    return "regex";
                }
            }
            return "?";
        }
    }

    public static class PropertyValidationRules {
        private PropertyFilterType type;
        private CodeValidationRule codeValidation;
        private EnumSet<PropertyOperation> ops;
        private List<String> codeList = new ArrayList<String>();
        private boolean change;
        private boolean active;

        protected PropertyValidationRules(PropertyFilterType type, CodeValidationRule codeValidation, PropertyOperation ... ops) {
            this.type = type;
            this.codeValidation = codeValidation;
            this.ops = EnumSet.noneOf(PropertyOperation.class);
            for (PropertyOperation op : ops) {
                this.ops.add(op);
            }
        }

        public PropertyValidationRules(PropertyFilterType type, CodeValidationRule codeValidation, EnumSet<PropertyOperation> ops) {
            this.type = type;
            this.codeValidation = codeValidation;
            this.ops = ops;
        }

        public PropertyFilterType getType() {
            return this.type;
        }

        public EnumSet<PropertyOperation> getOps() {
            return this.ops;
        }

        public CodeValidationRule getCodeValidation() {
            return this.codeValidation;
        }

        public List<String> getCodeList() {
            return this.codeList;
        }

        public PropertyValidationRules setCodes(String ... values) {
            for (String v : values) {
                this.codeList.add(v);
            }
            return this;
        }

        public boolean isChange() {
            return this.change;
        }

        public PropertyValidationRules setChange(boolean change) {
            this.change = change;
            return this;
        }

        public boolean isActive() {
            return this.active;
        }

        public PropertyValidationRules setActive(boolean active) {
            this.active = active;
            return this;
        }
    }

    public static enum PropertyFilterType {
        Boolean,
        Integer,
        Decimal,
        Code,
        DateTime,
        Coding,
        CodeList,
        String;

    }

    public static enum CodeValidationRule {
        Warning,
        Error,
        None;

    }
}

