/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.hl7.fhir.r5.terminologies.utilities.SnomedUtilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.settings.FhirSettings;

public class ValidationEngineParameters {
    @JsonProperty(value="baseEngine")
    @SerializedName(value="baseEngine")
    private String baseEngine = null;
    @JsonProperty(value="sv")
    @SerializedName(value="sv")
    private String sv = null;
    @JsonProperty(value="doNative")
    @SerializedName(value="doNative")
    private boolean doNative = false;
    @JsonProperty(value="recursive")
    @SerializedName(value="recursive")
    private boolean recursive = false;
    @JsonProperty(value="snomedCT")
    @SerializedName(value="snomedCT")
    private String snomedCT = "900000000000207008";
    @JsonProperty(value="igs")
    @SerializedName(value="igs")
    private List<String> igs = new ArrayList<String>();
    @JsonProperty(value="resolutionContext")
    @SerializedName(value="resolutionContext")
    private String resolutionContext = null;
    @JsonProperty(value="aiService")
    @SerializedName(value="aiService")
    private String aiService;
    @JsonProperty(value="certSources")
    @SerializedName(value="certSources")
    private List<String> certSources = new ArrayList<String>();
    @JsonProperty(value="txServer")
    @SerializedName(value="txServer")
    private String txServer = FhirSettings.getTxFhirProduction();
    @JsonProperty(value="noEcosystem")
    @SerializedName(value="noEcosystem")
    private boolean noEcosystem = false;
    @JsonProperty(value="txLog")
    @SerializedName(value="txLog")
    private String txLog = null;
    @JsonProperty(value="txCache")
    @SerializedName(value="txCache")
    private String txCache = null;
    @JsonProperty(value="clearTxCache")
    @SerializedName(value="clearTxCache")
    private boolean clearTxCache = false;
    @JsonProperty(value="advisorFile")
    @SerializedName(value="advisorFile")
    private String advisorFile;
    @JsonProperty(value="locale")
    @SerializedName(value="locale")
    private String locale = Locale.ENGLISH.toLanguageTag();
    @JsonProperty(value="lang")
    @SerializedName(value="lang")
    private String lang = null;
    @JsonProperty(value="checkReferences")
    @SerializedName(value="checkReferences")
    private boolean checkReferences = false;
    @JsonProperty(value="noInternalCaching")
    @SerializedName(value="noInternalCaching")
    private boolean noInternalCaching = false;
    @JsonProperty(value="disableDefaultResourceFetcher")
    @SerializedName(value="disableDefaultResourceFetcher")
    private boolean disableDefaultResourceFetcher = false;
    @JsonProperty(value="mapLog")
    @SerializedName(value="mapLog")
    private String mapLog = null;
    @JsonProperty(value="displayWarnings")
    @SerializedName(value="displayWarnings")
    private boolean displayWarnings = false;
    @JsonProperty(value="noExtensibleBindingMessages")
    @SerializedName(value="noExtensibleBindingMessages")
    private boolean noExtensibleBindingMessages = false;
    private Boolean inferFhirVersion = true;

    @SerializedName(value="baseEngine")
    @JsonProperty(value="baseEngine")
    public String getBaseEngine() {
        return this.baseEngine;
    }

    @SerializedName(value="baseEngine")
    @JsonProperty(value="baseEngine")
    public ValidationEngineParameters setBaseEngine(String baseEngine) {
        this.baseEngine = baseEngine;
        return this;
    }

    @SerializedName(value="sv")
    @JsonProperty(value="sv")
    public String getSv() {
        return this.sv;
    }

    @SerializedName(value="sv")
    @JsonProperty(value="sv")
    public ValidationEngineParameters setSv(String sv) {
        this.sv = sv != null && (sv.startsWith("R") || sv.startsWith("r")) ? VersionUtilities.versionFromCode((String)sv.toLowerCase()) : sv;
        return this;
    }

    @SerializedName(value="doNative")
    @JsonProperty(value="doNative")
    public boolean isDoNative() {
        return this.doNative;
    }

    @SerializedName(value="doNative")
    @JsonProperty(value="doNative")
    public ValidationEngineParameters setDoNative(boolean doNative) {
        this.doNative = doNative;
        return this;
    }

    @SerializedName(value="recursive")
    @JsonProperty(value="recursive")
    public boolean isRecursive() {
        return this.recursive;
    }

    @SerializedName(value="recursive")
    @JsonProperty(value="recursive")
    public ValidationEngineParameters setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @SerializedName(value="snomedCT")
    @JsonProperty(value="snomedCT")
    public String getSnomedCTCode() {
        String number = SnomedUtilities.getCodeFromAlias((String)this.snomedCT);
        if (number != null) {
            return number;
        }
        return this.snomedCT;
    }

    public String getSnomedCT() {
        return this.snomedCT;
    }

    @SerializedName(value="snomedCT")
    @JsonProperty(value="snomedCT")
    public ValidationEngineParameters setSnomedCT(String snomedCT) {
        this.snomedCT = snomedCT;
        return this;
    }

    @SerializedName(value="igs")
    @JsonProperty(value="igs")
    public List<String> getIgs() {
        return this.igs;
    }

    @SerializedName(value="igs")
    @JsonProperty(value="igs")
    public ValidationEngineParameters setIgs(List<String> igs) {
        this.igs = igs;
        return this;
    }

    public ValidationEngineParameters addIg(String ig) {
        if (this.igs == null) {
            this.igs = new ArrayList<String>();
        }
        this.igs.add(ig);
        return this;
    }

    @SerializedName(value="resolutionContext")
    @JsonProperty(value="resolutionContext")
    public String getResolutionContext() {
        return this.resolutionContext;
    }

    @SerializedName(value="resolutionContext")
    @JsonProperty(value="resolutionContext")
    public ValidationEngineParameters setResolutionContext(String resolutionContext) {
        this.resolutionContext = resolutionContext;
        return this;
    }

    @SerializedName(value="aiService")
    @JsonProperty(value="aiService")
    public String getAIService() {
        return this.aiService;
    }

    @SerializedName(value="aiService")
    @JsonProperty(value="aiService")
    public ValidationEngineParameters setAIService(String aiService) {
        this.aiService = aiService;
        return this;
    }

    @SerializedName(value="certSources")
    @JsonProperty(value="certSources")
    public List<String> getCertSources() {
        return this.certSources;
    }

    @SerializedName(value="certSources")
    @JsonProperty(value="certSources")
    public ValidationEngineParameters setCertSources(List<String> certSources) {
        this.certSources = certSources;
        return this;
    }

    public ValidationEngineParameters addCertSource(String certSource) {
        this.certSources.add(certSource);
        return this;
    }

    @SerializedName(value="txServer")
    @JsonProperty(value="txServer")
    public String getTxServer() {
        return this.txServer;
    }

    @SerializedName(value="txServer")
    @JsonProperty(value="txServer")
    public ValidationEngineParameters setTxServer(String txServer) {
        this.txServer = txServer;
        return this;
    }

    @SerializedName(value="noEcosystem")
    @JsonProperty(value="noEcosystem")
    public boolean getNoEcosystem() {
        return this.noEcosystem;
    }

    @SerializedName(value="noEcosystem")
    @JsonProperty(value="noEcosystem")
    public ValidationEngineParameters setNoEcosystem(boolean noEcosystem) {
        this.noEcosystem = noEcosystem;
        return this;
    }

    @SerializedName(value="txLog")
    @JsonProperty(value="txLog")
    public String getTxLog() {
        return this.txLog;
    }

    @SerializedName(value="txLog")
    @JsonProperty(value="txLog")
    public ValidationEngineParameters setTxLog(String txLog) {
        this.txLog = txLog;
        return this;
    }

    @SerializedName(value="txCache")
    @JsonProperty(value="txCache")
    public String getTxCache() {
        return this.txCache;
    }

    @SerializedName(value="txCache")
    @JsonProperty(value="txCache")
    public ValidationEngineParameters setTxCache(String txCache) {
        this.txCache = txCache;
        return this;
    }

    @SerializedName(value="clearTxCache")
    @JsonProperty(value="clearTxCache")
    public boolean isClearTxCache() {
        return this.clearTxCache;
    }

    @SerializedName(value="clearTxCache")
    @JsonProperty(value="clearTxCache")
    public ValidationEngineParameters setClearTxCache(boolean clearTxCache) {
        this.clearTxCache = clearTxCache;
        return this;
    }

    @SerializedName(value="advisorFile")
    @JsonProperty(value="advisorFile")
    public String getAdvisorFile() {
        return this.advisorFile;
    }

    @SerializedName(value="advisorFile")
    @JsonProperty(value="advisorFile")
    public ValidationEngineParameters setAdvisorFile(String advisorFile) {
        this.advisorFile = advisorFile;
        return this;
    }

    @SerializedName(value="locale")
    @JsonProperty(value="locale")
    public String getLanguageCode() {
        return this.locale;
    }

    public Locale getLocale() {
        return Locale.forLanguageTag(this.locale);
    }

    @SerializedName(value="locale")
    @JsonProperty(value="locale")
    public ValidationEngineParameters setLocale(String languageString) {
        this.locale = languageString;
        return this;
    }

    public ValidationEngineParameters setLocale(Locale locale) {
        this.locale = locale.getLanguage();
        return this;
    }

    @SerializedName(value="lang")
    @JsonProperty(value="lang")
    public String getLang() {
        return this.lang;
    }

    @SerializedName(value="lang")
    @JsonProperty(value="lang")
    public ValidationEngineParameters setLang(String lang) {
        this.lang = lang;
        return this;
    }

    @SerializedName(value="checkReferences")
    @JsonProperty(value="checkReferences")
    public boolean isCheckReferences() {
        return this.checkReferences;
    }

    @SerializedName(value="checkReferences")
    @JsonProperty(value="checkReferences")
    public ValidationEngineParameters setCheckReferences(boolean checkReferences) {
        this.checkReferences = checkReferences;
        return this;
    }

    @SerializedName(value="noInternalCaching")
    @JsonProperty(value="noInternalCaching")
    public boolean isNoInternalCaching() {
        return this.noInternalCaching;
    }

    @SerializedName(value="noInternalCaching")
    @JsonProperty(value="noInternalCaching")
    public ValidationEngineParameters setNoInternalCaching(boolean noInternalCaching) {
        this.noInternalCaching = noInternalCaching;
        return this;
    }

    @SerializedName(value="disableDefaultResourceFetcher")
    @JsonProperty(value="disableDefaultResourceFetcher")
    public boolean isDisableDefaultResourceFetcher() {
        return this.disableDefaultResourceFetcher;
    }

    @SerializedName(value="disableDefaultResourceFetcher")
    @JsonProperty(value="disableDefaultResourceFetcher")
    public ValidationEngineParameters setDisableDefaultResourceFetcher(boolean disableDefaultResourceFetcher) {
        this.disableDefaultResourceFetcher = disableDefaultResourceFetcher;
        return this;
    }

    @SerializedName(value="mapLog")
    @JsonProperty(value="mapLog")
    public String getMapLog() {
        return this.mapLog;
    }

    @SerializedName(value="mapLog")
    @JsonProperty(value="mapLog")
    public ValidationEngineParameters setMapLog(String mapLog) {
        this.mapLog = mapLog;
        return this;
    }

    @SerializedName(value="displayWarnings")
    @JsonProperty(value="displayWarnings")
    public boolean isDisplayWarnings() {
        return this.displayWarnings;
    }

    @SerializedName(value="displayWarnings")
    @JsonProperty(value="displayWarnings")
    public ValidationEngineParameters setDisplayWarnings(boolean displayWarnings) {
        this.displayWarnings = displayWarnings;
        return this;
    }

    @SerializedName(value="noExtensibleBindingMessages")
    @JsonProperty(value="noExtensibleBindingMessages")
    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    @SerializedName(value="noExtensibleBindingMessages")
    @JsonProperty(value="noExtensibleBindingMessages")
    public ValidationEngineParameters setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
        return this;
    }

    public Boolean isInferFhirVersion() {
        return this.inferFhirVersion;
    }

    public ValidationEngineParameters setInferFhirVersion(Boolean inferFhirVersion) {
        this.inferFhirVersion = inferFhirVersion;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationEngineParameters that = (ValidationEngineParameters)o;
        return Objects.equals(this.baseEngine, that.baseEngine) && this.doNative == that.doNative && this.recursive == that.recursive && this.snomedCT.equals(that.snomedCT) && this.sv.equals(that.sv) && this.isInferFhirVersion() == that.isInferFhirVersion() && this.noEcosystem == that.noEcosystem && this.clearTxCache == that.clearTxCache && this.checkReferences == that.checkReferences && this.noInternalCaching == that.noInternalCaching && this.disableDefaultResourceFetcher == that.disableDefaultResourceFetcher && this.displayWarnings == that.displayWarnings && this.noExtensibleBindingMessages == that.noExtensibleBindingMessages && Objects.equals(this.resolutionContext, that.resolutionContext) && Objects.equals(this.aiService, that.aiService) && Objects.equals(this.certSources, that.certSources) && Objects.equals(this.txServer, that.txServer) && Objects.equals(this.txLog, that.txLog) && Objects.equals(this.txCache, that.txCache) && Objects.equals(this.advisorFile, that.advisorFile) && Objects.equals(this.locale, that.locale) && Objects.equals(this.lang, that.lang) && Objects.equals(this.mapLog, that.mapLog);
    }

    public int hashCode() {
        return Objects.hash(this.baseEngine, this.doNative, this.recursive, this.snomedCT, this.sv, this.inferFhirVersion, this.resolutionContext, this.aiService, this.certSources, this.txServer, this.noEcosystem, this.txLog, this.txCache, this.clearTxCache, this.advisorFile, this.locale, this.lang, this.checkReferences, this.noInternalCaching, this.disableDefaultResourceFetcher, this.mapLog, this.displayWarnings, this.noExtensibleBindingMessages);
    }

    public String toString() {
        return "ValidationEngineParameters{baseEngine=" + this.baseEngine + ", doNative=" + this.doNative + ", recursive=" + this.recursive + ", snomedCT=" + this.snomedCT + ", sv=" + this.sv + ", inferFhirVersion=" + this.inferFhirVersion + ", resolutionContext='" + this.resolutionContext + "', aiService='" + this.aiService + "', certSources=" + String.valueOf(this.certSources) + ", txServer='" + this.txServer + "', noEcosystem=" + this.noEcosystem + ", txLog='" + this.txLog + "', txCache='" + this.txCache + "', clearTxCache=" + this.clearTxCache + ", advisorFile='" + this.advisorFile + "', locale='" + this.locale + "', lang='" + this.lang + "', checkReferences=" + this.checkReferences + ", noInternalCaching=" + this.noInternalCaching + ", disableDefaultResourceFetcher=" + this.disableDefaultResourceFetcher + ", mapLog='" + this.mapLog + "', displayWarnings=" + this.displayWarnings + ", noExtensibleBindingMessages=" + this.noExtensibleBindingMessages + "}";
    }
}

