/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.CheckDisplayOption;
import org.hl7.fhir.r5.utils.validation.constants.IdStatus;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.instance.ResourcePercentageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirValidatorHttpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FhirValidatorHttpService.class);
    private final ValidationEngine validationEngine;
    private HttpServer server;
    private final int port;

    public FhirValidatorHttpService(ValidationEngine validationEngine, int port) {
        this.validationEngine = validationEngine;
        this.port = port;
        ResourcePercentageLogger.setLoggingSuppressed(true);
    }

    public void startServer() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/validateResource", new ValidateResourceHandler());
        this.server.setExecutor(null);
        this.server.start();
        log.info("FHIR Validator HTTP Service started on port " + this.port);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            log.info("FHIR Validator HTTP Service stopped");
        }
    }

    private Map<String, String> parseQueryParams(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] keyValue = pair.split("=", 2);
                if (keyValue.length != 2) continue;
                try {
                    String key = URLDecoder.decode(keyValue[0], StandardCharsets.UTF_8.name());
                    String value = URLDecoder.decode(keyValue[1], StandardCharsets.UTF_8.name());
                    params.put(key, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return params;
    }

    private byte[] readRequestBody(HttpExchange exchange) throws IOException {
        try (InputStream is = exchange.getRequestBody();){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private Manager.FhirFormat determineFormat(String contentType) {
        if (contentType == null) {
            return Manager.FhirFormat.JSON;
        }
        if ((contentType = contentType.toLowerCase()).contains("xml")) {
            return Manager.FhirFormat.XML;
        }
        if (contentType.contains("json")) {
            return Manager.FhirFormat.JSON;
        }
        return Manager.FhirFormat.JSON;
    }

    private String getAcceptHeader(HttpExchange exchange) {
        String accept = exchange.getRequestHeaders().getFirst("Accept");
        if (accept != null && accept.toLowerCase().contains("xml")) {
            return "xml";
        }
        return "json";
    }

    private List<String> parseListParameter(String param) {
        if (param == null || param.trim().isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(param.split(","));
    }

    private IdStatus parseIdStatus(String param) {
        if (param == null) {
            return IdStatus.OPTIONAL;
        }
        return IdStatus.valueOf((String)param.toUpperCase());
    }

    private boolean parseBooleanParameter(String param, boolean defaultValue) {
        if (param == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(param);
    }

    private BestPracticeWarningLevel parseBestPracticeWarningLevel(String param) {
        if (param == null) {
            return BestPracticeWarningLevel.Ignore;
        }
        return BestPracticeWarningLevel.valueOf((String)param);
    }

    private CheckDisplayOption parseCheckDisplayOption(String param) {
        if (param == null) {
            return CheckDisplayOption.Ignore;
        }
        return CheckDisplayOption.valueOf((String)param);
    }

    private OperationOutcome createSuccessOperationOutcome(String message) {
        OperationOutcome outcome = new OperationOutcome();
        OperationOutcome.OperationOutcomeIssueComponent issue = outcome.addIssue();
        issue.setSeverity(OperationOutcome.IssueSeverity.INFORMATION);
        issue.setCode(OperationOutcome.IssueType.INFORMATIONAL);
        issue.setDiagnostics(message);
        return outcome;
    }

    private OperationOutcome createErrorOperationOutcome(String message) {
        OperationOutcome outcome = new OperationOutcome();
        OperationOutcome.OperationOutcomeIssueComponent issue = outcome.addIssue();
        issue.setSeverity(OperationOutcome.IssueSeverity.ERROR);
        issue.setCode(OperationOutcome.IssueType.EXCEPTION);
        issue.setDiagnostics(message);
        return outcome;
    }

    private void sendOperationOutcome(HttpExchange exchange, int statusCode, OperationOutcome outcome, String format) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if ("xml".equalsIgnoreCase(format)) {
                new XmlParser().compose((OutputStream)baos, (Resource)outcome);
                this.sendResponse(exchange, statusCode, baos.toString(StandardCharsets.UTF_8.name()), "application/fhir+xml");
            } else {
                new JsonParser().compose((OutputStream)baos, (Resource)outcome);
                this.sendResponse(exchange, statusCode, baos.toString(StandardCharsets.UTF_8.name()), "application/fhir+json");
            }
        }
        catch (Exception e) {
            this.sendResponse(exchange, 500, "Error serializing response: " + e.getMessage(), "text/plain");
        }
    }

    private void sendResponse(HttpExchange exchange, int statusCode, String response, String contentType) throws IOException {
        byte[] responseBytes = response.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", contentType);
        exchange.sendResponseHeaders(statusCode, responseBytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(responseBytes);
        }
    }

    private class ValidateResourceHandler
    implements HttpHandler {
        private ValidateResourceHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            if (!"POST".equals(exchange.getRequestMethod())) {
                FhirValidatorHttpService.this.sendResponse(exchange, 405, "Method not allowed", "text/plain");
                return;
            }
            List<String> profiles = null;
            IdStatus resourceIdRule = null;
            boolean anyExtensionsAllowed = false;
            BestPracticeWarningLevel bpWarnings = null;
            CheckDisplayOption displayOption = null;
            byte[] resourceBytes = null;
            Manager.FhirFormat format = null;
            try {
                resourceBytes = FhirValidatorHttpService.this.readRequestBody(exchange);
                String contentType = exchange.getRequestHeaders().getFirst("Content-Type");
                format = FhirValidatorHttpService.this.determineFormat(contentType);
                Map<String, String> params = FhirValidatorHttpService.this.parseQueryParams(exchange.getRequestURI().getQuery());
                profiles = FhirValidatorHttpService.this.parseListParameter(params.get("profiles"));
                resourceIdRule = FhirValidatorHttpService.this.parseIdStatus(params.get("resourceIdRule"));
                anyExtensionsAllowed = FhirValidatorHttpService.this.parseBooleanParameter(params.get("anyExtensionsAllowed"), true);
                bpWarnings = FhirValidatorHttpService.this.parseBestPracticeWarningLevel(params.get("bpWarnings"));
                displayOption = FhirValidatorHttpService.this.parseCheckDisplayOption(params.get("displayOption"));
            }
            catch (Exception e) {
                OperationOutcome outcome = FhirValidatorHttpService.this.createErrorOperationOutcome("Operation failed: " + e.getMessage());
                FhirValidatorHttpService.this.sendOperationOutcome(exchange, 400, outcome, FhirValidatorHttpService.this.getAcceptHeader(exchange));
                return;
            }
            try {
                OperationOutcome outcome = FhirValidatorHttpService.this.validationEngine.validate("http-request", resourceBytes, format, profiles, resourceIdRule, anyExtensionsAllowed, bpWarnings, displayOption);
                FhirValidatorHttpService.this.sendOperationOutcome(exchange, 200, outcome, FhirValidatorHttpService.this.getAcceptHeader(exchange));
            }
            catch (Throwable e) {
                OperationOutcome outcome = FhirValidatorHttpService.this.createErrorOperationOutcome("Validation failed: " + e.getMessage());
                FhirValidatorHttpService.this.sendOperationOutcome(exchange, 500, outcome, FhirValidatorHttpService.this.getAcceptHeader(exchange));
            }
        }
    }
}

