/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.service.model.HtmlInMarkdownCheck;
import org.hl7.fhir.validation.service.utils.QuestionnaireMode;
import org.hl7.fhir.validation.service.utils.ValidationLevel;

public class InstanceValidatorParameters {
    @JsonProperty(value="assumeValidRestReferences")
    @SerializedName(value="assumeValidRestReferences")
    private boolean assumeValidRestReferences = false;
    @JsonProperty(value="noExtensibleBindingMessages")
    @SerializedName(value="noExtensibleBindingMessages")
    private boolean noExtensibleBindingMessages = false;
    @JsonProperty(value="showTimes")
    @SerializedName(value="showTimes")
    private boolean showTimes = false;
    @JsonProperty(value="hintAboutNonMustSupport")
    @SerializedName(value="hintAboutNonMustSupport")
    private boolean hintAboutNonMustSupport = false;
    @JsonProperty(value="htmlOutput")
    @SerializedName(value="htmlOutput")
    private String htmlOutput = null;
    @JsonProperty(value="outputStyle")
    @SerializedName(value="outputStyle")
    private String outputStyle = null;
    @JsonProperty(value="r5BundleRelativeReferencePolicy")
    @SerializedName(value="r5BundleRelativeReferencePolicy")
    private ValidationOptions.R5BundleRelativeReferencePolicy r5BundleRelativeReferencePolicy;
    @JsonProperty(value="extensions")
    @SerializedName(value="extensions")
    private List<String> extensions = new ArrayList<String>();
    @JsonProperty(value="wantInvariantsInMessages")
    @SerializedName(value="wantInvariantsInMessages")
    private boolean wantInvariantsInMessages = false;
    @JsonProperty(value="noInvariants")
    @SerializedName(value="noInvariants")
    private boolean noInvariants = false;
    @JsonProperty(value="questionnaire")
    @SerializedName(value="questionnaire")
    private QuestionnaireMode questionnaireMode = QuestionnaireMode.CHECK;
    @JsonProperty(value="displayWarnings")
    @SerializedName(value="displayWarnings")
    private boolean displayWarnings = false;
    @JsonProperty(value="unknownCodeSystemsCauseErrors")
    @SerializedName(value="unknownCodeSystemsCauseErrors")
    private boolean unknownCodeSystemsCauseErrors;
    @JsonProperty(value="level")
    @SerializedName(value="level")
    private ValidationLevel level = ValidationLevel.HINTS;
    @JsonProperty(value="bestPracticeLevel")
    @SerializedName(value="bestPracticeLevel")
    private BestPracticeWarningLevel bestPracticeLevel = BestPracticeWarningLevel.Warning;
    @JsonProperty(value="forPublication")
    @SerializedName(value="forPublication")
    private boolean forPublication = false;
    @JsonProperty(value="htmlInMarkdownCheck")
    @SerializedName(value="htmlInMarkdownCheck")
    private HtmlInMarkdownCheck htmlInMarkdownCheck = HtmlInMarkdownCheck.WARNING;
    @JsonProperty(value="noUnicodeBiDiControlChars")
    @SerializedName(value="noUnicodeBiDiControlChars")
    private boolean noUnicodeBiDiControlChars = false;
    @JsonProperty(value="crumbTrails")
    @SerializedName(value="crumbTrails")
    private boolean crumbTrails = false;
    @JsonProperty(value="showMessageIds")
    @SerializedName(value="showMessageIds")
    private boolean showMessageIds = false;
    @JsonProperty(value="allowExampleUrls")
    @SerializedName(value="allowExampleUrls")
    private boolean allowExampleUrls = false;
    @JsonProperty(value="showMessagesFromReferences")
    @SerializedName(value="showMessagesFromReferences")
    private boolean showMessagesFromReferences = false;
    @JsonProperty(value="securityChecks")
    @SerializedName(value="securityChecks")
    private boolean securityChecks = false;
    @JsonProperty(value="noExperimentalContent")
    @SerializedName(value="noExperimentalContent")
    private boolean noExperimentalContent;
    @JsonProperty(value="showTerminologyRouting")
    @SerializedName(value="showTerminologyRouting")
    private boolean showTerminologyRouting = false;
    @JsonProperty(value="matchetypes")
    @SerializedName(value="matchetypes")
    private List<String> matchetypes = new ArrayList<String>();
    @JsonProperty(value="expansionParameters")
    @SerializedName(value="expansionParameters")
    private String expansionParameters;
    @JsonProperty(value="profiles")
    @SerializedName(value="profiles")
    private List<String> profiles = new ArrayList<String>();

    @SerializedName(value="assumeValidRestReferences")
    @JsonProperty(value="assumeValidRestReferences")
    public boolean isAssumeValidRestReferences() {
        return this.assumeValidRestReferences;
    }

    @SerializedName(value="assumeValidRestReferences")
    @JsonProperty(value="assumeValidRestReferences")
    public InstanceValidatorParameters setAssumeValidRestReferences(boolean assumeValidRestReferences) {
        this.assumeValidRestReferences = assumeValidRestReferences;
        return this;
    }

    @SerializedName(value="noExtensibleBindingMessages")
    @JsonProperty(value="noExtensibleBindingMessages")
    public boolean isNoExtensibleBindingMessages() {
        return this.noExtensibleBindingMessages;
    }

    @SerializedName(value="noExtensibleBindingMessages")
    @JsonProperty(value="noExtensibleBindingMessages")
    public InstanceValidatorParameters setNoExtensibleBindingMessages(boolean noExtensibleBindingMessages) {
        this.noExtensibleBindingMessages = noExtensibleBindingMessages;
        return this;
    }

    @SerializedName(value="showTimes")
    @JsonProperty(value="showTimes")
    public boolean isShowTimes() {
        return this.showTimes;
    }

    @SerializedName(value="showTimes")
    @JsonProperty(value="showTimes")
    public InstanceValidatorParameters setShowTimes(boolean showTimes) {
        this.showTimes = showTimes;
        return this;
    }

    @SerializedName(value="hintAboutNonMustSupport")
    @JsonProperty(value="hintAboutNonMustSupport")
    public boolean isHintAboutNonMustSupport() {
        return this.hintAboutNonMustSupport;
    }

    @SerializedName(value="hintAboutNonMustSupport")
    @JsonProperty(value="hintAboutNonMustSupport")
    public InstanceValidatorParameters setHintAboutNonMustSupport(boolean hintAboutNonMustSupport) {
        this.hintAboutNonMustSupport = hintAboutNonMustSupport;
        return this;
    }

    @SerializedName(value="htmlOutput")
    @JsonProperty(value="htmlOutput")
    public String getHtmlOutput() {
        return this.htmlOutput;
    }

    @SerializedName(value="htmlOutput")
    @JsonProperty(value="htmlOutput")
    public InstanceValidatorParameters setHtmlOutput(String htmlOutput) {
        this.htmlOutput = htmlOutput;
        return this;
    }

    @SerializedName(value="outputStyle")
    @JsonProperty(value="outputStyle")
    public String getOutputStyle() {
        return this.outputStyle;
    }

    @SerializedName(value="outputStyle")
    @JsonProperty(value="outputStyle")
    public InstanceValidatorParameters setOutputStyle(String outputStyle) {
        this.outputStyle = outputStyle;
        return this;
    }

    public ValidationOptions.R5BundleRelativeReferencePolicy getR5BundleRelativeReferencePolicy() {
        return this.r5BundleRelativeReferencePolicy;
    }

    public InstanceValidatorParameters setR5BundleRelativeReferencePolicy(ValidationOptions.R5BundleRelativeReferencePolicy r5BundleRelativeReferencePolicy) {
        this.r5BundleRelativeReferencePolicy = r5BundleRelativeReferencePolicy;
        return this;
    }

    @SerializedName(value="extensions")
    @JsonProperty(value="extensions")
    public List<String> getExtensions() {
        return this.extensions;
    }

    @SerializedName(value="extensions")
    @JsonProperty(value="extensions")
    public InstanceValidatorParameters setExtensions(List<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    public InstanceValidatorParameters addExtension(String extension) {
        this.extensions.add(extension);
        return this;
    }

    @SerializedName(value="wantInvariantsInMessages")
    @JsonProperty(value="wantInvariantsInMessages")
    public boolean isWantInvariantsInMessages() {
        return this.wantInvariantsInMessages;
    }

    @SerializedName(value="wantInvariantsInMessages")
    @JsonProperty(value="wantInvariantsInMessages")
    public InstanceValidatorParameters setWantInvariantsInMessages(boolean wantInvariantsInMessages) {
        this.wantInvariantsInMessages = wantInvariantsInMessages;
        return this;
    }

    @SerializedName(value="noInvariants")
    @JsonProperty(value="noInvariants")
    public boolean isNoInvariants() {
        return this.noInvariants;
    }

    @SerializedName(value="noInvariants")
    @JsonProperty(value="noInvariants")
    public InstanceValidatorParameters setNoInvariants(boolean noInvariants) {
        this.noInvariants = noInvariants;
        return this;
    }

    @SerializedName(value="questionnaire")
    @JsonProperty(value="questionnaire")
    public QuestionnaireMode getQuestionnaireMode() {
        return this.questionnaireMode;
    }

    @SerializedName(value="questionnaire")
    @JsonProperty(value="questionnaire")
    public InstanceValidatorParameters setQuestionnaireMode(QuestionnaireMode questionnaireMode) {
        this.questionnaireMode = questionnaireMode;
        return this;
    }

    @SerializedName(value="displayWarnings")
    @JsonProperty(value="displayWarnings")
    public boolean isDisplayWarnings() {
        return this.displayWarnings;
    }

    @SerializedName(value="displayWarnings")
    @JsonProperty(value="displayWarnings")
    public InstanceValidatorParameters setDisplayWarnings(boolean displayWarnings) {
        this.displayWarnings = displayWarnings;
        return this;
    }

    @SerializedName(value="unknownCodeSystemsCauseErrors")
    @JsonProperty(value="unknownCodeSystemsCauseErrors")
    public boolean isUnknownCodeSystemsCauseErrors() {
        return this.unknownCodeSystemsCauseErrors;
    }

    @SerializedName(value="unknownCodeSystemsCauseErrors")
    @JsonProperty(value="unknownCodeSystemsCauseErrors")
    public InstanceValidatorParameters setUnknownCodeSystemsCauseErrors(boolean unknownCodeSystemsCauseErrors) {
        this.unknownCodeSystemsCauseErrors = unknownCodeSystemsCauseErrors;
        return this;
    }

    @SerializedName(value="level")
    @JsonProperty(value="level")
    public ValidationLevel getLevel() {
        return this.level;
    }

    @SerializedName(value="level")
    @JsonProperty(value="level")
    public InstanceValidatorParameters setLevel(ValidationLevel level) {
        this.level = level;
        return this;
    }

    @SerializedName(value="bestPracticeLevel")
    @JsonProperty(value="bestPracticeLevel")
    public BestPracticeWarningLevel getBestPracticeLevel() {
        return this.bestPracticeLevel;
    }

    @SerializedName(value="bestPracticeLevel")
    @JsonProperty(value="bestPracticeLevel")
    public InstanceValidatorParameters setBestPracticeLevel(BestPracticeWarningLevel bestPracticeLevel) {
        this.bestPracticeLevel = bestPracticeLevel;
        return this;
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public InstanceValidatorParameters setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
        return this;
    }

    @SerializedName(value="htmlInMarkdownCheck")
    @JsonProperty(value="htmlInMarkdownCheck")
    public HtmlInMarkdownCheck getHtmlInMarkdownCheck() {
        return this.htmlInMarkdownCheck;
    }

    @SerializedName(value="htmlInMarkdownCheck")
    @JsonProperty(value="htmlInMarkdownCheck")
    public InstanceValidatorParameters setHtmlInMarkdownCheck(HtmlInMarkdownCheck htmlInMarkdownCheck) {
        this.htmlInMarkdownCheck = htmlInMarkdownCheck;
        return this;
    }

    @SerializedName(value="noUnicodeBiDiControlChars")
    @JsonProperty(value="noUnicodeBiDiControlChars")
    public boolean isNoUnicodeBiDiControlChars() {
        return this.noUnicodeBiDiControlChars;
    }

    @SerializedName(value="noUnicodeBiDiControlChars")
    @JsonProperty(value="noUnicodeBiDiControlChars")
    public InstanceValidatorParameters setNoUnicodeBiDiControlChars(boolean noUnicodeBiDiControlChars) {
        this.noUnicodeBiDiControlChars = noUnicodeBiDiControlChars;
        return this;
    }

    public boolean isCrumbTrails() {
        return this.crumbTrails;
    }

    public InstanceValidatorParameters setCrumbTrails(boolean crumbTrails) {
        this.crumbTrails = crumbTrails;
        return this;
    }

    public boolean isShowMessageIds() {
        return this.showMessageIds;
    }

    public InstanceValidatorParameters setShowMessageIds(boolean showMessageIds) {
        this.showMessageIds = showMessageIds;
        return this;
    }

    public boolean isAllowExampleUrls() {
        return this.allowExampleUrls;
    }

    public InstanceValidatorParameters setAllowExampleUrls(boolean allowExampleUrls) {
        this.allowExampleUrls = allowExampleUrls;
        return this;
    }

    @SerializedName(value="showMessagesFromReferences")
    @JsonProperty(value="showMessagesFromReferences")
    public boolean isShowMessagesFromReferences() {
        return this.showMessagesFromReferences;
    }

    @SerializedName(value="showMessagesFromReferences")
    @JsonProperty(value="showMessagesFromReferences")
    public InstanceValidatorParameters setShowMessagesFromReferences(boolean showMessagesFromReferences) {
        this.showMessagesFromReferences = showMessagesFromReferences;
        return this;
    }

    @SerializedName(value="securityChecks")
    @JsonProperty(value="securityChecks")
    public boolean isSecurityChecks() {
        return this.securityChecks;
    }

    @SerializedName(value="securityChecks")
    @JsonProperty(value="securityChecks")
    public InstanceValidatorParameters setSecurityChecks(boolean securityChecks) {
        this.securityChecks = securityChecks;
        return this;
    }

    @SerializedName(value="noExperimentalContent")
    @JsonProperty(value="noExperimentalContent")
    public boolean isNoExperimentalContent() {
        return this.noExperimentalContent;
    }

    @SerializedName(value="noExperimentalContent")
    @JsonProperty(value="noExperimentalContent")
    public InstanceValidatorParameters setNoExperimentalContent(boolean noExperimentalContent) {
        this.noExperimentalContent = noExperimentalContent;
        return this;
    }

    public boolean isShowTerminologyRouting() {
        return this.showTerminologyRouting;
    }

    public InstanceValidatorParameters setShowTerminologyRouting(boolean showTerminologyRouting) {
        this.showTerminologyRouting = showTerminologyRouting;
        return this;
    }

    @SerializedName(value="matchetypes")
    @JsonProperty(value="matchetypes")
    public List<String> getMatchetypes() {
        return this.matchetypes;
    }

    @SerializedName(value="matchetypes")
    @JsonProperty(value="matchetypes")
    public InstanceValidatorParameters setMatchetypes(List<String> matchetypes) {
        this.matchetypes = matchetypes;
        return this;
    }

    public InstanceValidatorParameters addMatchetype(String matchetype) {
        this.matchetypes.add(matchetype);
        return this;
    }

    @SerializedName(value="expansionParameters")
    @JsonProperty(value="expansionParameters")
    public String getExpansionParameters() {
        return this.expansionParameters;
    }

    @SerializedName(value="expansionParameters")
    @JsonProperty(value="expansionParameters")
    public InstanceValidatorParameters setExpansionParameters(String expansionParameters) {
        this.expansionParameters = expansionParameters;
        return this;
    }

    @SerializedName(value="profiles")
    @JsonProperty(value="profiles")
    public List<String> getProfiles() {
        return this.profiles;
    }

    @SerializedName(value="profiles")
    @JsonProperty(value="profiles")
    public InstanceValidatorParameters setProfiles(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public InstanceValidatorParameters addProfile(String profile) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profile);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceValidatorParameters that = (InstanceValidatorParameters)o;
        return this.assumeValidRestReferences == that.assumeValidRestReferences && this.noExtensibleBindingMessages == that.noExtensibleBindingMessages && this.showTimes == that.showTimes && this.hintAboutNonMustSupport == that.hintAboutNonMustSupport && this.wantInvariantsInMessages == that.wantInvariantsInMessages && this.noInvariants == that.noInvariants && this.displayWarnings == that.displayWarnings && this.unknownCodeSystemsCauseErrors == that.unknownCodeSystemsCauseErrors && this.forPublication == that.forPublication && this.noUnicodeBiDiControlChars == that.noUnicodeBiDiControlChars && this.crumbTrails == that.crumbTrails && this.showMessageIds == that.showMessageIds && this.allowExampleUrls == that.allowExampleUrls && this.showMessagesFromReferences == that.showMessagesFromReferences && this.securityChecks == that.securityChecks && this.noExperimentalContent == that.noExperimentalContent && this.showTerminologyRouting == that.showTerminologyRouting && Objects.equals(this.htmlOutput, that.htmlOutput) && Objects.equals(this.outputStyle, that.outputStyle) && Objects.equals(this.r5BundleRelativeReferencePolicy, that.r5BundleRelativeReferencePolicy) && Objects.equals(this.extensions, that.extensions) && Objects.equals((Object)this.questionnaireMode, (Object)that.questionnaireMode) && Objects.equals((Object)this.level, (Object)that.level) && Objects.equals(this.bestPracticeLevel, that.bestPracticeLevel) && Objects.equals((Object)this.htmlInMarkdownCheck, (Object)that.htmlInMarkdownCheck) && Objects.equals(this.matchetypes, that.matchetypes) && Objects.equals(this.expansionParameters, that.expansionParameters) && Objects.equals(this.profiles, that.profiles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assumeValidRestReferences, this.noExtensibleBindingMessages, this.showTimes, this.hintAboutNonMustSupport, this.htmlOutput, this.outputStyle, this.r5BundleRelativeReferencePolicy, this.extensions, this.wantInvariantsInMessages, this.noInvariants, this.questionnaireMode, this.displayWarnings, this.unknownCodeSystemsCauseErrors, this.level, this.bestPracticeLevel, this.forPublication, this.htmlInMarkdownCheck, this.noUnicodeBiDiControlChars, this.crumbTrails, this.showMessageIds, this.allowExampleUrls, this.showMessagesFromReferences, this.securityChecks, this.noExperimentalContent, this.showTerminologyRouting, this.matchetypes, this.expansionParameters, this.profiles});
    }

    public String toString() {
        return "InstanceValidatorParameters{assumeValidRestReferences=" + this.assumeValidRestReferences + ", noExtensibleBindingMessages=" + this.noExtensibleBindingMessages + ", showTimes=" + this.showTimes + ", hintAboutNonMustSupport=" + this.hintAboutNonMustSupport + ", htmlOutput='" + this.htmlOutput + "', outputStyle='" + this.outputStyle + "', r5BundleRelativeReferencePolicy=" + String.valueOf(this.r5BundleRelativeReferencePolicy) + ", extensions=" + String.valueOf(this.extensions) + ", wantInvariantsInMessages=" + this.wantInvariantsInMessages + ", noInvariants=" + this.noInvariants + ", questionnaireMode=" + String.valueOf((Object)this.questionnaireMode) + ", displayWarnings=" + this.displayWarnings + ", unknownCodeSystemsCauseErrors=" + this.unknownCodeSystemsCauseErrors + ", level=" + String.valueOf((Object)this.level) + ", bestPracticeLevel=" + String.valueOf(this.bestPracticeLevel) + ", forPublication=" + this.forPublication + ", htmlInMarkdownCheck=" + String.valueOf((Object)this.htmlInMarkdownCheck) + ", noUnicodeBiDiControlChars=" + this.noUnicodeBiDiControlChars + ", crumbTrails=" + this.crumbTrails + ", showMessageIds=" + this.showMessageIds + ", allowExampleUrls=" + this.allowExampleUrls + ", showMessagesFromReferences=" + this.showMessagesFromReferences + ", securityChecks=" + this.securityChecks + ", noExperimentalContent=" + this.noExperimentalContent + ", showTerminologyRouting=" + this.showTerminologyRouting + ", matchetypes=" + String.valueOf(this.matchetypes) + ", expansionParameters='" + this.expansionParameters + "', profiles=" + String.valueOf(this.profiles) + "}";
    }
}

