/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.ParseException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.elementmodel.ParserBase;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.test.utils.CompareUtilities;
import org.hl7.fhir.r5.utils.validation.BundleValidationRule;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MimeType;
import org.hl7.fhir.utilities.OIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.ResourcePercentageLogger;
import org.hl7.fhir.validation.instance.utils.CertificateScanner;
import org.hl7.fhir.validation.instance.utils.DigitalSignatureSupport;
import org.hl7.fhir.validation.instance.utils.EntrySummary;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BundleValidator
extends BaseValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BundleValidator.class);
    public static final String URI_REGEX3 = "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AllergyIntolerance|AdverseEvent|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BodySite|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition (aka Problem)|Consent|Contract|Coverage|DataElement|DetectedIssue|Device|DeviceComponent|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EligibilityRequest|EligibilityResponse|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|ExpansionProfile|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingManifest|ImagingStudy|Immunization|ImmunizationRecommendation|ImplementationGuide|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationRequest|MedicationStatement|MessageDefinition|MessageHeader|NamingSystem|NutritionOrder|Observation|OperationDefinition|OperationOutcome|Organization|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|ProcedureRequest|ProcessRequest|ProcessResponse|Provenance|Questionnaire|QuestionnaireResponse|ReferralRequest|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|Sequence|ServiceDefinition|Slot|Specimen|StructureDefinition|StructureMap|Subscription|Substance|SupplyDelivery|SupplyRequest|Task|TestScript|TestReport|ValueSet|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private String serverBase;

    public BundleValidator(BaseValidator parent, String serverBase) {
        super(parent);
        this.serverBase = serverBase;
    }

    public boolean validateBundle(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, NodeStack stack, boolean checkSpecials, ValidationContext hostContext, ResourcePercentageLogger pct, Base.ValidationMode mode) throws FHIRException {
        boolean ok = true;
        String type = bundle.getNamedChildValue("type", false);
        type = StringUtils.defaultString((String)type);
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> entries = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("entry", entries);
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> links = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("link", links);
        if (links.size() > 0) {
            int i = 0;
            for (org.hl7.fhir.r5.elementmodel.Element l : links) {
                ok = this.validateLink(errors, bundle, links, l, stack.push(l, i++, null, null), type, entries) && ok;
            }
        }
        if (entries.size() == 0) {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Bundle_BUNDLE_Entry_NoFirst", new Object[0]) && ok;
        } else {
            org.hl7.fhir.r5.elementmodel.Element firstEntry = (org.hl7.fhir.r5.elementmodel.Element)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 1, null, null);
            String fullUrl = firstEntry.getNamedChildValue("fullUrl", false);
            if (type.equals("document")) {
                resource = firstEntry.getNamedChild("resource", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    id = resource.getNamedChildValue("id", false);
                    boolean bl = ok = this.validateDocument(errors, bundle, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id) && ok;
                }
                if (!VersionUtilities.isThisOrLater((String)Enumerations.FHIRVersion._4_0_1.getDisplay(), (String)bundle.getProperty().getStructure().getFhirVersion().getDisplay(), (VersionUtilities.VersionPrecision)VersionUtilities.VersionPrecision.MINOR)) {
                    ok = this.handleSpecialCaseForLastUpdated(bundle, errors, stack) && ok;
                }
                ok = this.checkAllInterlinked(errors, entries, stack, bundle, false) && ok;
            } else if (type.equals("message")) {
                resource = firstEntry.getNamedChild("resource", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    id = resource.getNamedChildValue("id", false);
                    ok = this.validateMessage(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id) && ok;
                    ok = this.checkAllInterlinked(errors, entries, stack, bundle, true) && ok;
                }
            } else if (type.equals("searchset")) {
                ok = this.checkSearchSet(errors, bundle, entries, stack) && ok;
            }
        }
        int count = 0;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        boolean fullUrlOptional = Utilities.existsInList((String)type, (String[])new String[]{"transaction", "transaction-response", "batch", "batch-response"});
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            NodeStack estack = stack.push(entry, count, null, null);
            String fullUrl = entry.getNamedChildValue("fullUrl", false);
            String url = this.getCanonicalURLForEntry(entry);
            String id = this.getIdForEntry(entry);
            String rtype = this.getTypeForEntry(entry);
            if (!Utilities.noString((String)fullUrl)) {
                if (Utilities.isAbsoluteUrl((String)fullUrl)) {
                    if (rtype != null && fullUrl.matches(this.urlRegex)) {
                        ok = this.rule(errors, "2023-11-13", ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), id != null, "BUNDLE_ENTRY_URL_MATCHES_NO_ID", fullUrl) ? this.rule(errors, "2023-11-13", ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), fullUrl.endsWith("/" + rtype + "/" + id), "BUNDLE_ENTRY_URL_MATCHES_TYPE_ID", fullUrl, rtype, id) && ok : false;
                    }
                } else {
                    ok = false;
                    this.rule(errors, "2023-11-13", ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "BUNDLE_ENTRY_URL_ABSOLUTE", fullUrl);
                }
            }
            if (url != null) {
                if (!(!url.equals(fullUrl) || url.matches(this.urlRegex) && url.endsWith("/" + id) || this.isV3orV2Url(url))) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "Bundle_BUNDLE_Entry_MismatchIdUrl", url, fullUrl, id) && ok;
                }
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), !url.equals(fullUrl) || this.serverBase == null || url.equals(Utilities.pathURL((String[])new String[]{this.serverBase, entry.getNamedChild("resource", false).fhirType(), id})), "Bundle_BUNDLE_Entry_Canonical", url, fullUrl) && ok;
            }
            if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), estack.getLiteralPath(), fullUrlOptional || fullUrl != null, "BUNDLE_BUNDLE_ENTRY_FULLURL_REQUIRED", new Object[0]) && ok;
            }
            if (rtype != null) {
                int rcount = counter.containsKey(rtype) ? (Integer)counter.get(rtype) + 1 : 0;
                counter.put(rtype, rcount);
                org.hl7.fhir.r5.elementmodel.Element res = entry.getNamedChild("resource", false);
                NodeStack rstack = estack.push(res, -1, null, null);
                for (BundleValidationRule bvr : this.validator().getBundleValidationRules()) {
                    if (!this.meetsRule(bvr, rtype, rcount, count)) continue;
                    StructureDefinition defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, bvr.getProfile());
                    if (defn == null) {
                        throw new Error(this.context.formatMessage("BUNDLE_RULE_PROFILE_UNKNOWN", new Object[]{bvr.getRule(), bvr.getProfile()}));
                    }
                    if (this.validator().isCrumbTrails()) {
                        res.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, res.line(), res.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST_BUNDLE_PARAM", defn.getUrl()));
                    }
                    stack.resetIds();
                    ok = this.validator().startInner(hostContext, errors, res, res, defn, rstack, false, pct, mode, false) && ok;
                }
                ((InstanceValidator)this.parent).checkSpecials(hostContext, errors, res, rstack, true, pct, mode, true, ok);
            }
            ++count;
        }
        if (bundle.hasChild("signature")) {
            ok = this.validateSignature(errors, bundle, stack) && ok;
        }
        return ok;
    }

    private boolean validateLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack, String type, List<org.hl7.fhir.r5.elementmodel.Element> entries) {
        switch (type) {
            case "document": {
                return this.validateDocumentLink(errors, bundle, links, link, stack, entries);
            }
            case "message": {
                return this.validateMessageLink(errors, bundle, links, link, stack, entries);
            }
            case "history": 
            case "searchset": {
                return this.validateSearchLink(errors, bundle, links, link, stack);
            }
            case "collection": {
                return this.validateCollectionLink(errors, bundle, links, link, stack);
            }
            case "subscription-notification": {
                return this.validateSubscriptionLink(errors, bundle, links, link, stack);
            }
            case "transaction": 
            case "transaction-response": 
            case "batch": 
            case "batch-response": {
                return this.validateTransactionOrBatchLink(errors, bundle, links, link, stack);
            }
        }
        return true;
    }

    private boolean validateDocumentLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack, List<org.hl7.fhir.r5.elementmodel.Element> entries) {
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            org.hl7.fhir.r5.elementmodel.Element urlE;
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                boolean bl = ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
            if ("stylesheet".equals(rel) && (urlE = link.getNamedChild("url", false)) != null) {
                NodeStack urlStack = stack.push(urlE, -1, null, null);
                String url = urlE.getValue();
                if (url != null) {
                    if (Utilities.isAbsoluteUrl((String)url)) {
                        if (!url.equals("https://hl7.org/fhir/fhir.css")) {
                            this.warning(errors, "2022-12-09", ValidationMessage.IssueType.BUSINESSRULE, urlE.line(), urlE.col(), urlStack.getLiteralPath(), false, "BUNDLE_LINK_STYELSHEET_EXTERNAL", new Object[0]);
                            if (url.startsWith("http://")) {
                                this.warning(errors, "2022-12-09", ValidationMessage.IssueType.BUSINESSRULE, urlE.line(), urlE.col(), urlStack.getLiteralPath(), false, "BUNDLE_LINK_STYELSHEET_INSECURE", new Object[0]);
                            }
                            if (!Utilities.isAbsoluteUrlLinkable((String)url)) {
                                this.warning(errors, "2022-12-09", ValidationMessage.IssueType.BUSINESSRULE, urlE.line(), urlE.col(), urlStack.getLiteralPath(), false, "BUNDLE_LINK_STYELSHEET_LINKABLE", new Object[0]);
                            }
                        }
                    } else {
                        boolean found = false;
                        for (org.hl7.fhir.r5.elementmodel.Element e : entries) {
                            org.hl7.fhir.r5.elementmodel.Element res = e.getNamedChild("resource", false);
                            if (res == null || !(res.fhirType() + "/" + res.getIdBase()).equals(url)) continue;
                            found = true;
                            break;
                        }
                        ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.NOTFOUND, urlE.line(), urlE.col(), urlStack.getLiteralPath(), found, "BUNDLE_LINK_STYELSHEET_NOT_FOUND", new Object[0]) && ok;
                    }
                }
            }
        }
        return ok;
    }

    private boolean validateMessageLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack, List<org.hl7.fhir.r5.elementmodel.Element> entries) {
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean validateSearchLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack) {
        String rel = StringUtils.defaultString((String)link.getNamedChildValue("relation", false));
        if (Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last", "self"})) {
            return this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, link.line(), link.col(), stack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel);
        }
        return true;
    }

    private boolean relationshipUnique(String rel, org.hl7.fhir.r5.elementmodel.Element link, List<org.hl7.fhir.r5.elementmodel.Element> links) {
        for (org.hl7.fhir.r5.elementmodel.Element l : links) {
            if (l != link && rel.equals(l.getNamedChildValue("relation", false))) {
                return false;
            }
            if (l != link) continue;
            return true;
        }
        return true;
    }

    private boolean validateCollectionLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack) {
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean validateSubscriptionLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack) {
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean validateTransactionOrBatchLink(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> links, org.hl7.fhir.r5.elementmodel.Element link, NodeStack stack) {
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean checkSearchSet(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack) {
        boolean ok = true;
        ArrayList<org.hl7.fhir.r5.elementmodel.Element> links = new ArrayList<org.hl7.fhir.r5.elementmodel.Element>();
        bundle.getNamedChildren("link", links);
        org.hl7.fhir.r5.elementmodel.Element selfLink = this.getSelfLink(links);
        ArrayList<String> types = new ArrayList<String>();
        if (selfLink == null) {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), false, "BUNDLE_SEARCH_NOSELF", new Object[0]);
        } else {
            this.readSearchResourceTypes(selfLink.getNamedChildValue("url", false), types);
            if (types.size() == 0) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), false, "BUNDLE_SEARCH_SELF_NOT_UNDERSTOOD");
            }
        }
        Boolean searchMode = this.readHasSearchMode(entries);
        if (searchMode != null && !searchMode.booleanValue()) {
            boolean typeProblem = false;
            String rtype = null;
            int count = 0;
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                NodeStack estack = stack.push(entry, count, null, null);
                ++count;
                org.hl7.fhir.r5.elementmodel.Element res = entry.getNamedChild("resource", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), res != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE", new Object[0])) {
                    String id;
                    NodeStack rstack = estack.push(res, -1, null, null);
                    String rt = res.fhirType();
                    Boolean bok = this.checkSearchType(types, rt);
                    if (bok == null) {
                        typeProblem = true;
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), selfLink == null, "BUNDLE_SEARCH_ENTRY_TYPE_NOT_SURE");
                        id = res.getNamedChildValue("id", false);
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null || "OperationOutcome".equals(rt), "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]);
                        continue;
                    }
                    if (bok.booleanValue()) {
                        if ("OperationOutcome".equals(rt)) continue;
                        id = res.getNamedChildValue("id", false);
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]);
                        if (rtype != null && !rt.equals(rtype)) {
                            typeProblem = true;
                            continue;
                        }
                        if (rtype != null) continue;
                        rtype = rt;
                        continue;
                    }
                    typeProblem = true;
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), false, "BUNDLE_SEARCH_ENTRY_WRONG_RESOURCE_TYPE_NO_MODE", rt, types);
                    continue;
                }
                ok = false;
            }
            if (typeProblem) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), !typeProblem, "BUNDLE_SEARCH_NO_MODE", new Object[0]);
            } else {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), !typeProblem, "BUNDLE_SEARCH_NO_MODE");
            }
        } else {
            int count = 0;
            for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
                NodeStack estack = stack.push(entry, count, null, null);
                ++count;
                org.hl7.fhir.r5.elementmodel.Element res = entry.getNamedChild("resource", false);
                String sm = null;
                org.hl7.fhir.r5.elementmodel.Element s = entry.getNamedChild("search", false);
                if (s != null) {
                    sm = s.getNamedChildValue("mode", false);
                }
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), sm != null, "BUNDLE_SEARCH_NO_MODE", new Object[0]);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), res != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE", new Object[0])) {
                    NodeStack rstack = estack.push(res, -1, null, null);
                    String rt = res.fhirType();
                    String id = res.getNamedChildValue("id", false);
                    if (sm == null) continue;
                    if ("match".equals(sm)) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]) && ok;
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), types.size() == 0 || this.checkSearchType(types, rt) != false, "BUNDLE_SEARCH_ENTRY_WRONG_RESOURCE_TYPE_MODE", rt, types) && ok;
                        continue;
                    }
                    if ("include".equals(sm)) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]) && ok;
                        continue;
                    }
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), "OperationOutcome".equals(rt), "BUNDLE_SEARCH_ENTRY_WRONG_RESOURCE_TYPE_OUTCOME", rt) && ok;
                    continue;
                }
                ok = false;
            }
        }
        return ok;
    }

    private Boolean checkSearchType(List<String> types, String rt) {
        if (types.size() == 0) {
            return null;
        }
        return Utilities.existsInList((String)rt, types);
    }

    private Boolean readHasSearchMode(List<org.hl7.fhir.r5.elementmodel.Element> entries) {
        boolean all = true;
        boolean any = false;
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            String sm = null;
            org.hl7.fhir.r5.elementmodel.Element s = entry.getNamedChild("search", false);
            if (s != null) {
                sm = s.getNamedChildValue("mode", false);
            }
            if (sm != null) {
                any = true;
                continue;
            }
            all = false;
        }
        if (all) {
            return true;
        }
        if (any) {
            return null;
        }
        return false;
    }

    private void readSearchResourceTypes(String ref, List<String> types) {
        if (ref == null) {
            return;
        }
        String[] head = null;
        String[] tail = null;
        if (ref.contains("?")) {
            head = ref.substring(0, ref.indexOf("?")).split("\\/");
            tail = ref.substring(ref.indexOf("?") + 1).split("\\&");
        } else {
            head = ref.split("\\/");
        }
        if (head == null || head.length == 0) {
            return;
        }
        if (this.context.getResourceNames().contains(head[head.length - 1])) {
            types.add(head[head.length - 1]);
        } else if (tail != null) {
            for (String s : tail) {
                if (!s.startsWith("_type=")) continue;
                for (String t : s.substring(6).split("\\,")) {
                    types.add(t);
                }
            }
        }
    }

    private org.hl7.fhir.r5.elementmodel.Element getSelfLink(List<org.hl7.fhir.r5.elementmodel.Element> links) {
        for (org.hl7.fhir.r5.elementmodel.Element link : links) {
            if (!"self".equals(link.getNamedChildValue("relation", false))) continue;
            return link;
        }
        return null;
    }

    private boolean validateDocument(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id) {
        boolean ok = true;
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getType().equals("Composition"), "Bundle_BUNDLE_Entry_Document", new Object[0])) {
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, false, "subject", "Composition") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, true, "author", "Composition") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, false, "encounter", "Composition") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, false, "custodian", "Composition") && ok;
            ok = this.validateDocumentSubReference(errors, bundle, entries, composition, stack, fullUrl, id, "Composition", "attester", false, "party") && ok;
            ok = this.validateDocumentSubReference(errors, bundle, entries, composition, stack, fullUrl, id, "Composition", "event", true, "detail") && ok;
            ok = this.validateSections(errors, bundle, entries, composition, stack, fullUrl, id) && ok;
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean validateSections(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element focus, NodeStack stack, String fullUrl, String id) {
        boolean ok = true;
        ArrayList sections = new ArrayList();
        focus.getNamedChildren("section", sections);
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element section : sections) {
            NodeStack localStack = stack.push(section, i, null, null);
            ok = this.validateDocumentReference(errors, bundle, entries, section, stack, fullUrl, id, true, "author", "Section") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, section, stack, fullUrl, id, false, "focus", "Section") && ok;
            ArrayList sectionEntries = new ArrayList();
            section.getNamedChildren("entry", sectionEntries);
            int j = 1;
            for (org.hl7.fhir.r5.elementmodel.Element sectionEntry : sectionEntries) {
                NodeStack localStack2;
                ok = this.validateBundleReference(errors, bundle, entries, sectionEntry, "Section Entry", localStack2 = localStack.push(sectionEntry, j, null, null), fullUrl, "Composition", id) && ok;
                ++j;
            }
            ok = this.validateSections(errors, bundle, entries, section, localStack, fullUrl, id) && ok;
            ++i;
        }
        return ok;
    }

    public boolean validateDocumentSubReference(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id, String title, String parent, boolean repeats, String propName) {
        boolean ok = true;
        ArrayList list = new ArrayList();
        composition.getNamedChildren(parent, list);
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element elem : list) {
            ok = this.validateDocumentReference(errors, bundle, entries, elem, stack.push(elem, i, null, null), fullUrl, id, repeats, propName, title + "." + parent) && ok;
            ++i;
        }
        return ok;
    }

    public boolean validateDocumentReference(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element composition, NodeStack stack, String fullUrl, String id, boolean repeats, String propName, String title) {
        boolean ok = true;
        ArrayList list = new ArrayList();
        composition.getNamedChildren(propName, list);
        if (repeats) {
            int i = 1;
            for (org.hl7.fhir.r5.elementmodel.Element elem : list) {
                ok = this.validateBundleReference(errors, bundle, entries, elem, title + "." + propName, stack.push(elem, i, null, null), fullUrl, "Composition", id) && ok;
                ++i;
            }
        } else if (list.size() > 0) {
            org.hl7.fhir.r5.elementmodel.Element elem = (org.hl7.fhir.r5.elementmodel.Element)list.get(0);
            ok = this.validateBundleReference(errors, bundle, entries, elem, title + "." + propName, stack.push(elem, -1, null, null), fullUrl, "Composition", id) && ok;
        }
        return ok;
    }

    private boolean validateMessage(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element messageHeader, NodeStack stack, String fullUrl, String id) {
        boolean ok = true;
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, messageHeader.line(), messageHeader.col(), stack.getLiteralPath(), messageHeader.getType().equals("MessageHeader"), "Validation_BUNDLE_Message", new Object[0])) {
            List elements = messageHeader.getChildren("focus");
            for (org.hl7.fhir.r5.elementmodel.Element elem : elements) {
                ok = this.validateBundleReference(errors, messageHeader, entries, elem, "MessageHeader Data", stack.push(elem, -1, null, null), fullUrl, "MessageHeader", id) && ok;
            }
        }
        return ok;
    }

    private boolean validateBundleReference(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, List<org.hl7.fhir.r5.elementmodel.Element> entries, org.hl7.fhir.r5.elementmodel.Element ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        org.hl7.fhir.r5.elementmodel.Element target;
        String reference = null;
        try {
            reference = ref.getNamedChildValue("reference", false);
        }
        catch (Error error) {
            // empty catch block
        }
        return ref == null || Utilities.noString((String)reference) || reference.startsWith("#") || (target = this.resolveInBundle(bundle, entries, reference, fullUrl, type, id, stack, errors, name, ref, false, false)) != null;
    }

    private boolean handleSpecialCaseForLastUpdated(org.hl7.fhir.r5.elementmodel.Element bundle, List<ValidationMessage> errors, NodeStack stack) {
        boolean ok = bundle.hasChild("meta", false) && bundle.getNamedChild("meta", false).hasChild("lastUpdated", false) && bundle.getNamedChild("meta", false).getNamedChild("lastUpdated", false).hasValue();
        this.ruleHtml(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack.getLiteralPath(), ok, "Bundle_Document_Date_Missing", "Bundle_Document_Date_Missing_html");
        return ok;
    }

    private boolean checkAllInterlinked(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element bundle, boolean isMessage) {
        boolean foundRevLinks;
        boolean ok = true;
        ArrayList<EntrySummary> entryList = new ArrayList<EntrySummary>();
        int i = 0;
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            org.hl7.fhir.r5.elementmodel.Element r = entry.getNamedChild("resource", false);
            if (r != null) {
                EntrySummary entrySummary = new EntrySummary(i, entry, r);
                entryList.add(entrySummary);
            }
            ++i;
        }
        for (EntrySummary e : entryList) {
            List<StringWithSource> references = this.findReferences(e.getEntry());
            for (StringWithSource ref : references) {
                EntrySummary t;
                org.hl7.fhir.r5.elementmodel.Element tgt;
                String string = ref.getReference();
                String string2 = e.getEntry().getChildValue("fullUrl");
                String string3 = e.getResource().fhirType();
                String string4 = e.getResource().getIdBase();
                String string5 = ref.getSource().getPath();
                org.hl7.fhir.r5.elementmodel.Element element = ref.getSource();
                if (!ref.isWarning()) {
                    // empty if block
                }
                if ((tgt = this.resolveInBundle(bundle, entries, string, string2, string3, string4, stack, errors, string5, element, true, ref.isNlLink())) == null || (t = this.entryForTarget(entryList, tgt)) == null || t == e) continue;
                e.getTargets().add(t);
            }
        }
        HashSet<EntrySummary> visited = new HashSet<EntrySummary>();
        if (entryList.size() > 0) {
            this.visitLinked(visited, (EntrySummary)entryList.get(0));
        }
        this.visitBundleLinks(visited, entryList, bundle);
        do {
            foundRevLinks = false;
            for (EntrySummary entrySummary : entryList) {
                if (visited.contains(entrySummary)) continue;
                boolean add = false;
                for (EntrySummary t : entrySummary.getTargets()) {
                    if (!visited.contains(t)) continue;
                    add = true;
                }
                if (!add) continue;
                if (isMessage) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entrySummary.getEntry().line(), entrySummary.getEntry().col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), this.isExpectedToBeReverse(entrySummary.getResource().fhirType()), "BUNDLE_BUNDLE_ENTRY_REVERSE_MSG", entrySummary.getEntry().getChildValue("fullUrl") != null ? "'" + entrySummary.getEntry().getChildValue("fullUrl") + "'" : "");
                } else if (VersionUtilities.isR5Plus((String)this.context.getVersion())) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entrySummary.getEntry().line(), entrySummary.getEntry().col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), this.isExpectedToBeReverse(entrySummary.getResource().fhirType()), "BUNDLE_BUNDLE_ENTRY_REVERSE_R5", entrySummary.getEntry().getChildValue("fullUrl") != null ? "'" + entrySummary.getEntry().getChildValue("fullUrl") + "'" : "");
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entrySummary.getEntry().line(), entrySummary.getEntry().col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), this.isExpectedToBeReverse(entrySummary.getResource().fhirType()), "BUNDLE_BUNDLE_ENTRY_REVERSE_R4", entrySummary.getEntry().getChildValue("fullUrl") != null ? "'" + entrySummary.getEntry().getChildValue("fullUrl") + "'" : "");
                }
                foundRevLinks = true;
                this.visitLinked(visited, entrySummary);
            }
        } while (foundRevLinks);
        i = 0;
        for (EntrySummary entrySummary : entryList) {
            org.hl7.fhir.r5.elementmodel.Element entry = entrySummary.getEntry();
            if (isMessage) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), visited.contains(entrySummary), "Bundle_BUNDLE_Entry_Orphan_MESSAGE", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "");
            } else {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), visited.contains(entrySummary), "Bundle_BUNDLE_Entry_Orphan_DOCUMENT", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "") && ok;
            }
            ++i;
        }
        return ok;
    }

    private void visitBundleLinks(Set<EntrySummary> visited, List<EntrySummary> entryList, org.hl7.fhir.r5.elementmodel.Element bundle) {
        List links = bundle.getChildrenByName("link");
        block0: for (org.hl7.fhir.r5.elementmodel.Element link : links) {
            String rel = link.getNamedChildValue("relation", false);
            String url = link.getNamedChildValue("url", false);
            if (rel == null || url == null || !Utilities.existsInList((String)rel, (String[])new String[]{"stylesheet"})) continue;
            for (EntrySummary e : entryList) {
                if (e.getResource() == null || !url.equals(e.getResource().fhirType() + "/" + e.getResource().getIdBase())) continue;
                visited.add(e);
                continue block0;
            }
        }
    }

    private boolean isExpectedToBeReverse(String fhirType) {
        return Utilities.existsInList((String)fhirType, (String[])new String[]{"Provenance"});
    }

    private String getCanonicalURLForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource", false);
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("url", false);
    }

    private String getIdForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource", false);
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("id", false);
    }

    private String getTypeForEntry(org.hl7.fhir.r5.elementmodel.Element entry) {
        org.hl7.fhir.r5.elementmodel.Element e = entry.getNamedChild("resource", false);
        if (e == null) {
            return null;
        }
        return e.fhirType();
    }

    private void validateResourceIds(List<ValidationMessage> errors, List<org.hl7.fhir.r5.elementmodel.Element> entries, NodeStack stack) {
        int i = 1;
        for (org.hl7.fhir.r5.elementmodel.Element entry : entries) {
            String id;
            String fullUrl = entry.getNamedChildValue("fullUrl", false);
            org.hl7.fhir.r5.elementmodel.Element resource = entry.getNamedChild("resource", false);
            String string = id = resource != null ? resource.getNamedChildValue("id", false) : null;
            if (id != null && fullUrl != null) {
                String urlId = null;
                if (fullUrl.startsWith("https://") || fullUrl.startsWith("http://")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(47) + 1);
                } else if (fullUrl.startsWith("urn:uuid") || fullUrl.startsWith("urn:oid")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(58) + 1);
                }
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + i + "]"), urlId.equals(id), "Bundle_BUNDLE_Entry_IdUrlMismatch", id, fullUrl);
            }
            ++i;
        }
    }

    private EntrySummary entryForTarget(List<EntrySummary> entryList, org.hl7.fhir.r5.elementmodel.Element tgt) {
        for (EntrySummary e : entryList) {
            if (e.getEntry() != tgt) continue;
            return e;
        }
        return null;
    }

    private void visitLinked(Set<EntrySummary> visited, EntrySummary t) {
        if (!visited.contains(t)) {
            visited.add(t);
            for (EntrySummary e : t.getTargets()) {
                this.visitLinked(visited, e);
            }
        }
    }

    private List<StringWithSource> findReferences(org.hl7.fhir.r5.elementmodel.Element start) {
        ArrayList<StringWithSource> references = new ArrayList<StringWithSource>();
        this.findReferences(start, references);
        return references;
    }

    private void findReferences(org.hl7.fhir.r5.elementmodel.Element start, List<StringWithSource> references) {
        for (org.hl7.fhir.r5.elementmodel.Element child : start.getChildren()) {
            String ref;
            if (child.getType().equals("Reference") && (ref = child.getChildValue("reference")) != null && !ref.startsWith("#") && !this.hasReference(ref, references)) {
                references.add(new StringWithSource(ref, child, false, false));
            }
            if (!(!Utilities.existsInList((String)child.getType(), (String[])new String[]{"url", "uri"}) || Utilities.existsInList((String)child.getName(), (String[])new String[]{"system"}) || Utilities.existsInList((String)child.getProperty().getDefinition().getPath(), (String[])new String[]{"Bundle.entry.fullUrl", "Coding.system", "Identifier.system", "Meta.profile", "Extension.url", "Quantity.system", "MessageHeader.source.endpoint", "MessageHeader.destination.endpoint", "Endpoint.address"}) || (ref = child.primitiveValue()) == null || ref.startsWith("#") || this.hasReference(ref, references))) {
                references.add(new StringWithSource(ref, child, true, this.isNLLink(start)));
            }
            if ("Bundle".equals(child.fhirType())) continue;
            this.findReferences(child, references);
        }
    }

    private boolean isNLLink(org.hl7.fhir.r5.elementmodel.Element parent) {
        return parent != null && "extension".equals(parent.getName()) && "http://hl7.org/fhir/StructureDefinition/narrativeLink".equals(parent.getNamedChildValue("url", false));
    }

    private boolean hasReference(String ref, List<StringWithSource> references) {
        for (StringWithSource t : references) {
            if (!ref.equals(t.getReference())) continue;
            return true;
        }
        return false;
    }

    private boolean isV3orV2Url(String url) {
        return url.startsWith("http://hl7.org/fhir/v3/") || url.startsWith("http://hl7.org/fhir/v2/");
    }

    public boolean meetsRule(BundleValidationRule bvr, String rtype, int rcount, int count) {
        String index;
        String t;
        if (bvr.getRule() == null) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_NONE", new Object[0]));
        }
        String rule = bvr.getRule();
        String string = rule.contains(":") ? rule.substring(0, rule.indexOf(":")) : (t = Utilities.isInteger((String)rule) ? null : rule);
        String string2 = rule.contains(":") ? rule.substring(rule.indexOf(":") + 1) : (index = Utilities.isInteger((String)rule) ? rule : null);
        if (Utilities.noString((String)t) && Utilities.noString((String)index)) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_NONE", new Object[0]));
        }
        if (!Utilities.noString((String)t) && !this.context.getResourceNames().contains(t)) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_UNKNOWN", new Object[]{t}));
        }
        if (!Utilities.noString((String)index) && !Utilities.isInteger((String)index)) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_INVALID_INDEX", new Object[]{index}));
        }
        if (t == null) {
            return Integer.toString(count).equals(index);
        }
        if (index == null) {
            return t.equals(rtype);
        }
        return t.equals(rtype) && Integer.toString(rcount).equals(index);
    }

    private JsonObject parseJsonOrError(List<ValidationMessage> errors, NodeStack stack, byte[] source, String msgId) {
        JsonObject object = null;
        try {
            object = JsonParser.parseObject((byte[])source);
        }
        catch (Exception e) {
            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, msgId, e.getMessage());
        }
        return object;
    }

    private Document parseXmlOrError(List<ValidationMessage> errors, NodeStack stack, byte[] source, String msgId) {
        Document dom = null;
        try {
            dom = XMLUtil.parseToDom((byte[])source);
        }
        catch (Exception e) {
            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, msgId, e.getMessage());
        }
        return dom;
    }

    private boolean validateSignature(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, NodeStack stack) throws FHIRException {
        Object d;
        Object data;
        boolean ok = true;
        org.hl7.fhir.r5.elementmodel.Element signature = bundle.getNamedChild("signature");
        String sigFormat = signature.getNamedChildValue(new String[]{"sigFormat"});
        if (Utilities.noString((String)sigFormat)) {
            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, !signature.hasChild("data"), "BUNDLE_SIGNATURE_NO_SIG_FORMAT", new Object[0]);
            if (signature.hasChild("data")) {
                try {
                    JsonObject j;
                    data = org.apache.commons.codec.binary.Base64.decodeBase64((String)signature.getNamedChildValue(new String[]{"data"}));
                    d = new String((byte[])data);
                    if (Utilities.charCount((String)d, (char)'.') == 2) {
                        data = org.apache.commons.codec.binary.Base64.decodeBase64((String)((String)d).split("\\.")[0]);
                        d = new String((byte[])data);
                    }
                    if ((j = JsonParser.parseObject((String)d)).has("alg")) {
                        sigFormat = "application/jose";
                    }
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, !signature.hasChild("data"), "BUNDLE_SIGNATURE_SIG_FORMAT_JOSE", new Object[0]);
                }
                catch (Exception data2) {
                    // empty catch block
                }
            }
        }
        if (sigFormat != null && !sigFormat.startsWith("image/") && !Utilities.startsWithInList((String)sigFormat, (String[])new String[]{"application/pdf"})) {
            if ("application/pkcs7-signature".equals(sigFormat)) {
                data = signature.getNamedChildValue(new String[]{"data"});
                if (data == null) {
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_NOT_CHECKED_DATA", sigFormat);
                } else {
                    d = null;
                    if (!org.hl7.fhir.utilities.Base64.isBase64((String)data)) {
                        this.warning(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_NOT_CHECKED_DATA_B64", new Object[0]);
                    } else {
                        d = new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)data));
                    }
                    if (d != null) {
                        this.hint(errors, null, ValidationMessage.IssueType.INFORMATIONAL, stack, false, "Signature Verification is a work in progress. Feedback welcome at https://chat.fhir.org/#narrow/channel/179247-Security-and-Privacy/topic/Signature/with/524324965", new Object[0]);
                        ok = this.validateSignatureDigSig(errors, bundle, stack, signature, (String)d) && ok;
                    }
                }
            } else if ("application/jose".equals(sigFormat)) {
                data = signature.getNamedChildValue(new String[]{"data"});
                if (data == null) {
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_NOT_CHECKED_DATA", sigFormat);
                } else {
                    d = null;
                    if (!org.hl7.fhir.utilities.Base64.isBase64((String)data)) {
                        if (((String)data).split("\\.").length == 3) {
                            d = data;
                            ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_CHECKED_DATA_B64", new Object[0]) && ok;
                        } else {
                            ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_NOT_CHECKED_DATA_B64", new Object[0]) && ok;
                        }
                    } else {
                        d = new String(org.apache.commons.codec.binary.Base64.decodeBase64((String)data));
                    }
                    if (d != null) {
                        this.hint(errors, null, ValidationMessage.IssueType.INFORMATIONAL, stack, false, "Signature Verification is a work in progress. Feedback welcome at https://chat.fhir.org/#narrow/channel/179247-Security-and-Privacy/topic/Signature/with/524324965", new Object[0]);
                        ok = this.validateSignatureJose(errors, bundle, stack, signature, (String)d) && ok;
                    }
                }
            } else {
                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, false, "BUNDLE_SIGNATURE_NOT_CHECKED_KIND", sigFormat);
            }
        }
        return false;
    }

    private boolean validateSignatureJose(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element signature, String d) {
        boolean ok = true;
        String[] parts = d.split("\\.");
        JsonObject header = this.parseJsonOrError(errors, stack, org.apache.commons.codec.binary.Base64.decodeBase64((String)parts[0]), "BUNDLE_SIGNATURE_HEADER_PARSE");
        Object canon = null;
        String kid = null;
        boolean xml = false;
        if (header == null) {
            ok = false;
        } else {
            JWK jwk;
            X509Certificate cert;
            boolean purposeOk;
            String purposeDesc;
            Object purpose;
            String sigT;
            block68: {
                org.hl7.fhir.r5.elementmodel.Element when = signature.getNamedChild("when");
                sigT = header.asString("sigT");
                if (sigT != null && Utilities.isInteger((String)sigT)) {
                    this.warning(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_HEADER_SIG_TIME_WRONG_FORMAT", sigT);
                    sigT = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochSecond(Long.valueOf(sigT)));
                }
                if (sigT == null && header.has("iat")) {
                    sigT = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochSecond(Long.valueOf(header.asString("iat"))));
                }
                if (sigT == null) {
                    this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_NO_SIG_TIME", new Object[0]);
                }
                if (when == null) {
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_WHEN_MISMATCH", new Object[0]);
                } else if (sigT != null) {
                    ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.BUSINESSRULE, stack, sigT.equals(when.primitiveValue()), "BUNDLE_SIGNATURE_HEADER_WHEN_MISMATCH", sigT, when.primitiveValue()) && ok;
                }
                org.hl7.fhir.r5.elementmodel.Element tgtFmt = signature.getNamedChild("targetFormat");
                String tcanon = null;
                canon = header.asString("canon");
                if (tgtFmt != null) {
                    try {
                        MimeType mt = new MimeType(tgtFmt.primitiveValue());
                        xml = mt.getBase().contains("xml");
                        tcanon = (String)mt.getParams().get("canonicalization");
                    }
                    catch (Exception e) {
                        ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_CANON_ERROR", tgtFmt.primitiveValue(), e.getMessage()) && ok;
                    }
                }
                String defCanon = "http://hl7.org/fhir/canonicalization/" + (xml ? "xml" : "json");
                if (canon == null) {
                    if (tcanon == null) {
                        canon = defCanon + ("document".equals(bundle.getNamedChildValue(new String[]{"type"})) ? "#document" : "");
                        this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_CANON_DEFAULT", canon);
                    } else {
                        canon = tcanon;
                    }
                } else {
                    if (tcanon != null) {
                        this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, ((String)canon).equals(tcanon), "BUNDLE_SIGNATURE_CANON_DIFF", canon, tcanon);
                    }
                    xml = ((String)canon).contains("xml");
                }
                purpose = this.getPurpose(header);
                purposeDesc = this.getPurposeDesc(header);
                purposeOk = false;
                List types = signature.getChildren("type");
                for (org.hl7.fhir.r5.elementmodel.Element type : types) {
                    ValidationResult vr;
                    String p = null;
                    String system = type.getNamedChildValue(new String[]{"system"});
                    String code = type.getNamedChildValue(new String[]{"code"});
                    p = OIDUtilities.isValidOID((String)code) ? "urn:oid:" + code : system + "#" + code;
                    if (purpose == null) {
                        purpose = p;
                        vr = this.context.validateCode((ValidationOptions)this.settings, system, null, code, null);
                        if (!vr.isOk()) break;
                        purposeDesc = vr.getDisplay();
                        break;
                    }
                    if (!((String)purpose).equals(p)) continue;
                    purposeOk = true;
                    if (purposeDesc != null || !(vr = this.context.validateCode((ValidationOptions)this.settings, system, null, code, null)).isOk()) break;
                    purposeDesc = vr.getDisplay();
                    break;
                }
                cert = null;
                jwk = null;
                if (header.has("x5c")) {
                    try {
                        String c = header.getJsonArray("x5c").get(0).asString();
                        byte[] b = org.apache.commons.codec.binary.Base64.decodeBase64((String)c);
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(b));
                        jwk = this.parseX509c(cert);
                    }
                    catch (Exception e) {
                        ok = false;
                        this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_HEADER_X509_ERROR", e.getMessage());
                    }
                } else if (header.has("kid")) {
                    kid = header.asString("kid");
                    try {
                        CertificateScanner scanner = new CertificateScanner();
                        CertificateScanner.CertificateResult find = scanner.findCertificateByKid(this.settings.getCertificates(), this.settings.getCertificateFolders(), kid);
                        if (find == null) {
                            this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_CERT_NOT_FOUND", kid);
                        } else {
                            jwk = find.getJwk();
                            cert = find.getCertificate();
                        }
                        if (jwk != null) break block68;
                        if (cert != null) {
                            jwk = this.parseX509c(cert);
                            break block68;
                        }
                        this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_CERT_NOT_FOUND", kid);
                    }
                    catch (Exception e) {
                        this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_CERT_NOT_FOUND_ERROR", kid, e.getMessage());
                    }
                } else {
                    this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_NO_KID_OR_CERT", new Object[0]);
                }
            }
            org.hl7.fhir.r5.elementmodel.Element who = signature.getNamedChild("who");
            boolean whoMatches = false;
            if (cert != null && cert.getSubjectX500Principal() != null && cert.getSubjectX500Principal().getName() != null) {
                org.hl7.fhir.r5.elementmodel.Element id = who == null ? null : who.getNamedChild("identifier");
                String idv = id == null ? null : id.getNamedChildValue(new String[]{"value"});
                Set<String> cnlist = DigitalSignatureSupport.getNamesFromCertificate(cert, this.settings.isDebug());
                if (idv != null) {
                    whoMatches = cnlist.contains(idv);
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, whoMatches, "BUNDLE_SIGNATURE_WHO_MISMATCH", idv, CommaSeparatedStringBuilder.joinWrapped((String)",", (String)"'", (String)"'", cnlist));
                } else {
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_WHO_RECOMMENDED", cert.getSubjectX500Principal().getName());
                }
            } else if (who == null) {
                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_WHO_NO_INFO", new Object[0]);
            } else {
                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_WHO_NOT_IN_CERT", new Object[0]);
            }
            if (!Utilities.noString((String)parts[1])) {
                this.warning(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_PRESENT", new Object[0]);
            }
            if (jwk != null && canon != null) {
                byte[] toSign;
                block69: {
                    toSign = null;
                    try {
                        toSign = this.makeSignableBundle(bundle, (String)canon, xml);
                    }
                    catch (Exception e) {
                        if (!this.settings.isDebug()) break block69;
                        e.printStackTrace();
                    }
                }
                try {
                    org.apache.commons.net.util.Base64.decodeBase64((String)parts[2]);
                }
                catch (Exception e) {
                    ok = false;
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_SIG_INVALID", e.getMessage());
                }
                try {
                    boolean verified;
                    block70: {
                        String reconstituted = parts[0] + "." + String.valueOf(Base64URL.encode((byte[])toSign)) + "." + parts[2];
                        verified = this.verifyJWT(reconstituted, jwk);
                        if (!verified) {
                            ok = false;
                            if (kid != null) {
                                this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_SIG_FAIL_KID", kid);
                            } else if (jwk.getKeyID() != null) {
                                this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_SIG_FAIL_CERT_ID", jwk.getKeyID());
                            } else {
                                this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_SIG_FAIL_CERT", new Object[0]);
                            }
                            if (!Utilities.noString((String)parts[1])) {
                                byte[] signed = null;
                                try {
                                    signed = org.apache.commons.net.util.Base64.decodeBase64((String)parts[1]);
                                }
                                catch (Exception e) {
                                    ok = false;
                                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_INVALID", e.getMessage());
                                }
                                if (signed != null) {
                                    if (!Arrays.equals(toSign, signed)) {
                                        this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_MISMATCH", toSign.length, signed.length);
                                        try {
                                            JsonObject signedJ = this.parseJsonOrError(errors, stack, signed, "BUNDLE_SIGNATURE_PAYLOAD_INVALID_JSON");
                                            JsonObject toSignJ = this.parseJsonOrError(errors, stack, toSign, "BUNDLE_SIGNATURE_PAYLOAD_INVALID_JSON");
                                            String diff = new CompareUtilities().compareObjects("payload", "$", toSignJ, signedJ);
                                            if (diff == null) {
                                                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_JSON_MATCHES", new Object[0]);
                                                break block70;
                                            }
                                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_JSON_NO_MATCH", diff);
                                        }
                                        catch (Exception e) {
                                            ok = false;
                                            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.EXCEPTION, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_INVALID_JSON", e.getMessage());
                                        }
                                    } else {
                                        String b64 = Base64URL.encode((byte[])toSign).toString();
                                        ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, parts[1].equals(b64), "BUNDLE_SIGNATURE_PAYLOAD_BASE64_DIFF", new Object[0]) & ok;
                                    }
                                }
                            }
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIG_OK", new Object[0]);
                        }
                    }
                    if (cert != null) {
                        if (verified) {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_BY_VERIFIED", CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(DigitalSignatureSupport.getNamesFromCertificate(cert, false))));
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_BY", CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(DigitalSignatureSupport.getNamesFromCertificate(cert, false))));
                        }
                    }
                    if (sigT != null) {
                        if (verified) {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_AT_VERIFIED", sigT);
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_AT", sigT);
                        }
                    }
                    if (purpose != null) {
                        if (verified && purposeOk) {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_FOR_VERIFIED", purpose, purposeDesc);
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_FOR", purpose, purposeDesc);
                        }
                    }
                    if (cert != null) {
                        this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_CERT_DETAILS", cert.getSubjectX500Principal().getName(), cert.getIssuerX500Principal().getName(), cert.getSerialNumber().toString(16).toUpperCase());
                        this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_CERT_SOURCE", this.certificateToPEMSingleLine(cert));
                    }
                }
                catch (Exception e) {
                    ok = false;
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.EXCEPTION, stack, false, "BUNDLE_SIGNATURE_SIG_ERROR", e.getMessage());
                }
            }
        }
        return ok;
    }

    public String certificateToPEMSingleLine(X509Certificate cert) throws Exception {
        byte[] encoded = cert.getEncoded();
        String base64 = Base64.getEncoder().encodeToString(encoded);
        return "-----BEGIN CERTIFICATE-----" + base64 + "-----END CERTIFICATE-----";
    }

    private String getPurpose(JsonObject header) {
        JsonArray srCms;
        if (header.has("srCms") && (srCms = header.getJsonArray("srCms")).size() > 0 && srCms.get(0).isJsonObject()) {
            JsonObject commId = srCms.get(0).asJsonObject().getJsonObject("commId");
            return commId.asString("id");
        }
        return null;
    }

    private String getPurposeDesc(JsonObject header) {
        JsonArray srCms;
        if (header.has("srCms") && (srCms = header.getJsonArray("srCms")).size() > 0 && srCms.get(0).isJsonObject()) {
            JsonObject commId = srCms.get(0).asJsonObject().getJsonObject("commId");
            return commId.asString("desc");
        }
        return null;
    }

    private byte[] makeSignableBundle(org.hl7.fhir.r5.elementmodel.Element bundle, String canon, boolean xml) throws IOException, InvalidCanonicalizerException, CanonicalizationException, ParserConfigurationException, SAXException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        ParserBase p = Manager.makeParser((IWorkerContext)this.context, (Manager.FhirFormat)(xml ? Manager.FhirFormat.XML : Manager.FhirFormat.JSON));
        String root = bundle.getPath();
        if (canon.endsWith("#document")) {
            p.setCanonicalFilter(new String[]{root + ".id", root + ".meta", root + ".signature"});
        } else {
            p.setCanonicalFilter(new String[]{root + ".signature"});
        }
        p.compose(bundle, (OutputStream)ba, IParser.OutputStyle.CANONICAL, null);
        byte[] toSign = ba.toByteArray();
        return xml ? DigitalSignatureSupport.canonicalizeXml(new String(toSign, StandardCharsets.UTF_8), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315") : toSign;
    }

    private JWK parseX509c(X509Certificate certificate) throws CertificateException {
        RSAKey jwk;
        PublicKey publicKey = certificate.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            jwk = new RSAKey.Builder((RSAPublicKey)publicKey).build();
        } else if (publicKey instanceof ECPublicKey) {
            jwk = new ECKey.Builder(Curve.forECParameterSpec((ECParameterSpec)((ECPublicKey)publicKey).getParams()), (ECPublicKey)publicKey).build();
        } else {
            throw new IllegalArgumentException("Unsupported key type: " + publicKey.getAlgorithm());
        }
        return jwk;
    }

    public boolean verifyJWT(String jwtString, JWK key) throws ParseException, JOSEException {
        String keyType;
        SignedJWT signedJWT = SignedJWT.parse((String)jwtString);
        return signedJWT.verify((JWSVerifier)(switch (keyType = key.getKeyType().toString()) {
            case "RSA" -> new RSASSAVerifier(key.toRSAKey());
            case "EC" -> new ECDSAVerifier(key.toECKey());
            case "oct" -> new MACVerifier(key.toOctetSequenceKey());
            default -> throw new IllegalArgumentException("Unsupported key type: " + keyType);
        }));
    }

    private boolean validateSignatureDigSig(List<ValidationMessage> errors, org.hl7.fhir.r5.elementmodel.Element bundle, NodeStack stack, org.hl7.fhir.r5.elementmodel.Element signature, String d) {
        boolean ok = true;
        Document dom = null;
        try {
            dom = XMLUtil.parseToDom((String)d, (boolean)true);
        }
        catch (Exception e) {
            ok = false;
            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_DIGSIG_INVALID", e.getMessage());
        }
        Object canon = null;
        boolean xml = false;
        if (dom == null) {
            ok = false;
        } else {
            DigitalSignatureSupport.DigitalSignatureWrapper dsig = new DigitalSignatureSupport.DigitalSignatureWrapper(dom.getDocumentElement());
            Instant instant = null;
            org.hl7.fhir.r5.elementmodel.Element when = signature.getNamedChild("when");
            String sigT = dsig.getDigSigTime();
            if (sigT == null) {
                this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_DIGSIG_NO_SIG_TIME", new Object[0]);
            } else {
                instant = Instant.parse(sigT);
            }
            if (when == null) {
                this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_HEADER_WHEN_MISMATCH", new Object[0]);
            } else if (sigT != null) {
                ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.BUSINESSRULE, stack, sigT.equals(when.primitiveValue()), "BUNDLE_SIGNATURE_DIGSIG_WHEN_MISMATCH", sigT, when.primitiveValue()) && ok;
            }
            org.hl7.fhir.r5.elementmodel.Element tgtFmt = signature.getNamedChild("targetFormat");
            String tcanon = null;
            canon = dsig.getDigSigCanonicalization();
            if (tgtFmt != null) {
                try {
                    MimeType mt = new MimeType(tgtFmt.primitiveValue());
                    xml = mt.getBase().contains("xml");
                    tcanon = (String)mt.getParams().get("canonicalization");
                }
                catch (Exception e) {
                    ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_CANON_ERROR", tgtFmt.primitiveValue(), e.getMessage()) && ok;
                }
            }
            String defCanon = "http://hl7.org/fhir/canonicalization/" + (xml ? "xml" : "json");
            if (canon == null) {
                if (tcanon == null) {
                    canon = defCanon + ("document".equals(bundle.getNamedChildValue(new String[]{"type"})) ? "#document" : "");
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_PAYLOAD_CANON_DEFAULT", canon);
                } else {
                    canon = tcanon;
                }
            } else {
                if (tcanon != null) {
                    this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, ((String)canon).equals(tcanon), "BUNDLE_SIGNATURE_CANON_DIFF", canon, tcanon);
                }
                xml = ((String)canon).contains("xml");
            }
            Object purpose = dsig.getPurpose();
            String purposeDesc = dsig.getPurposeDesc();
            boolean purposeOk = false;
            List types = signature.getChildren("type");
            for (org.hl7.fhir.r5.elementmodel.Element type : types) {
                ValidationResult vr;
                String p = null;
                String system = type.getNamedChildValue(new String[]{"system"});
                String code = type.getNamedChildValue(new String[]{"code"});
                p = OIDUtilities.isValidOID((String)code) ? "urn:oid:" + code : system + "#" + code;
                if (purpose == null) {
                    purpose = p;
                    vr = this.context.validateCode((ValidationOptions)this.settings, system, null, code, null);
                    if (!vr.isOk()) break;
                    purposeDesc = vr.getDisplay();
                    break;
                }
                if (!((String)purpose).equals(p)) continue;
                purposeOk = true;
                if (purposeDesc != null || !(vr = this.context.validateCode((ValidationOptions)this.settings, system, null, code, null)).isOk()) break;
                purposeDesc = vr.getDisplay();
                break;
            }
            X509Certificate cert = null;
            JWK jwk = null;
            Element x5c = dsig.getDigSigX509();
            if (x5c != null) {
                try {
                    String c = x5c.getTextContent();
                    byte[] b = org.apache.commons.codec.binary.Base64.decodeBase64((String)c);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(b));
                    jwk = this.parseX509c(cert);
                }
                catch (Exception e) {
                    ok = false;
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_DIGSIG_X509_ERROR", e.getMessage());
                }
            } else {
                this.warning(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_SIGNATURE_DIGSIG_NO_CERT", new Object[0]);
            }
            org.hl7.fhir.r5.elementmodel.Element who = signature.getNamedChild("who");
            boolean whoMatches = false;
            String idv = null;
            if (cert != null && cert.getSubjectX500Principal() != null && cert.getSubjectX500Principal().getName() != null) {
                org.hl7.fhir.r5.elementmodel.Element id = who == null ? null : who.getNamedChild("identifier");
                idv = id == null ? null : id.getNamedChildValue(new String[]{"value"});
                Set<String> cnlist = DigitalSignatureSupport.getNamesFromCertificate(cert, this.settings.isDebug());
                if (idv != null) {
                    whoMatches = cnlist.contains(idv);
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, whoMatches, "BUNDLE_SIGNATURE_WHO_MISMATCH", idv, CommaSeparatedStringBuilder.joinWrapped((String)",", (String)"'", (String)"'", cnlist));
                } else {
                    this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_WHO_RECOMMENDED", cert.getSubjectX500Principal().getName());
                }
            } else if (who == null) {
                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_WHO_NO_INFO", new Object[0]);
            } else {
                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_WHO_NOT_IN_CERT", new Object[0]);
            }
            List<Element> references = dsig.getDigSigReferences();
            if (references.isEmpty()) {
                ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, false, "BUNDLE_SIGNATURE_DIGSIG_NO_REFERENCES", new Object[0]) && ok;
            } else if (references.size() > 2) {
                ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, false, "BUNDLE_SIGNATURE_DIGSIG_REFERENCES_TOO_MANY", references.size()) && ok;
            } else if (references.size() == 2) {
                ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, "#".equals(references.get(0).getAttribute("URI")), "BUNDLE_SIGNATURE_DIGSIG_REFERENCE_NOT_UNDERSTOOD", references.get(0).getAttribute("URI")) && ok;
                dsig.setContentReference(references.get(0));
                ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, "http://uri.etsi.org/01903#SignedProperties".equals(references.get(1).getAttribute("Type")), "BUNDLE_SIGNATURE_DIGSIG_REFERENCE_TYPE_NOT_UNDERSTOOD", references.get(1).getAttribute("Type")) && ok;
                dsig.setXadesReference(references.get(1));
            } else {
                dsig.setContentReference(references.get(0));
                boolean bl = ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTSUPPORTED, stack, "#".equals(references.get(0).getAttribute("URI")), "BUNDLE_SIGNATURE_DIGSIG_REFERENCE_NOT_UNDERSTOOD", references.get(0).getAttribute("URI")) && ok;
            }
            if (jwk != null && canon != null) {
                byte[] toSign = null;
                try {
                    toSign = this.makeSignableBundle(bundle, (String)canon, xml);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String signatureValueText = dsig.getDigSigSigValue();
                ok = this.rule(errors, "2025-06-13", ValidationMessage.IssueType.NOTFOUND, stack, signatureValueText != null, "BUNDLE_SIGNATURE_DIGSIG_NO_SV", new Object[0]) && ok;
                byte[] signatureBytes = null;
                try {
                    signatureBytes = signatureValueText == null ? null : org.apache.commons.net.util.Base64.decodeBase64((String)signatureValueText);
                }
                catch (Exception e) {
                    ok = false;
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_DIGSIG_INVALID", e.getMessage());
                }
                try {
                    boolean verified;
                    block64: {
                        verified = this.verifyDigSig(errors, stack, cert, jwk, dsig.getDigSigAlg(), (String)canon, toSign, signatureBytes, instant, dsig, "with");
                        if (!verified) {
                            ok = false;
                            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_SIG_FAIL_CERT", new Object[0]);
                            String sb = dsig.getDigSigSigned();
                            if (sb != null) {
                                byte[] signed = null;
                                try {
                                    signed = org.apache.commons.net.util.Base64.decodeBase64((String)sb);
                                }
                                catch (Exception e) {
                                    ok = false;
                                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_INVALID", e.getMessage());
                                }
                                if (signed != null) {
                                    if (!Arrays.equals(toSign, signed)) {
                                        this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_MISMATCH", toSign.length, signed.length);
                                        try {
                                            Document signedX = this.parseXmlOrError(errors, stack, signed, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_INVALID_XML");
                                            Document toSignX = this.parseXmlOrError(errors, stack, toSign, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_INVALID_XML");
                                            String diff = new CompareUtilities().compareElements("payload", "$", toSignX.getDocumentElement(), signedX.getDocumentElement());
                                            if (diff == null) {
                                                this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_XML_MATCHES", new Object[0]);
                                                break block64;
                                            }
                                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_XML_NO_MATCH", diff);
                                        }
                                        catch (Exception e) {
                                            ok = false;
                                            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.EXCEPTION, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_INVALID_XML", e.getMessage());
                                        }
                                    } else {
                                        this.hint(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIGNED_SAME", new Object[0]);
                                    }
                                }
                            }
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIG_OK", new Object[0]);
                        }
                    }
                    if (cert != null) {
                        if (idv == null) {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_BY", cert.getSubjectX500Principal().getName());
                        } else if (whoMatches) {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_BY_VERIFIED", idv);
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_BY", idv);
                        }
                    }
                    if (when != null || instant != null && dsig.getXadesReference() != null) {
                        this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_AT_VERIFIED", when.primitiveValue());
                    } else if (sigT != null) {
                        this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_AT", sigT);
                    }
                    if (purpose != null) {
                        if (verified && purposeOk) {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_FOR_VERIFIED", purpose, purposeDesc);
                        } else {
                            this.hint(errors, "2025-06-13", ValidationMessage.IssueType.INFORMATIONAL, stack, false, "BUNDLE_SIGNATURE_SIGNED_FOR", purpose, purposeDesc);
                        }
                    }
                }
                catch (Exception e) {
                    ok = false;
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.EXCEPTION, stack, false, "BUNDLE_SIGNATURE_SIG_ERROR", e.getMessage());
                }
            }
        }
        return ok;
    }

    private boolean verifyDigSig(List<ValidationMessage> errors, NodeStack stack, X509Certificate cert, JWK jwk, String alg, String canon, byte[] toSign, byte[] signatureBytes, Instant instant, DigitalSignatureSupport.DigitalSignatureWrapper dsig, String name) {
        try {
            String javaAlgorithm;
            String actualDigest = DigitalSignatureSupport.getDigest(toSign, "debug-" + name);
            String expectedDigest = XMLUtil.getNamedChildText((Element)dsig.getContentReference(), (String)"DigestValue");
            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, actualDigest.equals(expectedDigest), "BUNDLE_SIGNATURE_SIG_DIGEST_MISMATCH", actualDigest, expectedDigest);
            byte[] xc = null;
            if (dsig.getXadesReference() != null) {
                xc = DigitalSignatureSupport.canonicalizeXml(this.fixNS(dsig.getXadesSignable()), "http://www.w3.org/2001/10/xml-exc-c14n#");
                actualDigest = DigitalSignatureSupport.getDigest(xc, "debug-xades");
                expectedDigest = XMLUtil.getNamedChildText((Element)dsig.getXadesReference(), (String)"DigestValue");
                this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, actualDigest.equals(expectedDigest), "BUNDLE_SIGNATURE_SIG_DIGEST_MISMATCH_XADES", actualDigest, expectedDigest);
            }
            byte[] signedInfoBytes = DigitalSignatureSupport.buildSignInfoXades(cert, toSign, canon, xc, "check-" + name, null, null).getSignable();
            switch (alg) {
                case "http://www.w3.org/2000/09/xmldsig#rsa-sha1": {
                    javaAlgorithm = "SHA1withRSA";
                    break;
                }
                case "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256": {
                    javaAlgorithm = "SHA256withRSA";
                    break;
                }
                case "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512": {
                    javaAlgorithm = "SHA512withRSA";
                    break;
                }
                default: {
                    this.rule(errors, "2025-06-13", ValidationMessage.IssueType.VALUE, stack, false, "BUNDLE_SIGNATURE_SIG_FAIL_CERT", new Object[0]);
                    log.error("Unsupported signature algorithm: " + alg);
                    return false;
                }
            }
            Signature sig = Signature.getInstance(javaAlgorithm);
            sig.initVerify(cert.getPublicKey());
            sig.update(signedInfoBytes);
            return sig.verify(signatureBytes);
        }
        catch (Exception e) {
            this.rule(errors, "2025-06-13", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_SIGNATURE_DIGSIG_SIG_ERROR", e.getMessage());
            return false;
        }
    }

    private Element fixNS(Element x) {
        if (x.getNamespaceURI() != null) {
            String string = x.getNamespaceURI();
        }
        return x;
    }

    public class StringWithSource {
        private String reference;
        private org.hl7.fhir.r5.elementmodel.Element source;
        private boolean warning;
        private boolean nlLink;

        public StringWithSource(String reference, org.hl7.fhir.r5.elementmodel.Element source, boolean warning, boolean nlLink) {
            this.reference = reference;
            this.source = source;
            this.warning = warning;
            this.nlLink = nlLink;
        }

        public String getReference() {
            return this.reference;
        }

        public org.hl7.fhir.r5.elementmodel.Element getSource() {
            return this.source;
        }

        public boolean isWarning() {
            return this.warning;
        }

        public boolean isNlLink() {
            return this.nlLink;
        }
    }
}

