/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.scoring;

import lombok.Generated;

public class RuleScore {
    private String key;
    private int totalCount;
    private double points;
    private int passCount;

    public RuleScore(String key, double points) {
        this.key = key;
        this.points = points;
    }

    public void count(boolean passes) {
        ++this.totalCount;
        if (passes) {
            ++this.passCount;
        }
    }

    public String summary() {
        StringBuilder b = new StringBuilder();
        b.append(this.key);
        b.append("(");
        b.append(this.points);
        b.append("): ");
        b.append(this.totalCount);
        b.append(" = ");
        b.append(this.passCount * 100 / this.totalCount);
        b.append("%");
        return b.toString();
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public int getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public double getPoints() {
        return this.points;
    }

    @Generated
    public int getPassCount() {
        return this.passCount;
    }
}

