/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.json.JsonException;

public class TxTesterSorters {
    public static void main(String[] args) throws JsonException, IOException {
        Resource r = new JsonParser().parse((InputStream)new FileInputStream(args[0]));
        switch (r.fhirType()) {
            case "Parameters": {
                TxTesterSorters.sortParameters((Parameters)r);
                break;
            }
            default: {
                return;
            }
        }
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose((OutputStream)new FileOutputStream(args[0]), r);
    }

    public static void sortParameters(Parameters po) {
        Collections.sort(po.getParameter(), new ParameterSorter());
        for (Parameters.ParametersParameterComponent p : po.getParameter()) {
            String pv;
            if (p.getResource() != null && p.getResource() instanceof OperationOutcome) {
                Collections.sort(((OperationOutcome)p.getResource()).getIssue(), new OperationIssueSorter());
            }
            if (p.getResource() != null && p.getResource() instanceof Parameters) {
                TxTesterSorters.sortParameters((Parameters)p.getResource());
            }
            if (!"message".equals(p.getName()) || !p.hasValuePrimitive() || !(pv = p.getValue().primitiveValue()).contains("; ")) continue;
            ArrayList<String> bits = new ArrayList<String>();
            for (String s : pv.split("\\; ")) {
                bits.add(s);
            }
            Collections.sort(bits);
            p.setValue((DataType)new StringType(CommaSeparatedStringBuilder.join((String)"; ", bits)));
        }
    }

    public static void sortOperationOutcome(OperationOutcome oo) {
        Collections.sort(oo.getIssue(), new OperationIssueSorter());
    }

    public static void sortValueSet(ValueSet vs) {
        Collections.sort(vs.getExtension(), new ExtensionSorter());
        if (vs.hasExpansion()) {
            Collections.sort(vs.getExpansion().getParameter(), new ExpParameterSorter());
            Collections.sort(vs.getExpansion().getProperty(), new PropertyDefnSorter());
            Collections.sort(vs.getExpansion().getExtension(), new ExtensionSorter());
            Collections.sort(vs.getExpansion().getContains(), new ContainsSorter());
            for (ValueSet.ValueSetExpansionContainsComponent cc : vs.getExpansion().getContains()) {
                TxTesterSorters.sortContainsFeatures(cc);
            }
        }
    }

    public static void sortContainsFeatures(ValueSet.ValueSetExpansionContainsComponent cc) {
        Collections.sort(cc.getContains(), new ContainsSorter());
        Collections.sort(cc.getExtension(), new ExtensionSorter());
        Collections.sort(cc.getDesignation(), new DesignationSorter());
        Collections.sort(cc.getProperty(), new PropertyValueSorter());
        for (ValueSet.ValueSetExpansionContainsComponent c : cc.getContains()) {
            TxTesterSorters.sortContainsFeatures(c);
        }
    }

    public static void sortCapStmt(CapabilityStatement cs) {
        Collections.sort(cs.getFormat(), new CodeTypeSorter());
        Collections.sort(cs.getInstantiates(), new CanonicalTypeSorter());
        Collections.sort(cs.getImports(), new CanonicalTypeSorter());
        Collections.sort(cs.getAcceptLanguage(), new CodeTypeSorter());
        Collections.sort(cs.getRest(), new CSRestSorter());
        for (CapabilityStatement.CapabilityStatementRestComponent r : cs.getRest()) {
            if (r.hasSecurity()) {
                for (CodeableConcept cc : r.getSecurity().getService()) {
                    Collections.sort(cc.getCoding(), new CodingSorter());
                }
                Collections.sort(r.getSecurity().getService(), new CodeableConceptSorter());
            }
            Collections.sort(r.getResource(), new CSRestResourceSorter());
            for (CapabilityStatement.CapabilityStatementRestResourceComponent res : r.getResource()) {
                Collections.sort(res.getSupportedProfile(), new CanonicalTypeSorter());
                Collections.sort(res.getInteraction(), new CSRestResourceInteractionSorter());
                Collections.sort(res.getSearchInclude(), new StringTypeSorter());
                Collections.sort(res.getSearchRevInclude(), new StringTypeSorter());
                Collections.sort(res.getSearchParam(), new SearchParamSorter());
                Collections.sort(res.getOperation(), new CSRestResourceOperationSorter());
            }
            Collections.sort(r.getInteraction(), new CSRestInteractionSorter());
            Collections.sort(r.getSearchParam(), new SearchParamSorter());
            Collections.sort(r.getOperation(), new CSRestResourceOperationSorter());
            Collections.sort(r.getCompartment(), new CanonicalTypeSorter());
        }
    }

    public static void sortTermCaps(TerminologyCapabilities tc) {
        Collections.sort(tc.getCodeSystem(), new TCCodeSystemSorter());
        for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent t : tc.getCodeSystem()) {
            Collections.sort(t.getVersion(), new TCCodeSystemVersionSorter());
            for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent v : t.getVersion()) {
                Collections.sort(v.getLanguage(), new LanguageSorter());
                Collections.sort(v.getProperty(), new CodeTypeSorter());
                Collections.sort(v.getFilter(), new TCCodeSystemVersionFilterSorter());
            }
        }
        Collections.sort(tc.getExpansion().getParameter(), new TCExpansionParameterSorter());
    }

    public static class ParameterSorter
    implements Comparator<Parameters.ParametersParameterComponent> {
        @Override
        public int compare(Parameters.ParametersParameterComponent o1, Parameters.ParametersParameterComponent o2) {
            String v2;
            String v1;
            String code2;
            String code1;
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            Collections.sort(o1.getPart(), new ParameterSorter());
            Collections.sort(o2.getPart(), new ParameterSorter());
            if (o1.getName().equals(o2.getName()) && o1.getName().equals("property")) {
                code1 = o1.getPart("code").getValue().primitiveValue().toLowerCase();
                code2 = o2.getPart("code").getValue().primitiveValue().toLowerCase();
                if (code1 != null && code2 != null && !code1.equals(code2)) {
                    return code1.compareTo(code2);
                }
                v1 = o1.getPart("value") != null && o1.getPart("value").getValue().hasPrimitiveValue() ? o1.getPart("value").getValue().primitiveValue().toLowerCase() : null;
                String string = v2 = o2.getPart("value") != null && o2.getPart("value").getValue().hasPrimitiveValue() ? o2.getPart("value").getValue().primitiveValue().toLowerCase() : null;
                if (v1 != null && v2 != null && !v1.equals(v2)) {
                    return v1.compareTo(v2);
                }
            }
            if (o1.getName().equals(o2.getName()) && o1.getName().equals("designation")) {
                code1 = o1.hasPart("language") && o1.getPart("language").hasValue() && o1.getPart("language").getValue().primitiveValue() != null ? o1.getPart("language").getValue().primitiveValue().toLowerCase() : "";
                String string = code2 = o2.hasPart("language") && o2.getPart("language").hasValue() && o2.getPart("language").getValue().primitiveValue() != null ? o2.getPart("language").getValue().primitiveValue().toLowerCase() : "";
                if (code1 != null && code2 != null && !code1.equals(code2)) {
                    return code1.compareTo(code2);
                }
                v1 = o1.getPart("value") != null && o1.getPart("value").hasPrimitiveValue() ? o1.getPart("value").getValue().primitiveValue().toLowerCase() : null;
                String string2 = v2 = o2.getPart("value") != null && o2.getPart("value").hasPrimitiveValue() ? o2.getPart("value").getValue().primitiveValue().toLowerCase() : null;
                if (v1 != null && v2 != null && !v1.equals(v2)) {
                    return v1.compareTo(v2);
                }
            }
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class OperationIssueSorter
    implements Comparator<OperationOutcome.OperationOutcomeIssueComponent> {
        @Override
        public int compare(OperationOutcome.OperationOutcomeIssueComponent o1, OperationOutcome.OperationOutcomeIssueComponent o2) {
            String s2;
            String s1 = o1.hasSeverity() ? o1.getSeverity().toCode() : "";
            int ret = s1.compareTo(s2 = o2.hasSeverity() ? o2.getSeverity().toCode() : "");
            if (ret == 0 && (ret = (s1 = o1.hasCode() ? o1.getCode().toCode() : "").compareTo(s2 = o2.hasCode() ? o2.getCode().toCode() : "")) == 0 && (ret = (s1 = o1.hasExpressionOrLocation() ? ((StringType)o1.getExpressionOrLocation().get(0)).primitiveValue() : "").compareTo(s2 = o2.hasExpressionOrLocation() ? ((StringType)o2.getExpressionOrLocation().get(0)).primitiveValue() : "")) == 0) {
                s1 = o1.getDetails().hasText() ? o1.getDetails().getText() : "";
                s2 = o2.getDetails().hasText() ? o2.getDetails().getText() : "";
                ret = s1.compareTo(s2);
            }
            return ret;
        }
    }

    public static class ExtensionSorter
    implements Comparator<Extension> {
        @Override
        public int compare(Extension o1, Extension o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }

    public static class ExpParameterSorter
    implements Comparator<ValueSet.ValueSetExpansionParameterComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionParameterComponent o1, ValueSet.ValueSetExpansionParameterComponent o2) {
            Collections.sort(o1.getExtension(), new ExtensionSorter());
            Collections.sort(o2.getExtension(), new ExtensionSorter());
            int res = o1.getName().compareTo(o2.getName());
            if (res == 0) {
                res = o1.getValue().primitiveValue().compareTo(o2.getValue().primitiveValue());
            }
            return res;
        }
    }

    public static class PropertyDefnSorter
    implements Comparator<ValueSet.ValueSetExpansionPropertyComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionPropertyComponent o1, ValueSet.ValueSetExpansionPropertyComponent o2) {
            int i = o1.getUri() == null || o2.getUri() == null ? (o1.getUri() == null && o2.getUri() == null ? 0 : (o1.getUri() == null ? -1 : 1)) : o1.getUri().compareTo(o2.getUri());
            if (i == 0) {
                return o1.getCode().compareTo(o2.getCode());
            }
            return i;
        }
    }

    public static class ContainsSorter
    implements Comparator<ValueSet.ValueSetExpansionContainsComponent> {
        @Override
        public int compare(ValueSet.ValueSetExpansionContainsComponent o1, ValueSet.ValueSetExpansionContainsComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class DesignationSorter
    implements Comparator<ValueSet.ConceptReferenceDesignationComponent> {
        @Override
        public int compare(ValueSet.ConceptReferenceDesignationComponent o1, ValueSet.ConceptReferenceDesignationComponent o2) {
            if (o1.hasLanguage() && o2.hasLanguage()) {
                return o1.getLanguage().compareTo(o2.getLanguage());
            }
            return o1.getValue().compareTo(o2.getValue());
        }
    }

    public static class PropertyValueSorter
    implements Comparator<ValueSet.ConceptPropertyComponent> {
        @Override
        public int compare(ValueSet.ConceptPropertyComponent o1, ValueSet.ConceptPropertyComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class CodeTypeSorter
    implements Comparator<CodeType> {
        @Override
        public int compare(CodeType o1, CodeType o2) {
            return o1.asStringValue().compareTo(o2.asStringValue());
        }
    }

    public static class CanonicalTypeSorter
    implements Comparator<CanonicalType> {
        @Override
        public int compare(CanonicalType o1, CanonicalType o2) {
            return o1.asStringValue().compareTo(o2.asStringValue());
        }
    }

    public static class CSRestSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestComponent o1, CapabilityStatement.CapabilityStatementRestComponent o2) {
            return o1.getMode().compareTo((Enum)o2.getMode());
        }
    }

    public static class CodingSorter
    implements Comparator<Coding> {
        @Override
        public int compare(Coding c1, Coding c2) {
            if (c1.getSystem().equals(c2.getSystem())) {
                return c1.getCode().compareTo(c2.getCode());
            }
            return c1.getSystem().compareTo(c2.getSystem());
        }
    }

    public static class CodeableConceptSorter
    implements Comparator<CodeableConcept> {
        @Override
        public int compare(CodeableConcept o1, CodeableConcept o2) {
            if (o1.hasCoding() && o2.hasCoding()) {
                Coding c1 = o1.getCodingFirstRep();
                Coding c2 = o2.getCodingFirstRep();
                if (c1.getSystem().equals(c2.getSystem())) {
                    return c1.getCode().compareTo(c2.getCode());
                }
                return c1.getSystem().compareTo(c2.getSystem());
            }
            return o1.getText().compareTo(o2.getText());
        }
    }

    public static class CSRestResourceSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestResourceComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestResourceComponent o1, CapabilityStatement.CapabilityStatementRestResourceComponent o2) {
            return o1.getType().compareTo(o2.getType());
        }
    }

    public static class CSRestResourceInteractionSorter
    implements Comparator<CapabilityStatement.ResourceInteractionComponent> {
        @Override
        public int compare(CapabilityStatement.ResourceInteractionComponent o1, CapabilityStatement.ResourceInteractionComponent o2) {
            return o1.getCode().toCode().compareTo(o2.getCode().toCode());
        }
    }

    public static class StringTypeSorter
    implements Comparator<StringType> {
        @Override
        public int compare(StringType o1, StringType o2) {
            return o1.asStringValue().compareTo(o2.asStringValue());
        }
    }

    public static class SearchParamSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent o1, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class CSRestResourceOperationSorter
    implements Comparator<CapabilityStatement.CapabilityStatementRestResourceOperationComponent> {
        @Override
        public int compare(CapabilityStatement.CapabilityStatementRestResourceOperationComponent o1, CapabilityStatement.CapabilityStatementRestResourceOperationComponent o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class CSRestInteractionSorter
    implements Comparator<CapabilityStatement.SystemInteractionComponent> {
        @Override
        public int compare(CapabilityStatement.SystemInteractionComponent o1, CapabilityStatement.SystemInteractionComponent o2) {
            return o1.getCode().compareTo((Enum)o2.getCode());
        }
    }

    public static class TCCodeSystemSorter
    implements Comparator<TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent> {
        @Override
        public int compare(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent o1, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent o2) {
            return o1.getUri().compareTo(o2.getUri());
        }
    }

    public static class TCCodeSystemVersionSorter
    implements Comparator<TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent> {
        @Override
        public int compare(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent o1, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionComponent o2) {
            return o1.getCode() == null || o2.getCode() == null ? 0 : o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class LanguageSorter
    implements Comparator<Enumeration<Enumerations.CommonLanguages>> {
        @Override
        public int compare(Enumeration<Enumerations.CommonLanguages> o1, Enumeration<Enumerations.CommonLanguages> o2) {
            return o1.asStringValue().compareTo(o2.asStringValue());
        }
    }

    public static class TCCodeSystemVersionFilterSorter
    implements Comparator<TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent> {
        @Override
        public int compare(TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent o1, TerminologyCapabilities.TerminologyCapabilitiesCodeSystemVersionFilterComponent o2) {
            return o1.getCode().compareTo(o2.getCode());
        }
    }

    public static class TCExpansionParameterSorter
    implements Comparator<TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent> {
        @Override
        public int compare(TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent o1, TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

