/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service.model;

import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.StructureDefinition;

public class ScanOutputItem {
    private String ref;
    private ImplementationGuide ig;
    private StructureDefinition profile;
    private OperationOutcome outcome;
    private String id;

    public ScanOutputItem(String ref, ImplementationGuide ig, StructureDefinition profile, OperationOutcome outcome) {
        this.ref = ref;
        this.ig = ig;
        this.profile = profile;
        this.outcome = outcome;
    }

    public String getRef() {
        return this.ref;
    }

    public ImplementationGuide getIg() {
        return this.ig;
    }

    public StructureDefinition getProfile() {
        return this.profile;
    }

    public OperationOutcome getOutcome() {
        return this.outcome;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        if (this.profile != null) {
            return "Validate " + this.ref + " against " + this.profile.present() + " (" + this.profile.getUrl() + ")";
        }
        if (this.ig != null) {
            return "Validate " + this.ref + " against global profile specified in " + this.ig.present() + " (" + this.ig.getUrl() + ")";
        }
        return "Validate " + this.ref + " against FHIR Spec";
    }
}

