/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.validation.codegen.Analysis;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;

public class JavaParserGenerator
extends JavaBaseGenerator {
    private StringBuilder register = new StringBuilder();
    private String jname;

    public JavaParserGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName, String jname) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
        this.jname = jname;
    }

    public void seeClass(Analysis analysis) throws Exception {
        this.generateParser(analysis);
    }

    public void generate() throws Exception {
        String template = this.config.getAdornments().get("Parser");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{jname}}", this.jname);
        template = template.replace("{{register}}", this.register.toString());
        this.write(template);
        this.flush();
        this.close();
    }

    private void generateParser(Analysis analysis) throws Exception {
        if (analysis.getAncestor().getName().equals("Resource")) {
            this.register.append("    org.hl7.fhir.r5.formats.JsonParser.getCustomResourceHandlers().put(\"" + analysis.getName() + "\", new " + this.jname + "JsonParserFactory());\r\n");
        }
    }
}

