/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public class Configuration {
    private String license;
    private IniFile ini;
    private Map<String, String> adornments = new HashMap<String, String>();

    public static final SimpleDateFormat DATE_FORMAT() {
        return new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US"));
    }

    public Configuration(String path) throws FileNotFoundException, IOException {
        this.license = FileUtilities.fileToString((String)Utilities.path((String[])new String[]{path, "license.txt"}));
        this.ini = new IniFile(Utilities.path((String[])new String[]{path, "configuration.ini"}));
        for (File jfn : ManagedFileAccess.file((String)path).listFiles()) {
            if (!jfn.getName().endsWith(".java")) continue;
            this.adornments.put(FileUtilities.changeFileExt((String)jfn.getName(), (String)""), FileUtilities.fileToString((File)jfn));
        }
    }

    public String getLicense() {
        return this.license;
    }

    public Map<String, String> getAdornments() {
        return this.adornments;
    }

    public IniFile getIni() {
        return this.ini;
    }
}

