/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ai;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.validation.ai.ChatGPTAPI;
import org.hl7.fhir.validation.ai.ClaudeAPI;
import org.hl7.fhir.validation.ai.CodeAndTextValidationRequest;
import org.hl7.fhir.validation.ai.CodeAndTextValidationResult;
import org.hl7.fhir.validation.ai.Ollama;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AITests {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AITests.class);

    public static void main(String[] args) throws IOException {
        new AITests().execute(args[0], args.length == 1 ? null : args[1], args.length == 2 ? true : "true".equals(args[2]));
    }

    public void execute(String testFilename, String config, boolean useServers) throws IOException {
        JsonObject test;
        CodeAndTextValidationRequest req;
        int i;
        ManagedWebAccess.loadFromFHIRSettings();
        InputStream cfg = null;
        if (config == null) {
            ClassLoader classLoader = HierarchicalTableGenerator.class.getClassLoader();
            cfg = classLoader.getResourceAsStream("ai-prompts.json");
        } else {
            cfg = new FileInputStream(config);
        }
        JsonObject jcfg = JsonParser.parseObject((InputStream)cfg);
        JsonObject tests = JsonParser.parseObject((File)new File(testFilename));
        ArrayList<CodeAndTextValidationRequest> requests = new ArrayList<CodeAndTextValidationRequest>();
        int c = 0;
        for (JsonObject test2 : tests.getJsonArray("cases").asJsonObjects()) {
            requests.add(new CodeAndTextValidationRequest(null, test2.asString("path"), test2.asString("lang"), test2.asString("system"), test2.asString("code"), test2.asString("display"), test2.asString("text")).setData(test2));
            boolean expected = test2.asString("goal").startsWith("valid");
            if (!expected) continue;
            ++c;
        }
        log.info("Found " + requests.size() + " tests, " + c + " should be valid");
        if (useServers) {
            System.out.print("Ollama");
            log.debug("Ollama");
            long t = System.currentTimeMillis();
            List<CodeAndTextValidationResult> resOllama = new Ollama(jcfg.forceObject("ollama"), null).validateCodings(requests);
            log.info(": " + Utilities.describeDuration((long)(System.currentTimeMillis() - t)));
            System.out.print("ChatGPT");
            log.debug("ChatGPT");
            t = System.currentTimeMillis();
            List<CodeAndTextValidationResult> resChatGPT = new ChatGPTAPI(jcfg.forceObject("chatGPT")).validateCodings(requests);
            log.info(": " + Utilities.describeDuration((long)(System.currentTimeMillis() - t)));
            System.out.print("Claude");
            log.debug("Claude");
            t = System.currentTimeMillis();
            List<CodeAndTextValidationResult> resClaude = new ClaudeAPI(jcfg.forceObject("claude")).validateCodings(requests);
            log.info(": " + Utilities.describeDuration((long)(System.currentTimeMillis() - t)));
            log.info("");
            for (i = 0; i < requests.size(); ++i) {
                req = (CodeAndTextValidationRequest)requests.get(i);
                test = (JsonObject)req.getData();
                log.info("Case " + req.getSystem() + "#" + req.getCode() + " ('" + req.getDisplay() + "') :: '" + req.getText() + "'");
                CodeAndTextValidationResult res = resClaude.get(i);
                log.info("  Claude : " + this.check(test, res, "claude") + "; " + res.summary());
                res = resChatGPT.get(i);
                log.info("  ChatGPT: " + this.check(test, res, "chatgpt") + "; " + res.summary());
                res = resOllama.get(i);
                log.info("  Ollama : " + this.check(test, res, "ollama") + "; " + res.summary());
                log.info("");
            }
        }
        StatsRecord claude = new StatsRecord();
        StatsRecord chatGPT = new StatsRecord();
        StatsRecord ollama = new StatsRecord();
        for (i = 0; i < requests.size(); ++i) {
            System.out.print(".");
            req = (CodeAndTextValidationRequest)requests.get(i);
            test = (JsonObject)req.getData();
            test.remove("disagrement");
            test.remove("unanimous");
            boolean expected = test.asString("goal").startsWith("valid");
            boolean bClaude = test.getJsonObject("claude").asBoolean("valid");
            boolean bChatGPT = test.getJsonObject("chatgpt").asBoolean("valid");
            boolean bOllama = test.getJsonObject("ollama").asBoolean("valid");
            claude.update(expected, bClaude);
            chatGPT.update(expected, bChatGPT);
            ollama.update(expected, bOllama);
        }
        log.info("");
        log.info("        | Number tests correct | %False results  | Classic Diagnostic Statistics    |");
        log.info("        | #All  | #Neg  | #Pos | %F.Pos | %F.Neg | sensitivity | specificity | PPV  |");
        log.info("-------------------------------------------------------------------------------------");
        log.info("Claude  " + claude.summary());
        log.info("ChatGPT " + chatGPT.summary());
        log.info("Ollama  " + ollama.summary());
        this.doTable("Claude", claude);
        this.doTable("ChatGPT", chatGPT);
        this.doTable("Ollama", ollama);
    }

    private void doTable(String name, StatsRecord rec) {
        log.info("");
        log.info("");
        log.info(Utilities.padRight((String)name, (char)' ', (int)7) + " | Valid | Invalid |");
        log.info("--------------------------|");
        log.info("Correct | " + Utilities.padRight((int)rec.correctPos, (char)' ', (int)5) + " | " + Utilities.padRight((int)rec.correctNeg, (char)' ', (int)7) + " |");
        log.info("Wrong   | " + Utilities.padRight((int)rec.falsePositive, (char)' ', (int)5) + " | " + Utilities.padRight((int)rec.falseNegative, (char)' ', (int)7) + " |");
    }

    private String check(JsonObject test, CodeAndTextValidationResult res, String code) {
        boolean passed = res.isValid();
        boolean expected = test.asString("goal").startsWith("valid");
        JsonObject o = test.forceObject(code);
        o.set("valid", res.isValid());
        o.set("explanation", res.getExplanation());
        o.set("confidence", res.getConfidence());
        if (passed == expected) {
            return "T ";
        }
        return "F:" + (passed ? "T" : "F");
    }

    public class StatsRecord {
        public int total;
        public int correct;
        public int correctNeg;
        public int correctPos;
        public int wrong;
        public int falseNegative;
        public int actualNegatives;
        public int falsePositive;

        public String summary() {
            StringBuilder b = new StringBuilder();
            b.append("| ");
            b.append(Utilities.padRight((int)(this.correct * 100 / this.total), (char)' ', (int)7));
            b.append("| ");
            b.append(Utilities.padRight((int)(this.correctNeg * 100 / this.total), (char)' ', (int)5));
            b.append("| ");
            b.append(Utilities.padRight((int)(this.correctPos * 100 / this.total), (char)' ', (int)5));
            b.append("| ");
            b.append(Utilities.padRight((int)this.falsePosRate(), (char)' ', (int)7));
            b.append("| ");
            b.append(Utilities.padRight((int)this.falseNegRate(), (char)' ', (int)7));
            b.append("| ");
            b.append(Utilities.padRight((int)this.sensitivity(), (char)' ', (int)12));
            b.append("| ");
            b.append(Utilities.padRight((int)this.specificity(), (char)' ', (int)12));
            b.append("| ");
            b.append(Utilities.padRight((int)this.ppv(), (char)' ', (int)5));
            b.append("|");
            return b.toString();
        }

        private int ppv() {
            double tp = this.total - this.actualNegatives;
            double fp = this.falsePositive;
            double ppv = tp / (tp + fp);
            return (int)(ppv * 100.0);
        }

        private int specificity() {
            double tn = this.actualNegatives;
            double fp = this.falsePositive;
            double specificity = tn / (tn + fp);
            return (int)(specificity * 100.0);
        }

        private int sensitivity() {
            this.total = this.actualNegatives;
            double tp = this.total;
            double fn = this.falseNegative;
            double sensitivity = tp / (tp + fn);
            return (int)(sensitivity * 100.0);
        }

        private int falseNegRate() {
            double fn = this.falseNegative;
            double tp = this.total - this.actualNegatives;
            double fnr = fn / (fn + tp);
            return (int)(fnr * 100.0);
        }

        private int falsePosRate() {
            double fp = this.falsePositive;
            double tn = this.actualNegatives;
            double fpr = fp / (fp + tn);
            return (int)(fpr * 100.0);
        }

        public void update(boolean expected, boolean passed) {
            ++this.total;
            if (expected) {
                if (passed == expected) {
                    ++this.correctPos;
                }
            } else {
                if (passed == expected) {
                    ++this.correctNeg;
                }
                ++this.actualNegatives;
            }
            if (passed == expected) {
                ++this.correct;
            } else {
                ++this.wrong;
                if (expected) {
                    ++this.falseNegative;
                } else {
                    ++this.falsePositive;
                }
            }
        }
    }
}

