/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codesystem;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.r5.utils.xver.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.ValidatorSettings;
import org.hl7.fhir.validation.codesystem.CodeSystemChecker;
import org.hl7.fhir.validation.instance.type.ValueSetValidator;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class SnomedCTChecker
extends CodeSystemChecker {
    private boolean noTag = false;
    private List<String> noTags = new ArrayList<String>();
    private boolean hasTag = false;
    private List<String> tags = new ArrayList<String>();

    public SnomedCTChecker(IWorkerContext context, @Nonnull ValidatorSettings settings, XVerExtensionManager xverManager, List<ValidationMessage> errors, ValidatorSession session) {
        super(context, settings, xverManager, errors, session);
    }

    @Override
    public void checkConcept(String code, String display) {
        super.checkConcept(code, display);
        if (!Utilities.noString((String)display)) {
            boolean tagged;
            int s = display.lastIndexOf("(");
            int e = display.lastIndexOf(")");
            boolean bl = tagged = e == display.length() - 1 && s > -1 && s > display.length() - 20;
            if (tagged) {
                this.hasTag = true;
                if (this.tags.size() < 5) {
                    this.tags.add(display);
                }
            } else {
                this.noTag = true;
                if (this.noTags.size() < 5) {
                    this.noTags.add(display);
                }
            }
        }
    }

    @Override
    public void finish(Element inc, NodeStack stack) {
        super.finish(inc, stack);
        this.hint((List<ValidationMessage>)this.errors, "2023-07-21", ValidationMessage.IssueType.BUSINESSRULE, inc.line(), inc.col(), stack.getLiteralPath(), !this.noTag || !this.hasTag, "VALUESET_CONCEPT_DISPLAY_SCT_TAG_MIXED", this.tags.toString(), this.noTags.toString());
    }

    @Override
    public void listPropertyNames(List<String> knownNames) {
        this.addName(knownNames, "concept");
        this.addName(knownNames, "constraint");
        this.addName(knownNames, "expressions");
        this.addName(knownNames, "inactive");
        this.addName(knownNames, "410662002");
        this.addName(knownNames, "42752001");
        this.addName(knownNames, "47429007");
        this.addName(knownNames, "116676008");
        this.addName(knownNames, "116686009");
        this.addName(knownNames, "118168003");
        this.addName(knownNames, "118169006");
        this.addName(knownNames, "118170007");
        this.addName(knownNames, "118171006");
        this.addName(knownNames, "127489000");
        this.addName(knownNames, "131195008");
        this.addName(knownNames, "246075003");
        this.addName(knownNames, "246090004");
        this.addName(knownNames, "246093002");
        this.addName(knownNames, "246112005");
        this.addName(knownNames, "246454002");
        this.addName(knownNames, "246456000");
        this.addName(knownNames, "246501002");
        this.addName(knownNames, "246513007");
        this.addName(knownNames, "246514001");
        this.addName(knownNames, "255234002");
        this.addName(knownNames, "260507000");
        this.addName(knownNames, "260686004");
        this.addName(knownNames, "260870009");
        this.addName(knownNames, "263502005");
        this.addName(knownNames, "272741003");
        this.addName(knownNames, "288556008");
        this.addName(knownNames, "363589002");
        this.addName(knownNames, "363698007");
        this.addName(knownNames, "363699004");
        this.addName(knownNames, "363700003");
        this.addName(knownNames, "363701004");
        this.addName(knownNames, "363702006");
        this.addName(knownNames, "363703001");
        this.addName(knownNames, "363704007");
        this.addName(knownNames, "363705008");
        this.addName(knownNames, "363709002");
        this.addName(knownNames, "363710007");
        this.addName(knownNames, "363713009");
        this.addName(knownNames, "363714003");
        this.addName(knownNames, "370129005");
        this.addName(knownNames, "370130000");
        this.addName(knownNames, "370131001");
        this.addName(knownNames, "370132008");
        this.addName(knownNames, "370133003");
        this.addName(knownNames, "370134009");
        this.addName(knownNames, "370135005");
        this.addName(knownNames, "371881003");
        this.addName(knownNames, "405813007");
        this.addName(knownNames, "405814001");
        this.addName(knownNames, "405815000");
        this.addName(knownNames, "405816004");
        this.addName(knownNames, "408729009");
        this.addName(knownNames, "408730004");
        this.addName(knownNames, "408731000");
        this.addName(knownNames, "408732007");
        this.addName(knownNames, "410675002");
        this.addName(knownNames, "411116001");
        this.addName(knownNames, "418775008");
        this.addName(knownNames, "419066007");
        this.addName(knownNames, "424226004");
        this.addName(knownNames, "424244007");
        this.addName(knownNames, "424361007");
        this.addName(knownNames, "424876005");
        this.addName(knownNames, "425391005");
        this.addName(knownNames, "609096000");
        this.addName(knownNames, "704319004");
        this.addName(knownNames, "704320005");
        this.addName(knownNames, "704321009");
        this.addName(knownNames, "704322002");
        this.addName(knownNames, "704323007");
        this.addName(knownNames, "704324001");
        this.addName(knownNames, "704325000");
        this.addName(knownNames, "704326004");
        this.addName(knownNames, "704327008");
        this.addName(knownNames, "704346009");
        this.addName(knownNames, "704347000");
        this.addName(knownNames, "704647008");
        this.addName(knownNames, "718497002");
        this.addName(knownNames, "719715003");
        this.addName(knownNames, "719722006");
        this.addName(knownNames, "726542003");
        this.addName(knownNames, "726633004");
        this.addName(knownNames, "732943007");
        this.addName(knownNames, "732945000");
        this.addName(knownNames, "732947008");
        this.addName(knownNames, "733722007");
        this.addName(knownNames, "733725009");
        this.addName(knownNames, "733928003");
        this.addName(knownNames, "733930001");
        this.addName(knownNames, "733931002");
        this.addName(knownNames, "733932009");
        this.addName(knownNames, "733933004");
        this.addName(knownNames, "734136001");
        this.addName(knownNames, "734137005");
        this.addName(knownNames, "736472000");
        this.addName(knownNames, "736473005");
        this.addName(knownNames, "736474004");
        this.addName(knownNames, "736475003");
        this.addName(knownNames, "736476002");
        this.addName(knownNames, "736518005");
        this.addName(knownNames, "738774007");
        this.addName(knownNames, "762705008");
        this.addName(knownNames, "762706009");
        this.addName(knownNames, "762949000");
        this.addName(knownNames, "762951001");
        this.addName(knownNames, "763032000");
        this.addName(knownNames, "766939001");
        this.addName(knownNames, "774081006");
        this.addName(knownNames, "774158006");
        this.addName(knownNames, "774159003");
        this.addName(knownNames, "774160008");
        this.addName(knownNames, "774163005");
        this.addName(knownNames, "827081001");
        this.addName(knownNames, "836358009");
        this.addName(knownNames, "840560000");
        this.addName(knownNames, "860779006");
        this.addName(knownNames, "860781008");
        this.addName(knownNames, "1003703000");
        this.addName(knownNames, "1003735000");
        this.addName(knownNames, "1142135004");
        this.addName(knownNames, "1142136003");
        this.addName(knownNames, "1142137007");
        this.addName(knownNames, "1142138002");
        this.addName(knownNames, "1142139005");
        this.addName(knownNames, "1142140007");
        this.addName(knownNames, "1142141006");
        this.addName(knownNames, "1142142004");
        this.addName(knownNames, "1142143009");
        this.addName(knownNames, "1148793005");
        this.addName(knownNames, "1148965004");
        this.addName(knownNames, "1148967007");
        this.addName(knownNames, "1148968002");
        this.addName(knownNames, "1148969005");
        this.addName(knownNames, "1149366004");
        this.addName(knownNames, "1149367008");
        this.addName(knownNames, "1230370004");
        this.addName(knownNames, "320091000221107");
    }

    @Override
    public ValueSetValidator.PropertyValidationRules rulesForFilter(String property, EnumSet<ValueSetValidator.PropertyOperation> ops) {
        switch (property) {
            case "constraint": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.String, null, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals)).setActive(true);
            }
            case "expressions": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In));
            }
            case "inactive": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Boolean, null, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In));
            }
            case "concept": {
                return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, this.addToOps(ops, ValueSetValidator.PropertyOperation.IsA, ValueSetValidator.PropertyOperation.IsNotA, ValueSetValidator.PropertyOperation.In, ValueSetValidator.PropertyOperation.DescendentOf, ValueSetValidator.PropertyOperation.DescendentLeaf));
            }
        }
        return new ValueSetValidator.PropertyValidationRules(ValueSetValidator.PropertyFilterType.Code, ValueSetValidator.CodeValidationRule.Error, this.addToOps(ops, ValueSetValidator.PropertyOperation.Equals, ValueSetValidator.PropertyOperation.In));
    }

    @Override
    public CodeSystemChecker.StringWithFlag checkFilterValue(String system, String version, String property, String op, String value, ValueSetValidator.PropertyValidationRules rules, ValidationOptions options) {
        ValueSet vs = new ValueSet();
        vs.setStatus(Enumerations.PublicationStatus.DRAFT);
        vs.getCompose().addInclude().setSystem(system).setVersion(version).addFilter().setProperty("constraint").setOp(Enumerations.FilterOperator.EQUAL).setValue(value);
        try {
            return this.process(this.context.validateTxResource(options, (Resource)vs));
        }
        catch (EFhirClientException e) {
            return this.process(e.getServerError());
        }
        catch (Exception e) {
            return new CodeSystemChecker.StringWithFlag(e.getMessage(), false);
        }
    }

    private CodeSystemChecker.StringWithFlag process(OperationOutcome oo) {
        for (OperationOutcome.OperationOutcomeIssueComponent iss : oo.getIssue()) {
            if (!this.hasLocation(iss, "ValueSet.include.filter.value[0]", "ValueSet.compose.include[0].filter[0].value")) continue;
            return new CodeSystemChecker.StringWithFlag(iss.getText(), false);
        }
        if (oo.getIssue().size() == 1 && oo.getIssueFirstRep().getLocation().size() == 0) {
            return new CodeSystemChecker.StringWithFlag(oo.getIssueFirstRep().getText(), true);
        }
        return null;
    }

    private boolean hasLocation(OperationOutcome.OperationOutcomeIssueComponent iss, String ... paths) {
        for (StringType loc : iss.getLocation()) {
            for (String path : paths) {
                if (!path.equals(loc.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

