/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;
import org.hl7.fhir.validation.codegen.TypeInfo;

public class JavaFactoryGenerator
extends JavaBaseGenerator {
    public JavaFactoryGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
    }

    public void generate() throws Exception {
        String template = this.config.getAdornments().get("TypeFactory");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{resource-factory}}", this.genResourceFactory());
        template = template.replace("{{type-factory}}", this.genTypeFactory());
        template = template.replace("{{case-factory}}", this.genCaseFactory());
        this.write(template);
        this.flush();
        this.close();
    }

    private String genResourceFactory() {
        StringBuilder b = new StringBuilder();
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            String tn = ((TypeInfo)sd.getUserData("java.type.info")).getName();
            b.append("        if (\"" + sd.getName() + "\".equals(name))\r\n");
            b.append("            return new " + tn + "();\r\n");
        }
        return b.toString();
    }

    private String genTypeFactory() {
        StringBuilder b = new StringBuilder();
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            String tn = ((TypeInfo)sd.getUserData("java.type.info")).getName();
            b.append("        if (\"" + sd.getName() + "\".equals(name))\r\n");
            b.append("            return new " + tn + "();\r\n");
        }
        return b.toString();
    }

    private String genCaseFactory() {
        StringBuilder b = new StringBuilder();
        for (StructureDefinition sd : this.definitions.getStructures().getSortedList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getAbstract()) continue;
            String tn = ((TypeInfo)sd.getUserData("java.type.info")).getName();
            b.append("        case " + Integer.toString(sd.getName().hashCode()) + ": return new " + tn + "();\r\n");
        }
        return b.toString();
    }
}

