/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.scoring;

import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.validation.instance.scoring.ScoredElement;

public class ScoringReporter {
    private static final String TEMPLATE_PLACEHOLDER_TITLE = "[%title%]";
    private static final String TEMPLATE_PLACEHOLDER_CONTENT = "[%content%]";
    private final DecimalFormat scoreFormat = new DecimalFormat("#0.0");
    private final DecimalFormat percentFormat = new DecimalFormat("#0.0%");

    public String generateReport(ScoredElement rootElement, String template, String reportTitle) {
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("Template cannot be null or empty");
        }
        String content = this.generateReportContent(rootElement);
        return template.replace(TEMPLATE_PLACEHOLDER_TITLE, reportTitle != null ? reportTitle : "FHIR Resource Quality Scoring Report").replace(TEMPLATE_PLACEHOLDER_CONTENT, content);
    }

    public String generateReportContent(ScoredElement rootElement) {
        if (rootElement == null) {
            return this.generateEmptyReport();
        }
        StringBuilder html = new StringBuilder();
        html.append(this.generateReportHeader(rootElement));
        html.append(this.generateSummarySection(rootElement));
        html.append(this.generateHierarchicalSection(rootElement));
        return html.toString();
    }

    private String generateEmptyReport() {
        return "<div class=\"alert alert-warning\">\n    <h4>No Scoring Data Available</h4>\n    <p>No FHIR resource scoring data was found to generate a report.</p>\n</div>\n";
    }

    private String generateReportHeader(ScoredElement rootElement) {
        LocalDateTime now = LocalDateTime.now();
        String timestamp = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        ElementStats stats = this.calculateElementStats(rootElement);
        double overallQuality = rootElement.getPossibleScore() > 0.0 ? rootElement.getScore() / rootElement.getPossibleScore() : 0.0;
        return String.format("<div class=\"row mb-4\">\n    <div class=\"col-12\">\n        <div class=\"card\">\n            <div class=\"card-header\">\n                <h3 class=\"mb-0\">FHIR Resource Quality Scoring Report</h3>\n                <small class=\"text-muted\">Generated on %s</small>\n            </div>\n            <div class=\"card-body\">\n                <div class=\"row mb-3\">\n                    <div class=\"col-12\">\n                        <h5>Resource: <span class=\"text-primary\">%s</span> <small class=\"text-muted\">(%s)</small></h5>\n                    </div>\n                </div>\n                <div class=\"row\">\n                    <div class=\"col-md-3\">\n                        <div class=\"text-center\">\n                            <h4 class=\"text-info\">%d</h4>\n                            <small>Total Elements</small>\n                        </div>\n                    </div>\n                    <div class=\"col-md-3\">\n                        <div class=\"text-center\">\n                            <h4 class=\"text-success\">%s</h4>\n                            <small>Total Score</small>\n                        </div>\n                    </div>\n                    <div class=\"col-md-3\">\n                        <div class=\"text-center\">\n                            <h4 class=\"text-secondary\">%s</h4>\n                            <small>Possible Score</small>\n                        </div>\n                    </div>\n                    <div class=\"col-md-3\">\n                        <div class=\"text-center\">\n                            <h4 class=\"%s\">%s</h4>\n                            <small>Overall Quality</small>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n", timestamp, rootElement.getName(), rootElement.getFhirType(), stats.totalElements, this.scoreFormat.format(rootElement.getScore()), this.scoreFormat.format(rootElement.getPossibleScore()), this.getQualityColorClass(overallQuality), this.percentFormat.format(overallQuality));
    }

    private String generateSummarySection(ScoredElement rootElement) {
        ElementStats stats = this.calculateElementStats(rootElement);
        double overallQuality = rootElement.getPossibleScore() > 0.0 ? rootElement.getScore() / rootElement.getPossibleScore() : 0.0;
        return String.format("<div class=\"row mb-4\">\n    <div class=\"col-12\">\n        <h4>Scoring Summary</h4>\n        <div class=\"table-responsive\">\n            <table class=\"table table-sm\">\n                <tr>\n                    <td><strong>Overall Quality</strong></td>\n                    <td class=\"text-end\"><span class=\"badge %s\">%s</span></td>\n                </tr>\n                <tr>\n                    <td>Total Score</td>\n                    <td class=\"text-end\">%s / %s</td>\n                </tr>\n                <tr>\n                    <td>Elements Evaluated</td>\n                    <td class=\"text-end\">%d total</td>\n                </tr>\n                <tr>\n                    <td>Perfect Scores</td>\n                    <td class=\"text-end\"><span class=\"text-success\">%d elements</span></td>\n                </tr>\n                <tr>\n                    <td>Partial Scores</td>\n                    <td class=\"text-end\"><span class=\"text-warning\">%d elements</span></td>\n                </tr>\n                <tr>\n                    <td>Zero Scores</td>\n                    <td class=\"text-end\"><span class=\"text-danger\">%d elements</span></td>\n                </tr>\n            </table>\n        </div>\n    </div>\n</div>\n", this.getQualityBadgeClass(overallQuality), this.percentFormat.format(overallQuality), this.scoreFormat.format(rootElement.getScore()), this.scoreFormat.format(rootElement.getPossibleScore()), stats.totalElements, stats.perfectElements, stats.partialElements, stats.zeroElements);
    }

    private String generateHierarchicalSection(ScoredElement rootElement) {
        StringBuilder html = new StringBuilder();
        html.append("<div class=\"row mb-4\">\n    <div class=\"col-12\">\n        <h4>Scored Elements Breakdown</h4>\n        <p class=\"text-muted\">Elements with scores or containing scored child elements</p>\n        <div class=\"card\">\n            <div class=\"card-body p-0\">\n");
        html.append(this.generateElementTree(rootElement, 0, true));
        html.append("            </div>\n        </div>\n    </div>\n</div>\n");
        html.append("<div class=\"row\">\n    <div class=\"col-12\">\n        <h4>Complete Element Structure</h4>\n        <p class=\"text-muted\">All elements in the resource hierarchy</p>\n        <div class=\"card\">\n            <div class=\"card-body p-0\">\n");
        html.append(this.generateElementTree(rootElement, 0, false));
        html.append("            </div>\n        </div>\n    </div>\n</div>\n");
        return html.toString();
    }

    private String generateElementTree(ScoredElement element, int level, boolean filtered) {
        StringBuilder html = new StringBuilder();
        if (filtered && !this.hasScoreOrScoredChildren(element)) {
            return "";
        }
        double quality = element.getPossibleScore() > 0.0 ? element.getScore() / element.getPossibleScore() : 0.0;
        String indent = "&nbsp;".repeat(level * 4);
        String levelIndicator = this.generateLevelIndicator(level);
        String rulesInfo = "";
        if (element.getRules() != null && !element.getRules().isEmpty()) {
            StringBuilder rules = new StringBuilder();
            rules.append(" <small class=\"text-info\">[");
            for (int i = 0; i < element.getRules().size(); ++i) {
                if (i > 0) {
                    rules.append(", ");
                }
                Extension rule = element.getRules().get(i);
                String points = this.extractPointsFromRule(rule);
                String ruleCode = this.extractRuleCodeFromRule(rule);
                String condition = this.extractConditionFromRule(rule);
                rules.append(points).append("pts for ").append(ruleCode);
                if (condition == null || condition.isEmpty()) continue;
                rules.append(" (condition: ").append(condition).append(")");
            }
            rules.append("]</small>");
            rulesInfo = rules.toString();
        }
        String reasonsInfo = "";
        if (element.getReasons() != null && !element.getReasons().isEmpty()) {
            StringBuilder reasons = new StringBuilder();
            reasons.append(" <small class=\"text-muted\">[");
            for (int i = 0; i < element.getReasons().size(); ++i) {
                if (i > 0) {
                    reasons.append("; ");
                }
                reasons.append(this.escapeHtml(element.getReasons().get(i)));
            }
            reasons.append("]</small>");
            reasonsInfo = reasons.toString();
        }
        html.append(String.format("<div class=\"p-2 border-bottom\" style=\"font-family: monospace;\">\n    %s%s <strong>%s</strong> <span class=\"text-muted\">(%s)</span>\n    <span class=\"text-end float-end\">\n        <span class=\"text-muted\">%s / %s</span>\n        <span class=\"badge %s ms-2\">%s</span>\n    </span>%s%s\n</div>\n", indent, levelIndicator, this.escapeHtml(element.getName()), this.escapeHtml(element.getFhirType()), this.scoreFormat.format(element.getScore()), this.scoreFormat.format(element.getPossibleScore()), this.getQualityBadgeClass(quality), this.percentFormat.format(quality), rulesInfo, reasonsInfo));
        if (element.getChildren() != null && !element.getChildren().isEmpty()) {
            for (ScoredElement child : element.getChildren()) {
                html.append(this.generateElementTree(child, level + 1, filtered));
            }
        }
        return html.toString();
    }

    private String generateLevelIndicator(int level) {
        if (level == 0) {
            return "\ud83d\udccb";
        }
        return "\u251c\u2500";
    }

    private boolean hasScoreOrScoredChildren(ScoredElement element) {
        if (element.getPossibleScore() > 0.0) {
            return true;
        }
        if (element.getChildren() != null) {
            for (ScoredElement child : element.getChildren()) {
                if (!this.hasScoreOrScoredChildren(child)) continue;
                return true;
            }
        }
        return false;
    }

    private String extractPointsFromRule(Extension rule) {
        if (rule.hasValue() && rule.getValue().primitiveValue() != null) {
            return rule.getValue().primitiveValue();
        }
        return "0";
    }

    private String extractRuleCodeFromRule(Extension rule) {
        ArrayList<String> codes = new ArrayList<String>();
        for (Extension se : rule.getExtensionsByUrl("rule")) {
            codes.add(se.getValue().primitiveValue());
        }
        if (codes.isEmpty()) {
            return "{existing}";
        }
        Collections.sort(codes);
        return CommaSeparatedStringBuilder.join((String)",", codes);
    }

    private String extractConditionFromRule(Extension rule) {
        if (rule.hasExtension("condition")) {
            return rule.getExtensionString("condition");
        }
        return null;
    }

    private ElementStats calculateElementStats(ScoredElement rootElement) {
        ElementStats stats = new ElementStats();
        this.calculateStatsRecursively(rootElement, stats);
        return stats;
    }

    private void calculateStatsRecursively(ScoredElement element, ElementStats stats) {
        ++stats.totalElements;
        if (element.getPossibleScore() > 0.0) {
            double quality = element.getScore() / element.getPossibleScore();
            if (quality >= 1.0) {
                ++stats.perfectElements;
            } else if (quality > 0.0) {
                ++stats.partialElements;
            } else {
                ++stats.zeroElements;
            }
        } else {
            ++stats.zeroElements;
        }
        if (element.getChildren() != null) {
            for (ScoredElement child : element.getChildren()) {
                this.calculateStatsRecursively(child, stats);
            }
        }
    }

    private String getQualityColorClass(double qualityPercentage) {
        if (qualityPercentage >= 0.9) {
            return "text-success";
        }
        if (qualityPercentage >= 0.7) {
            return "text-warning";
        }
        return "text-danger";
    }

    private String getQualityBadgeClass(double qualityPercentage) {
        if (qualityPercentage >= 0.9) {
            return "bg-success";
        }
        if (qualityPercentage >= 0.7) {
            return "bg-warning";
        }
        return "bg-danger";
    }

    private String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;");
    }

    private static class ElementStats {
        int totalElements = 0;
        int perfectElements = 0;
        int partialElements = 0;
        int zeroElements = 0;

        private ElementStats() {
        }
    }
}

