/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.ai;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccessor;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.validation.ai.AIAPI;
import org.hl7.fhir.validation.ai.CodeAndTextValidationRequest;
import org.hl7.fhir.validation.ai.CodeAndTextValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaudeAPI
extends AIAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClaudeAPI.class);
    private static final String API_URL = "https://api.anthropic.com/v1/messages";
    private static final String MODEL = "claude-3-5-sonnet-20241022";
    private String model;

    protected ClaudeAPI(JsonObject config) {
        super(config);
        this.model = config.has("model") ? config.asString("model") : MODEL;
    }

    @Override
    public List<CodeAndTextValidationResult> validateCodings(List<CodeAndTextValidationRequest> requests) throws IOException {
        ArrayList<List<CodeAndTextValidationRequest>> chunks = new ArrayList<List<CodeAndTextValidationRequest>>();
        for (int i = 0; i < requests.size(); i += 4) {
            chunks.add(requests.subList(i, Math.min(i + 4, requests.size())));
        }
        ArrayList<CodeAndTextValidationResult> results = new ArrayList<CodeAndTextValidationResult>();
        int c = 0;
        for (List list : chunks) {
            StringBuilder prompt = new StringBuilder();
            for (String s : this.config.forceArray("prompt").asStrings()) {
                prompt.append(s);
                prompt.append("\n");
            }
            for (int i = 0; i < list.size(); ++i) {
                CodeAndTextValidationRequest req = (CodeAndTextValidationRequest)list.get(i);
                prompt.append(String.format(this.config.asString("item"), Integer.toString(i + 1), req.getText(), this.getSystemName(req.getSystem()), req.getCode(), req.getDisplay(), req.getContext(), req.getLang()));
                prompt.append("\n");
            }
            StringBuilder systemPrompt = new StringBuilder();
            for (String s : this.config.forceArray("prompt").asStrings()) {
                systemPrompt.append(s);
                systemPrompt.append("\n");
            }
            System.out.print(".");
            log.debug("  processed request");
            JsonObject json = this.getResponse(prompt.toString(), systemPrompt.toString());
            this.parseValidationResponse(json, list, results);
            c += 4;
        }
        return results;
    }

    public JsonObject getResponse(String prompt, String systemPrompt) throws IOException {
        JsonObject j = new JsonObject();
        j.add("model", this.model);
        j.add("system", systemPrompt);
        j.add("max_tokens", 1024);
        j.forceArray("messages").addObject().add("role", "user").add("content", prompt);
        ManagedWebAccessor web = ManagedWebAccess.accessor((Iterable)Utilities.strings((String[])new String[]{"web"}));
        web.getHeaders().put("anthropic-version", "2023-06-01");
        HTTPResult response = web.post(API_URL, JsonParser.composeBytes((JsonElement)j), "application/json", "application/json");
        response.checkThrowException();
        JsonObject json = JsonParser.parseObject((String)response.getContentAsString());
        String text = json.getJsonArray("content").get(0).asJsonObject().asString("text");
        FileUtilities.stringToFile((String)text, (String)Utilities.path((String[])new String[]{"[tmp]", "fhir-validator-claude-response.json"}));
        return JsonParser.parseObject((String)text);
    }

    private void parseValidationResponse(JsonObject json, List<CodeAndTextValidationRequest> requests, List<CodeAndTextValidationResult> res) {
        for (JsonObject o : ((JsonProperty)json.getProperties().get(0)).getValue().asJsonArray().asJsonObjects()) {
            CodeAndTextValidationRequest request = requests.get(o.asInteger("index") - 1);
            res.add(new CodeAndTextValidationResult(request, o.asBoolean("isCompatible"), o.asString("explanation"), o.asString("confidence")));
        }
    }
}

