package org.hl7.fhir.validation.instance;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;

import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.StructureDefinition;

public class SpecialExtensions {

  // copied from R5 spec
  private static final String MUST_SUPPORT_SOURCE = "{\"resourceType\" : \"StructureDefinition\",\"id\" : \"elementdefinition-type-must-support\",\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\",\"valueCode\" : \"fhir\"},{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\",\"valueInteger\" : 1}],\"url\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support\",\"version\" : \"4.5.0\",\"name\" : \"type-must-support\",\"status\" : \"draft\",\"date\" : \"2015-02-28\",\"publisher\" : \"Health Level Seven, Inc. - FHIR Core WG\",\"contact\" : [{\"telecom\" : [{\"system\" : \"url\",\"value\" : \"http://www.hl7.org/Special/committees/FHIR\"}]}],\"description\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"fhirVersion\" : \"4.5.0\",\"mapping\" : [{\"identity\" : \"rim\",\"uri\" : \"http://hl7.org/v3\",\"name\" : \"RIM Mapping\"}],\"kind\" : \"complex-type\",\"abstract\" : false,\"context\" : [{\"type\" : \"element\",\"expression\" : \"ElementDefinition.type\"},{\"type\" : \"element\",\"expression\" : \"ElementDefinition.type.profile\"},{\"type\" : \"element\",\"expression\" : \"ElementDefinition.type.targetProfile\"}],\"type\" : \"Extension\",\"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\",\"derivation\" : \"constraint\",\"snapshot\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"The specified type/profile/target must be supported by implementations\",\"definition\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"comment\" : \"An element may be labelled as must support. This extension clarifies which types/profiles/targetProfiles are must-support. It has no meaning if the element itself is not must-support. If the element is labelled must-support, and none of the options are labelled as must support, then an application must support at least one of the possible options, but is not required to support all of them.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension\",\"min\" : 0,\"max\" : \"*\"},\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false},{\"id\" : \"Extension.id\",\"path\" : \"Extension.id\",\"representation\" : [\"xmlAttr\"],\"short\" : \"Unique id for inter-element referencing\",\"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Element.id\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"string\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"n/a\"}]},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"slicing\" : {\"discriminator\" : [{\"type\" : \"value\",\"path\" : \"url\"}],\"description\" : \"Extensions are always sliced by (at least) url\",\"rules\" : \"open\"},\"short\" : \"Extension\",\"definition\" : \"An Extension\",\"min\" : 0,\"max\" : \"0\",\"base\" : {\"path\" : \"Element.extension\",\"min\" : 0,\"max\" : \"*\"},\"type\" : [{\"code\" : \"Extension\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false,\"isSummary\" : false},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"representation\" : [\"xmlAttr\"],\"short\" : \"identifies the meaning of the extension\",\"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\",\"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.url\",\"min\" : 1,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"uri\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support\",\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"short\" : \"Value of extension\",\"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.value[x]\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"code\" : \"boolean\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]}]},\"differential\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"The specified type/profile/target must be supported by implementations\",\"definition\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"comment\" : \"An element may be labelled as must support. This extension clarifies which types/profiles/targetProfiles are must-support. It has no meaning if the element itself is not must-support. If the element is labelled must-support, and none of the options are labelled as must support, then an application must support at least one of the possible options, but is not required to support all of them.\",\"min\" : 0,\"max\" : \"1\"},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"max\" : \"0\"},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support\"},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"min\" : 1,\"type\" : [{\"code\" : \"boolean\"}]}]}}";
  private static final String INSTANCE_NAME_SOURCE = "{\"resourceType\" : \"StructureDefinition\",\"id\" : \"instance-name\",\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\",\"valueCode\" : \"fhir\"},{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\",\"valueInteger\" : 1}],\"url\" : \"http://hl7.org/fhir/StructureDefinition/instance-name\",\"version\" : \"4.5.0\",\"name\" : \"instance-name\",\"status\" : \"draft\",\"date\" : \"2015-02-28\",\"publisher\" : \"Health Level Seven, Inc. - FHIR Core WG\",\"contact\" : [{\"telecom\" : [{\"system\" : \"url\",\"value\" : \"http://www.hl7.org/Special/committees/FHIR\"}]}],\"description\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"fhirVersion\" : \"4.5.0\",\"mapping\" : [{\"identity\" : \"rim\",\"uri\" : \"http://hl7.org/v3\",\"name\" : \"RIM Mapping\"}],\"kind\" : \"complex-type\",\"abstract\" : false,\"context\" : [{\"type\" : \"element\",\"expression\" : \"Resource.meta\"}],\"type\" : \"Extension\",\"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\",\"derivation\" : \"constraint\",\"snapshot\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"The specified type/profile/target must be supported by implementations\",\"definition\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"comment\" : \"todo.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension\",\"min\" : 0,\"max\" : \"*\"},\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false},{\"id\" : \"Extension.id\",\"path\" : \"Extension.id\",\"representation\" : [\"xmlAttr\"],\"short\" : \"Unique id for inter-element referencing\",\"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Element.id\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"string\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"n/a\"}]},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"slicing\" : {\"discriminator\" : [{\"type\" : \"value\",\"path\" : \"url\"}],\"description\" : \"Extensions are always sliced by (at least) url\",\"rules\" : \"open\"},\"short\" : \"Extension\",\"definition\" : \"An Extension\",\"min\" : 0,\"max\" : \"0\",\"base\" : {\"path\" : \"Element.extension\",\"min\" : 0,\"max\" : \"*\"},\"type\" : [{\"code\" : \"Extension\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false,\"isSummary\" : false},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"representation\" : [\"xmlAttr\"],\"short\" : \"identifies the meaning of the extension\",\"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\",\"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.url\",\"min\" : 1,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"uri\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/instance-name\",\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"short\" : \"Value of extension\",\"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.value[x]\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"code\" : \"string\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]}]},\"differential\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"The specified type/profile/target must be supported by implementations\",\"definition\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"comment\" : \"todo.\",\"min\" : 0,\"max\" : \"1\"},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"max\" : \"0\"},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/instance-name\"},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"min\" : 1,\"type\" : [{\"code\" : \"string\"}]}]}}";
  private static final String INSTANCE_DESC_SOURCE = "{\"resourceType\" : \"StructureDefinition\",\"id\" : \"instance-description\",\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\",\"valueCode\" : \"fhir\"},{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\",\"valueInteger\" : 1}],\"url\" : \"http://hl7.org/fhir/StructureDefinition/instance-description\",\"version\" : \"4.5.0\",\"name\" : \"instance-description\",\"status\" : \"draft\",\"date\" : \"2015-02-28\",\"publisher\" : \"Health Level Seven, Inc. - FHIR Core WG\",\"contact\" : [{\"telecom\" : [{\"system\" : \"url\",\"value\" : \"http://www.hl7.org/Special/committees/FHIR\"}]}],\"description\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"fhirVersion\" : \"4.5.0\",\"mapping\" : [{\"identity\" : \"rim\",\"uri\" : \"http://hl7.org/v3\",\"name\" : \"RIM Mapping\"}],\"kind\" : \"complex-type\",\"abstract\" : false,\"context\" : [{\"type\" : \"element\",\"expression\" : \"Resource.meta\"}],\"type\" : \"Extension\",\"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\",\"derivation\" : \"constraint\",\"snapshot\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"The specified type/profile/target must be supported by implementations\",\"definition\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"comment\" : \"todo.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension\",\"min\" : 0,\"max\" : \"*\"},\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false},{\"id\" : \"Extension.id\",\"path\" : \"Extension.id\",\"representation\" : [\"xmlAttr\"],\"short\" : \"Unique id for inter-element referencing\",\"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Element.id\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"markdown\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"n/a\"}]},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"slicing\" : {\"discriminator\" : [{\"type\" : \"value\",\"path\" : \"url\"}],\"description\" : \"Extensions are always sliced by (at least) url\",\"rules\" : \"open\"},\"short\" : \"Extension\",\"definition\" : \"An Extension\",\"min\" : 0,\"max\" : \"0\",\"base\" : {\"path\" : \"Element.extension\",\"min\" : 0,\"max\" : \"*\"},\"type\" : [{\"code\" : \"Extension\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false,\"isSummary\" : false},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"representation\" : [\"xmlAttr\"],\"short\" : \"identifies the meaning of the extension\",\"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\",\"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.url\",\"min\" : 1,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"uri\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/instance-description\",\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"short\" : \"Value of extension\",\"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.value[x]\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"code\" : \"markdown\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]}]},\"differential\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"The specified type/profile/target must be supported by implementations\",\"definition\" : \"If true indicates that the specified type, profile or targetProfile must be supported by implementations.\",\"comment\" : \"todo.\",\"min\" : 0,\"max\" : \"1\"},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"max\" : \"0\"},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/instance-description\"},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"min\" : 1,\"type\" : [{\"code\" : \"markdown\"}]}]}}";
  private static final String CODE_SYSTEM_PROPS_EXT = "{\"resourceType\" : \"StructureDefinition\",\"id\" : \"codesystem-properties-mode\",\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\",\"valueCode\" : \"vocab\"},{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\",\"valueInteger\" : 1}],\"url\" : \"http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode\",\"version\" : \"4.6.0\",\"name\" : \"properties-mode\",\"status\" : \"draft\",\"date\" : \"2021-01-02T08:58:31+11:00\",\"publisher\" : \"HL7\",\"description\" : \"The extent to which the properties of the code system (including the filters) are represented in this resource instance.\",\"fhirVersion\" : \"4.6.0\",\"mapping\" : [{\"identity\" : \"rim\",\"uri\" : \"http://hl7.org/v3\",\"name\" : \"RIM Mapping\"}],\"kind\" : \"complex-type\",\"abstract\" : false,\"context\" : [{\"type\" : \"element\",\"expression\" : \"CodeSystem\"}],\"type\" : \"Extension\",\"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\",\"derivation\" : \"constraint\",\"snapshot\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"not-present | partial | complete\",\"definition\" : \"The extent to which the properties of the code system (including the filters) are represented in this resource instance.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension\",\"min\" : 0,\"max\" : \"*\"},\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false},{\"id\" : \"Extension.id\",\"path\" : \"Extension.id\",\"representation\" : [\"xmlAttr\"],\"short\" : \"Unique id for inter-element referencing\",\"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Element.id\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"string\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"n/a\"}]},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"slicing\" : {\"discriminator\" : [{\"type\" : \"value\",\"path\" : \"url\"}],\"description\" : \"Extensions are always sliced by (at least) url\",\"rules\" : \"open\"},\"short\" : \"Extension\",\"definition\" : \"An Extension\",\"min\" : 0,\"max\" : \"0\",\"base\" : {\"path\" : \"Element.extension\",\"min\" : 0,\"max\" : \"*\"},\"type\" : [{\"code\" : \"Extension\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false,\"isSummary\" : false},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"representation\" : [\"xmlAttr\"],\"short\" : \"identifies the meaning of the extension\",\"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\",\"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.url\",\"min\" : 1,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"uri\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode\",\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"short\" : \"Value of extension\",\"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.value[x]\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"code\" : \"code\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"}],\"isModifier\" : false,\"isSummary\" : false,\"binding\" : {\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName\",\"valueString\" : \"CodeSystemPropertiesMode\"}],\"strength\" : \"required\",\"description\" : \"The extent to which the properties of the code system (including the filters) are represented in a code system resource.\",\"valueSet\" : \"http://hl7.org/fhir/ValueSet/codesystem-properties-mode\"},\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]}]},\"differential\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"not-present | partial | complete\",\"definition\" : \"The extent to which the properties of the code system (including the filters) are represented in this resource instance.\",\"min\" : 0,\"max\" : \"1\",\"isModifier\" : false},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"max\" : \"0\"},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode\"},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"min\" : 1,\"type\" : [{\"code\" : \"code\"}],\"binding\" : {\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName\",\"valueString\" : \"CodeSystemPropertiesMode\"}],\"strength\" : \"required\",\"description\" : \"The extent to which the properties of the code system (including the filters) are represented in a code system resource.\",\"valueSet\" : \"http://hl7.org/fhir/ValueSet/codesystem-properties-mode\"}}]}}";
  private static final String INSTANCE_DEFN = "{\"resourceType\" : \"StructureDefinition\",\"id\" : \"definition\",\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\",\"valueCode\" : \"fhir\"},{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\",\"valueInteger\" : 1}],\"url\" : \"http://hl7.org/fhir/StructureDefinition/definition\",\"version\" : \"4.6.0\",\"name\" : \"properties-mode\",\"status\" : \"draft\",\"date\" : \"2021-01-02T08:58:31+11:00\",\"publisher\" : \"HL7\",\"description\" : \"BindingDefinition\",\"fhirVersion\" : \"4.6.0\",\"mapping\" : [{\"identity\" : \"rim\",\"uri\" : \"http://hl7.org/v3\",\"name\" : \"RIM Mapping\"}],\"kind\" : \"complex-type\",\"abstract\" : false,\"context\" : [{\"type\" : \"element\",\"expression\" : \"CodeSystem\"}],\"type\" : \"Extension\",\"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\",\"derivation\" : \"constraint\",\"snapshot\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"not-present | partial | complete\",\"definition\" : \"The extent to which the properties of the code system (including the filters) are represented in this resource instance.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension\",\"min\" : 0,\"max\" : \"*\"},\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false},{\"id\" : \"Extension.id\",\"path\" : \"Extension.id\",\"representation\" : [\"xmlAttr\"],\"short\" : \"Unique id for inter-element referencing\",\"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\",\"min\" : 0,\"max\" : \"1\",\"base\" : {\"path\" : \"Element.id\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"string\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"n/a\"}]},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"slicing\" : {\"discriminator\" : [{\"type\" : \"value\",\"path\" : \"url\"}],\"description\" : \"Extensions are always sliced by (at least) url\",\"rules\" : \"open\"},\"short\" : \"Extension\",\"definition\" : \"An Extension\",\"min\" : 0,\"max\" : \"0\",\"base\" : {\"path\" : \"Element.extension\",\"min\" : 0,\"max\" : \"*\"},\"type\" : [{\"code\" : \"Extension\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"},{\"key\" : \"ext-1\",\"severity\" : \"error\",\"human\" : \"Must have either extensions or value[x], not both\",\"expression\" : \"extension.exists() != value.exists()\",\"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\"}],\"isModifier\" : false,\"isSummary\" : false},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"representation\" : [\"xmlAttr\"],\"short\" : \"identifies the meaning of the extension\",\"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\",\"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.url\",\"min\" : 1,\"max\" : \"1\"},\"type\" : [{\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\",\"valueUrl\" : \"uri\"}],\"code\" : \"http://hl7.org/fhirpath/System.String\"}],\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/definition\",\"isModifier\" : false,\"isSummary\" : false,\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"short\" : \"Value of extension\",\"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\",\"min\" : 1,\"max\" : \"1\",\"base\" : {\"path\" : \"Extension.value[x]\",\"min\" : 0,\"max\" : \"1\"},\"type\" : [{\"code\" : \"string\"}],\"constraint\" : [{\"key\" : \"ele-1\",\"severity\" : \"error\",\"human\" : \"All FHIR elements must have a @value or children\",\"expression\" : \"hasValue() or (children().count() > id.count())\",\"xpath\" : \"@value|f:*|h:div\",\"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\"}],\"isModifier\" : false,\"isSummary\" : false,\"binding\" : {\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName\",\"valueString\" : \"CodeSystemPropertiesMode\"}],\"strength\" : \"required\",\"description\" : \"The extent to which the properties of the code system (including the filters) are represented in a code system resource.\",\"valueSet\" : \"http://hl7.org/fhir/ValueSet/codesystem-properties-mode\"},\"mapping\" : [{\"identity\" : \"rim\",\"map\" : \"N/A\"}]}]},\"differential\" : {\"element\" : [{\"id\" : \"Extension\",\"path\" : \"Extension\",\"short\" : \"not-present | partial | complete\",\"definition\" : \"The extent to which the properties of the code system (including the filters) are represented in this resource instance.\",\"min\" : 0,\"max\" : \"1\",\"isModifier\" : false},{\"id\" : \"Extension.extension\",\"path\" : \"Extension.extension\",\"max\" : \"0\"},{\"id\" : \"Extension.url\",\"path\" : \"Extension.url\",\"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode\"},{\"id\" : \"Extension.value[x]\",\"path\" : \"Extension.value[x]\",\"min\" : 1,\"type\" : [{\"code\" : \"code\"}],\"binding\" : {\"extension\" : [{\"url\" : \"http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName\",\"valueString\" : \"CodeSystemPropertiesMode\"}],\"strength\" : \"required\",\"description\" : \"The extent to which the properties of the code system (including the filters) are represented in a code system resource.\",\"valueSet\" : \"http://hl7.org/fhir/ValueSet/codesystem-properties-mode\"}}]}}";
  private static final String CONFORMANCE_DERIVED = "{ \"resourceType\" : \"StructureDefinition\", \"id\" : \"structuredefinition-conformance-derivedFrom\", \"extension\" : [{ \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\", \"valueCode\" : \"fhir\" }, { \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\", \"valueInteger\" : 1 }], \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom\", \"version\" : \"4.6.0\", \"name\" : \"fmm\", \"status\" : \"draft\", \"date\" : \"2014-01-31\", \"publisher\" : \"Health Level Seven, Inc. - [WG Name] WG\", \"contact\" : [{ \"telecom\" : [{ \"system\" : \"url\", \"value\" : \"http://www.hl7.org/Special/committees/FHIR\" }] }], \"description\" : \"Indicates one of the resources that was used to infer the specified maturity or standards status\", \"fhirVersion\" : \"4.6.0\", \"mapping\" : [{ \"identity\" : \"rim\", \"uri\" : \"http://hl7.org/v3\", \"name\" : \"RIM Mapping\" }], \"kind\" : \"complex-type\", \"abstract\" : false, \"context\" : [{ \"type\" : \"fhirpath\", \"expression\" : \"extension('http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm').value\" }, { \"type\" : \"fhirpath\", \"expression\" : \"extension('http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status').value\" }], \"type\" : \"Extension\", \"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\", \"derivation\" : \"constraint\", \"snapshot\" : { \"element\" : [{ \"id\" : \"Extension\", \"path\" : \"Extension\", \"short\" : \"FMM Level\", \"definition\" : \"Indicates one of the resources that was used to infer the specified maturity or standards status\", \"min\" : 0, \"max\" : \"*\", \"base\" : { \"path\" : \"Extension\", \"min\" : 0, \"max\" : \"*\" }, \"constraint\" : [{ \"key\" : \"ele-1\", \"severity\" : \"error\", \"human\" : \"All FHIR elements must have a @value or children\", \"expression\" : \"hasValue() or (children().count() > id.count())\", \"xpath\" : \"@value|f:*|h:div\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\" }, { \"key\" : \"ext-1\", \"severity\" : \"error\", \"human\" : \"Must have either extensions or value[x], not both\", \"expression\" : \"extension.exists() != value.exists()\", \"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\" }], \"isModifier\" : false }, { \"id\" : \"Extension.id\", \"path\" : \"Extension.id\", \"representation\" : [\"xmlAttr\"], \"short\" : \"Unique id for inter-element referencing\", \"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\", \"min\" : 0, \"max\" : \"1\", \"base\" : { \"path\" : \"Element.id\", \"min\" : 0, \"max\" : \"1\" }, \"type\" : [{ \"extension\" : [{ \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\", \"valueUrl\" : \"string\" }], \"code\" : \"http://hl7.org/fhirpath/System.String\" }], \"isModifier\" : false, \"isSummary\" : false, \"mapping\" : [{ \"identity\" : \"rim\", \"map\" : \"n/a\" }] }, { \"id\" : \"Extension.extension\", \"path\" : \"Extension.extension\", \"slicing\" : { \"discriminator\" : [{ \"type\" : \"value\", \"path\" : \"url\" }], \"description\" : \"Extensions are always sliced by (at least) url\", \"rules\" : \"open\" }, \"short\" : \"Extension\", \"definition\" : \"An Extension\", \"min\" : 0, \"max\" : \"0\", \"base\" : { \"path\" : \"Element.extension\", \"min\" : 0, \"max\" : \"*\" }, \"type\" : [{ \"code\" : \"Extension\" }], \"constraint\" : [{ \"key\" : \"ele-1\", \"severity\" : \"error\", \"human\" : \"All FHIR elements must have a @value or children\", \"expression\" : \"hasValue() or (children().count() > id.count())\", \"xpath\" : \"@value|f:*|h:div\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\" }, { \"key\" : \"ext-1\", \"severity\" : \"error\", \"human\" : \"Must have either extensions or value[x], not both\", \"expression\" : \"extension.exists() != value.exists()\", \"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\" }], \"isModifier\" : false, \"isSummary\" : false }, { \"id\" : \"Extension.url\", \"path\" : \"Extension.url\", \"representation\" : [\"xmlAttr\"], \"short\" : \"identifies the meaning of the extension\", \"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\", \"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\", \"min\" : 1, \"max\" : \"1\", \"base\" : { \"path\" : \"Extension.url\", \"min\" : 1, \"max\" : \"1\" }, \"type\" : [{ \"extension\" : [{ \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\", \"valueUrl\" : \"uri\" }], \"code\" : \"http://hl7.org/fhirpath/System.String\" }], \"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom\", \"isModifier\" : false, \"isSummary\" : false, \"mapping\" : [{ \"identity\" : \"rim\", \"map\" : \"N/A\" }] }, { \"id\" : \"Extension.value[x]\", \"path\" : \"Extension.value[x]\", \"short\" : \"Value of extension\", \"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\", \"min\" : 1, \"max\" : \"1\", \"base\" : { \"path\" : \"Extension.value[x]\", \"min\" : 0, \"max\" : \"1\" }, \"type\" : [{ \"code\" : \"canonical\" }], \"constraint\" : [{ \"key\" : \"ele-1\", \"severity\" : \"error\", \"human\" : \"All FHIR elements must have a @value or children\", \"expression\" : \"hasValue() or (children().count() > id.count())\", \"xpath\" : \"@value|f:*|h:div\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\" }], \"isModifier\" : false, \"isSummary\" : false, \"mapping\" : [{ \"identity\" : \"rim\", \"map\" : \"N/A\" }] }] }, \"differential\" : { \"element\" : [{ \"id\" : \"Extension\", \"path\" : \"Extension\", \"short\" : \"FMM Level\", \"definition\" : \"Indicates one of the resources that was used to infer the specified maturity or standards status\", \"min\" : 0, \"max\" : \"*\" }, { \"id\" : \"Extension.extension\", \"path\" : \"Extension.extension\", \"max\" : \"0\" }, { \"id\" : \"Extension.url\", \"path\" : \"Extension.url\", \"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom\" }, { \"id\" : \"Extension.value[x]\", \"path\" : \"Extension.value[x]\", \"min\" : 1, \"type\" : [{ \"code\" : \"canonical\" }] }] } }";
  private static final String FMM_SUPPORT = "{ \"resourceType\" : \"StructureDefinition\", \"id\" : \"structuredefinition-fmm-support\", \"extension\" : [{ \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-wg\", \"valueCode\" : \"fhir\" }, { \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm\", \"valueInteger\" : 1 }], \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support\", \"version\" : \"4.6.0\", \"name\" : \"fmm\", \"status\" : \"draft\", \"date\" : \"2014-01-31\", \"publisher\" : \"Health Level Seven, Inc. - [WG Name] WG\", \"contact\" : [{ \"telecom\" : [{ \"system\" : \"url\", \"value\" : \"http://www.hl7.org/Special/committees/FHIR\" }] }], \"description\" : \"The documentation supporting the FMM level assigned to the artifact.\", \"fhirVersion\" : \"4.6.0\", \"mapping\" : [{ \"identity\" : \"rim\", \"uri\" : \"http://hl7.org/v3\", \"name\" : \"RIM Mapping\" }], \"kind\" : \"complex-type\", \"abstract\" : false, \"context\" : [{ \"type\" : \"element\", \"expression\" : \"Element\" }], \"type\" : \"Extension\", \"baseDefinition\" : \"http://hl7.org/fhir/StructureDefinition/Extension\", \"derivation\" : \"constraint\", \"snapshot\" : { \"element\" : [{ \"id\" : \"Extension\", \"path\" : \"Extension\", \"short\" : \"FMM Level\", \"definition\" : \"The documentation supporting the FMM level assigned to the artifact.\", \"comment\" : \"Though this is defined for resources, it can be used for any artifact.\", \"min\" : 0, \"max\" : \"1\", \"base\" : { \"path\" : \"Extension\", \"min\" : 0, \"max\" : \"*\" }, \"constraint\" : [{ \"key\" : \"ele-1\", \"severity\" : \"error\", \"human\" : \"All FHIR elements must have a @value or children\", \"expression\" : \"hasValue() or (children().count() > id.count())\", \"xpath\" : \"@value|f:*|h:div\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\" }, { \"key\" : \"ext-1\", \"severity\" : \"error\", \"human\" : \"Must have either extensions or value[x], not both\", \"expression\" : \"extension.exists() != value.exists()\", \"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\" }], \"isModifier\" : false }, { \"id\" : \"Extension.id\", \"path\" : \"Extension.id\", \"representation\" : [\"xmlAttr\"], \"short\" : \"Unique id for inter-element referencing\", \"definition\" : \"Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.\", \"min\" : 0, \"max\" : \"1\", \"base\" : { \"path\" : \"Element.id\", \"min\" : 0, \"max\" : \"1\" }, \"type\" : [{ \"extension\" : [{ \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\", \"valueUrl\" : \"string\" }], \"code\" : \"http://hl7.org/fhirpath/System.String\" }], \"isModifier\" : false, \"isSummary\" : false, \"mapping\" : [{ \"identity\" : \"rim\", \"map\" : \"n/a\" }] }, { \"id\" : \"Extension.extension\", \"path\" : \"Extension.extension\", \"slicing\" : { \"discriminator\" : [{ \"type\" : \"value\", \"path\" : \"url\" }], \"description\" : \"Extensions are always sliced by (at least) url\", \"rules\" : \"open\" }, \"short\" : \"Extension\", \"definition\" : \"An Extension\", \"min\" : 0, \"max\" : \"0\", \"base\" : { \"path\" : \"Element.extension\", \"min\" : 0, \"max\" : \"*\" }, \"type\" : [{ \"code\" : \"Extension\" }], \"constraint\" : [{ \"key\" : \"ele-1\", \"severity\" : \"error\", \"human\" : \"All FHIR elements must have a @value or children\", \"expression\" : \"hasValue() or (children().count() > id.count())\", \"xpath\" : \"@value|f:*|h:div\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\" }, { \"key\" : \"ext-1\", \"severity\" : \"error\", \"human\" : \"Must have either extensions or value[x], not both\", \"expression\" : \"extension.exists() != value.exists()\", \"xpath\" : \"exists(f:extension)!=exists(f:*[starts-with(local-name(.), \\\"value\\\")])\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Extension\" }], \"isModifier\" : false, \"isSummary\" : false }, { \"id\" : \"Extension.url\", \"path\" : \"Extension.url\", \"representation\" : [\"xmlAttr\"], \"short\" : \"identifies the meaning of the extension\", \"definition\" : \"Source of the definition for the extension code - a logical name or a URL.\", \"comment\" : \"The definition may point directly to a computable or human-readable definition of the extensibility codes, or it may be a logical URI as declared in some other specification. The definition SHALL be a URI for the Structure Definition defining the extension.\", \"min\" : 1, \"max\" : \"1\", \"base\" : { \"path\" : \"Extension.url\", \"min\" : 1, \"max\" : \"1\" }, \"type\" : [{ \"extension\" : [{ \"url\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type\", \"valueUrl\" : \"uri\" }], \"code\" : \"http://hl7.org/fhirpath/System.String\" }], \"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support\", \"isModifier\" : false, \"isSummary\" : false, \"mapping\" : [{ \"identity\" : \"rim\", \"map\" : \"N/A\" }] }, { \"id\" : \"Extension.value[x]\", \"path\" : \"Extension.value[x]\", \"short\" : \"Value of extension\", \"definition\" : \"Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).\", \"min\" : 1, \"max\" : \"1\", \"base\" : { \"path\" : \"Extension.value[x]\", \"min\" : 0, \"max\" : \"1\" }, \"type\" : [{ \"code\" : \"markdown\" }], \"constraint\" : [{ \"key\" : \"ele-1\", \"severity\" : \"error\", \"human\" : \"All FHIR elements must have a @value or children\", \"expression\" : \"hasValue() or (children().count() > id.count())\", \"xpath\" : \"@value|f:*|h:div\", \"source\" : \"http://hl7.org/fhir/StructureDefinition/Element\" }], \"isModifier\" : false, \"isSummary\" : false, \"mapping\" : [{ \"identity\" : \"rim\", \"map\" : \"N/A\" }] }] }, \"differential\" : { \"element\" : [{ \"id\" : \"Extension\", \"path\" : \"Extension\", \"short\" : \"FMM Level\", \"definition\" : \"The documentation supporting the FMM level assigned to the artifact.\", \"comment\" : \"Though this is defined for resources, it can be used for any artifact.\", \"min\" : 0, \"max\" : \"1\" }, { \"id\" : \"Extension.extension\", \"path\" : \"Extension.extension\", \"max\" : \"0\" }, { \"id\" : \"Extension.url\", \"path\" : \"Extension.url\", \"fixedUri\" : \"http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support\" }, { \"id\" : \"Extension.value[x]\", \"path\" : \"Extension.value[x]\", \"min\" : 1, \"type\" : [{ \"code\" : \"markdown\" }] }] } }";
  
  private static final HashSet<String> KNOWN_EXTENSIONS = new HashSet<>(Arrays.asList(
      "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
      "http://hl7.org/fhir/StructureDefinition/instance-name",
      "http://hl7.org/fhir/StructureDefinition/instance-description",
      "http://hl7.org/fhir/build/StructureDefinition/definition", // wrongly defined in used in R4B/R5 builds - changed to http://hl7.org/fhir/tools/StructureDefinition/binding-definition
      "http://hl7.org/fhir/build/StructureDefinition/binding-definition", // wrongly defined in used in R4B/R5 builds - http://hl7.org/fhir/tools/StructureDefinition/binding-definition
      "http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode",
      "http://hl7.org/fhir/StructureDefinition/structuredefinition-rdf-type",
      "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom", // this is defined in R5, but needed earlier
      "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support" // this is defined in R5, but needed earlier
      ));

  public static boolean isKnownExtension(String url) {
    return KNOWN_EXTENSIONS.contains(url);
  }

  public static StructureDefinition getDefinition(String url) {
    try {
    switch (url) {
    case "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support" : return makeExt(MUST_SUPPORT_SOURCE);
    case "http://hl7.org/fhir/StructureDefinition/instance-name" : return makeExt(INSTANCE_NAME_SOURCE);
    case "http://hl7.org/fhir/StructureDefinition/instance-description" : return makeExt(INSTANCE_DESC_SOURCE);
    case "http://hl7.org/fhir/StructureDefinition/definition" : return makeExt(INSTANCE_DEFN);
    case "http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode" : return makeExt(CODE_SYSTEM_PROPS_EXT);
    case "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom" : return makeExt(CONFORMANCE_DERIVED);
    case "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support" : return makeExt(FMM_SUPPORT);
    default: return null;
    }
    } catch (Exception e) {
      return null;
    }
  }

  private static StructureDefinition makeExt(String src) throws FHIRFormatError, IOException {
    return (StructureDefinition) new JsonParser().parse(src);
  }

}
